/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.spi.Path;

public class EventFilter {
    static final EventFilter BLOCK_ALL = new BlockAllFilter();
    private final SessionImpl session;
    private final long eventTypes;
    private final List<Path> paths;
    private final boolean isDeep;
    private final NodeId[] ids;
    private final NodeTypeImpl[] nodeTypes;
    private final boolean noLocal;
    private final boolean noExternal;
    private final boolean noInternal;

    EventFilter(SessionImpl session, long eventTypes, List<Path> paths, boolean isDeep, NodeId[] ids, NodeTypeImpl[] nodeTypes, boolean noLocal, boolean noExternal, boolean noInternal) {
        this.session = session;
        this.eventTypes = eventTypes;
        this.paths = paths;
        this.isDeep = isDeep;
        this.ids = ids;
        this.noLocal = noLocal;
        this.noExternal = noExternal;
        this.noInternal = noInternal;
        this.nodeTypes = nodeTypes;
    }

    boolean blocks(EventState eventState) throws RepositoryException {
        boolean match;
        long type = eventState.getType();
        if ((this.eventTypes & type) == 0L) {
            return true;
        }
        if (this.noLocal && this.session.equals(eventState.getSession())) {
            return true;
        }
        if (this.noExternal && eventState.isExternal()) {
            return true;
        }
        if (this.noInternal && !eventState.isExternal()) {
            return true;
        }
        if (eventState.getType() == 64) {
            return false;
        }
        NodeId parentId = eventState.getParentId();
        if (this.ids != null) {
            boolean match2 = false;
            for (int i = 0; i < this.ids.length && !match2; match2 |= parentId.equals(this.ids[i]), ++i) {
            }
            if (!match2) {
                return true;
            }
        }
        if (this.nodeTypes != null) {
            Set<NodeType> eventTypes = eventState.getNodeTypes(this.session.getNodeTypeManager());
            match = false;
            for (int i = 0; i < this.nodeTypes.length && !match; ++i) {
                for (NodeType eventType : eventTypes) {
                    NodeTypeImpl nodeType = (NodeTypeImpl)eventType;
                    match |= nodeType.getQName().equals(this.nodeTypes[i].getQName()) || nodeType.isDerivedFrom(this.nodeTypes[i].getQName());
                }
            }
            if (!match) {
                return true;
            }
        }
        Path eventPath = eventState.getParentPath();
        match = false;
        for (Path path : this.paths) {
            if (!eventPath.equals(path) && (!this.isDeep || !eventPath.isDescendantOf(path))) continue;
            match = true;
            break;
        }
        return !match;
    }

    private static final class BlockAllFilter
    extends EventFilter {
        BlockAllFilter() {
            super(null, 0L, Collections.emptyList(), true, null, null, true, true, true);
        }

        @Override
        boolean blocks(EventState eventState) {
            return true;
        }
    }
}

