/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cache;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.core.cache.Cache;
import org.apache.jackrabbit.core.cache.CacheAccessListener;

public abstract class AbstractCache
implements Cache {
    private final AtomicLong memoryUsed = new AtomicLong();
    private final AtomicLong maxMemorySize = new AtomicLong();
    private final AtomicLong accessCount = new AtomicLong();
    private final AtomicLong totalAccessCount = new AtomicLong();
    private final AtomicLong missCount = new AtomicLong();
    private final AtomicReference<CacheAccessListener> accessListener = new AtomicReference();

    protected boolean isTooBig() {
        return this.memoryUsed.get() > this.maxMemorySize.get();
    }

    protected void recordSizeChange(long delta) {
        this.memoryUsed.addAndGet(delta);
    }

    protected void recordCacheAccess() {
        CacheAccessListener listener;
        this.totalAccessCount.incrementAndGet();
        long count = this.accessCount.incrementAndGet();
        if (count % 127L == 0L && (listener = this.accessListener.get()) != null) {
            listener.cacheAccessed(127L);
        }
    }

    protected void recordCacheMiss() {
        this.missCount.incrementAndGet();
    }

    @Override
    public long getAccessCount() {
        return this.accessCount.get();
    }

    @Override
    public void resetAccessCount() {
        this.accessCount.set(0L);
    }

    @Override
    public long getTotalAccessCount() {
        return this.totalAccessCount.get();
    }

    @Override
    public long getMissCount() {
        return this.missCount.get();
    }

    @Override
    public void resetMissCount() {
        this.missCount.set(0L);
    }

    @Override
    public long getMemoryUsed() {
        return this.memoryUsed.get();
    }

    @Override
    public long getMaxMemorySize() {
        return this.maxMemorySize.get();
    }

    @Override
    public void setMaxMemorySize(long size) {
        this.maxMemorySize.set(size);
    }

    @Override
    public void setAccessListener(CacheAccessListener listener) {
        this.accessListener.set(listener);
    }

    public void dispose() {
        CacheAccessListener listener = this.accessListener.get();
        if (listener != null) {
            listener.disposeCache(this);
        }
    }

    @Override
    public String getCacheInfoAsString() {
        long u = this.getMemoryUsed() / 1024L;
        long m = this.getMaxMemorySize() / 1024L;
        StringBuilder c = new StringBuilder();
        c.append("cachename=");
        c.append(this.toString());
        c.append(", elements=");
        c.append(this.getElementCount());
        c.append(", usedmemorykb=");
        c.append(u);
        c.append(", maxmemorykb=");
        c.append(m);
        c.append(", access=");
        c.append(this.getTotalAccessCount());
        c.append(", miss=");
        c.append(this.getMissCount());
        return c.toString();
    }
}

