/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AbstractAccessControlManager;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;

class SystemSession
extends SessionImpl {
    static SystemSession create(RepositoryContext repositoryContext, WorkspaceConfig wspConfig) throws RepositoryException {
        Set<SystemPrincipal> principals = Collections.singleton(new SystemPrincipal());
        Subject subject = new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
        return new SystemSession(repositoryContext, subject, wspConfig);
    }

    private SystemSession(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws RepositoryException {
        super(repositoryContext, subject, wspConfig);
    }

    @Override
    protected String retrieveUserId(Subject subject, String workspaceName) throws RepositoryException {
        return new SystemPrincipal().getName();
    }

    @Override
    protected AccessManager createAccessManager(Subject subject) {
        return new SystemAccessManager();
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public boolean isAdmin() {
        return false;
    }

    private class SystemAccessManager
    extends AbstractAccessControlManager
    implements AccessManager {
        SystemAccessManager() {
        }

        @Override
        public void init(AMContext context) throws AccessDeniedException, Exception {
        }

        @Override
        public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessMgr) throws AccessDeniedException, Exception {
        }

        @Override
        public void close() throws Exception {
        }

        @Override
        public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, RepositoryException {
        }

        @Override
        public void checkPermission(Path absPath, int permissions) throws AccessDeniedException, RepositoryException {
        }

        @Override
        public void checkRepositoryPermission(int permissions) throws AccessDeniedException, RepositoryException {
        }

        @Override
        public boolean isGranted(ItemId id, int permissions) throws RepositoryException {
            return true;
        }

        @Override
        public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
            return true;
        }

        @Override
        public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
            return true;
        }

        @Override
        public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
            return true;
        }

        @Override
        public boolean canAccess(String workspaceName) throws RepositoryException {
            return true;
        }

        @Override
        protected void checkInitialized() throws IllegalStateException {
        }

        @Override
        protected void checkPermission(String absPath, int permission) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        }

        @Override
        protected PrivilegeManager getPrivilegeManager() throws RepositoryException {
            return SystemSession.this.context.getPrivilegeManager();
        }

        @Override
        protected void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
            if (absPath != null) {
                Path p = SystemSession.this.getQPath(absPath);
                if (!p.isAbsolute()) {
                    throw new RepositoryException("Absolute path expected.");
                }
                if (SystemSession.this.context.getHierarchyManager().resolveNodePath(p) == null) {
                    throw new PathNotFoundException("No such node " + absPath);
                }
            }
        }

        @Override
        public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
            this.checkValidNodePath(absPath);
            return true;
        }

        @Override
        public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
            this.checkValidNodePath(absPath);
            return new Privilege[]{this.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")};
        }

        @Override
        public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
            return new AccessControlPolicy[0];
        }

        @Override
        public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
            return new AccessControlPolicy[0];
        }

        @Override
        public boolean hasPrivileges(String absPath, Set<Principal> principals, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Privilege[] getPrivileges(String absPath, Set<Principal> principals) throws PathNotFoundException, RepositoryException {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

