/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.library.dprofile.util.KLLSketchForQuantile;

public class HeapLongKLLSketch
extends KLLSketchForQuantile {
    public HeapLongKLLSketch(int maxMemoryByte) {
        this.n = 0L;
        this.calcParameters(maxMemoryByte);
        this.calcLevelMaxSize(1);
    }

    private void calcParameters(int maxMemoryByte) {
        this.maxMemoryNum = this.calcMaxMemoryNum(maxMemoryByte);
        this.num = new long[this.maxMemoryNum];
        this.level0Sorted = false;
        this.cntLevel = 0;
    }

    @Override
    protected int calcMaxMemoryNum(int maxMemoryByte) {
        return Math.min(0x100000, maxMemoryByte / 8);
    }

    @Override
    protected void calcLevelMaxSize(int setLevel) {
        int[] tmpArr = new int[setLevel + 1];
        int maxPos = this.cntLevel > 0 ? Math.max(this.maxMemoryNum, this.levelPos[this.cntLevel]) : this.maxMemoryNum;
        for (int i = 0; i < setLevel + 1; ++i) {
            tmpArr[i] = i < this.cntLevel ? this.levelPos[i] : maxPos;
        }
        this.levelPos = tmpArr;
        this.cntLevel = setLevel;
        this.levelMaxSize = new int[this.cntLevel];
        int newK = 0;
        for (int addK = 0x10000000; addK > 0; addK >>>= 1) {
            int need = 0;
            for (int i = 0; i < this.cntLevel; ++i) {
                need += Math.max(8, (int)Math.round((double)(newK + addK) * Math.pow(0.6666666666666666, (double)(this.cntLevel - i) - 1.0)));
            }
            if (need > this.maxMemoryNum) continue;
            newK += addK;
        }
        for (int i = 0; i < this.cntLevel; ++i) {
            this.levelMaxSize[i] = Math.max(8, (int)Math.round((double)newK * Math.pow(0.6666666666666666, (double)(this.cntLevel - i) - 1.0)));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.n);
        sb.append(this.levelMaxSize[this.cntLevel - 1]);
        sb.append(this.cntLevel);
        sb.append(this.levelPos[this.cntLevel] - this.levelPos[0]);
        for (int i = 0; i < this.cntLevel; ++i) {
            sb.append(this.levelPos[i]);
        }
        return sb.toString();
    }

    private static int mergeSort(long[] a1, int l1, int r1, long[] a2, int l2, int r2, long[] a3, int pos) {
        if (l1 == r1) {
            System.arraycopy(a2, l2, a3, pos, r2 - l2);
        } else if (l2 == r2) {
            System.arraycopy(a1, l1, a3, pos, r1 - l1);
        } else {
            int p1 = l1;
            int p2 = l2;
            while (p1 < r1 || p2 < r2) {
                if (p1 < r1 && (p2 == r2 || a1[p1] < a2[p2])) {
                    a3[pos++] = a1[p1++];
                    continue;
                }
                a3[pos++] = a2[p2++];
            }
        }
        return r1 - l1 + r2 - l2;
    }

    private void compactOneLevel(int level) {
        int oldP;
        if (level == this.cntLevel - 1) {
            this.calcLevelMaxSize(this.cntLevel + 1);
        }
        int l1 = this.levelPos[level];
        int r1 = this.levelPos[level + 1];
        if (level == 0 && !this.level0Sorted) {
            Arrays.sort(this.num, l1, r1);
            this.level0Sorted = true;
        }
        if ((l1 += r1 - l1 & 1) == r1) {
            return;
        }
        this.randomlyHalveDownToLeft(l1, r1);
        int mid = l1 + r1 >>> 1;
        this.mergeSortWithoutSpace(l1, mid, this.levelPos[level + 1], this.levelPos[level + 2]);
        this.levelPos[level + 1] = mid;
        int newP = this.levelPos[level + 1] - 1;
        for (int i = oldP = l1 - 1; i >= this.levelPos[0]; --i) {
            this.num[newP--] = this.num[oldP--];
        }
        this.levelPos[level] = this.levelPos[level + 1] - (l1 - this.levelPos[level]);
        int numReduced = r1 - l1 >>> 1;
        int i = level - 1;
        while (i >= 0) {
            int n = i--;
            this.levelPos[n] = this.levelPos[n] + numReduced;
        }
    }

    @Override
    public void compact() {
        int compactLevel = this.cntLevel - 1;
        for (int i = 0; i < this.cntLevel; ++i) {
            if (this.levelPos[i + 1] - this.levelPos[i] <= this.levelMaxSize[i]) continue;
            compactLevel = i;
        }
        this.compactOneLevel(compactLevel);
    }

    public void merge(KLLSketchForQuantile another) {
        if (another.cntLevel > this.cntLevel) {
            this.calcLevelMaxSize(another.cntLevel);
        }
        for (int i = 0; i < another.cntLevel; ++i) {
            int numToMerge = another.levelPos[i + 1] - another.levelPos[i];
            if (numToMerge == 0) continue;
            int mergingL = another.levelPos[i];
            while (numToMerge > 0) {
                if (this.levelPos[0] == 0) {
                    this.compact();
                }
                int delta = Math.min(numToMerge, this.levelPos[0]);
                if (i > 0) {
                    int j = 0;
                    while (j < i) {
                        int n = j++;
                        this.levelPos[n] = this.levelPos[n] - delta;
                    }
                    System.arraycopy(this.num, delta, this.num, 0, this.levelPos[i] - delta);
                }
                System.arraycopy(another.num, mergingL, this.num, this.levelPos[i] - delta, delta);
                int n = i;
                this.levelPos[n] = this.levelPos[n] - delta;
                numToMerge -= delta;
                mergingL += delta;
            }
        }
        this.n += another.n;
    }

    public void mergeWithTempSpace(KLLSketchForQuantile another) {
        int[] oldLevelPos = this.levelPos;
        int oldCntLevel = this.cntLevel;
        this.calcLevelMaxSize(Math.max(this.cntLevel, another.cntLevel));
        if (this.getNumLen() + another.getNumLen() <= this.maxMemoryNum) {
            int cntPos = oldLevelPos[0] - another.getNumLen();
            for (int i = 0; i < this.cntLevel; ++i) {
                int tmpL = cntPos;
                if (i < oldCntLevel && i < another.cntLevel) {
                    cntPos += HeapLongKLLSketch.mergeSort(this.num, oldLevelPos[i], oldLevelPos[i + 1], another.num, another.levelPos[i], another.levelPos[i + 1], this.num, cntPos);
                } else if (i < oldCntLevel) {
                    cntPos += HeapLongKLLSketch.mergeSort(this.num, oldLevelPos[i], oldLevelPos[i + 1], another.num, 0, 0, this.num, cntPos);
                } else if (i < another.cntLevel) {
                    cntPos += HeapLongKLLSketch.mergeSort(this.num, 0, 0, another.num, another.levelPos[i], another.levelPos[i + 1], this.num, cntPos);
                }
                this.levelPos[i] = tmpL;
            }
            this.levelPos[this.cntLevel] = cntPos;
            this.n += another.n;
        } else {
            long[] oldNum = this.num;
            this.num = new long[this.getNumLen() + another.getNumLen()];
            int numLen = 0;
            for (int i = 0; i < this.cntLevel; ++i) {
                int tmpL = numLen;
                if (i < oldCntLevel && i < another.cntLevel) {
                    numLen += HeapLongKLLSketch.mergeSort(oldNum, oldLevelPos[i], oldLevelPos[i + 1], another.num, another.levelPos[i], another.levelPos[i + 1], this.num, numLen);
                } else if (i < oldCntLevel) {
                    numLen += HeapLongKLLSketch.mergeSort(oldNum, oldLevelPos[i], oldLevelPos[i + 1], another.num, 0, 0, this.num, numLen);
                } else if (i < another.cntLevel) {
                    numLen += HeapLongKLLSketch.mergeSort(oldNum, 0, 0, another.num, another.levelPos[i], another.levelPos[i + 1], this.num, numLen);
                }
                this.levelPos[i] = tmpL;
            }
            this.levelPos[this.cntLevel] = numLen;
            while (this.getNumLen() > this.maxMemoryNum) {
                this.compact();
            }
            int newPos0 = this.maxMemoryNum - this.getNumLen();
            System.arraycopy(this.num, this.levelPos[0], oldNum, newPos0, this.getNumLen());
            for (int i = this.cntLevel; i >= 0; --i) {
                this.levelPos[i] = this.levelPos[i] - this.levelPos[0] + newPos0;
            }
            this.num = oldNum;
            this.n += another.n;
        }
    }

    public void mergeWithTempSpace(List<KLLSketchForQuantile> otherList) {
        int[] oldLevelPos = Arrays.copyOf(this.levelPos, this.cntLevel + 1);
        int oldCntLevel = this.cntLevel;
        int otherNumLen = 0;
        long otherN = 0L;
        for (KLLSketchForQuantile another : otherList) {
            if (another == null) continue;
            if (another.cntLevel > this.cntLevel) {
                this.calcLevelMaxSize(another.cntLevel);
            }
            otherNumLen += another.getNumLen();
            otherN += another.getN();
        }
        if (this.getNumLen() + otherNumLen <= this.maxMemoryNum) {
            int cntPos = oldLevelPos[0] - otherNumLen;
            for (int i = 0; i < this.cntLevel; ++i) {
                this.levelPos[i] = cntPos;
                if (i < oldCntLevel) {
                    System.arraycopy(this.num, oldLevelPos[i], this.num, cntPos, oldLevelPos[i + 1] - oldLevelPos[i]);
                    cntPos += oldLevelPos[i + 1] - oldLevelPos[i];
                }
                for (KLLSketchForQuantile another : otherList) {
                    if (another == null || i >= another.cntLevel) continue;
                    System.arraycopy(another.num, another.levelPos[i], this.num, cntPos, another.getLevelSize(i));
                    cntPos += another.getLevelSize(i);
                }
                Arrays.sort(this.num, this.levelPos[i], cntPos);
            }
            this.levelPos[this.cntLevel] = cntPos;
            this.n += otherN;
        } else {
            long[] oldNum = this.num;
            this.num = new long[this.getNumLen() + otherNumLen];
            int numLen = 0;
            for (int i = 0; i < this.cntLevel; ++i) {
                this.levelPos[i] = numLen;
                if (i < oldCntLevel) {
                    int length = oldLevelPos[i + 1] - oldLevelPos[i];
                    System.arraycopy(oldNum, oldLevelPos[i], this.num, numLen, length);
                    numLen += length;
                }
                for (KLLSketchForQuantile another : otherList) {
                    if (another == null || i >= another.cntLevel) continue;
                    System.arraycopy(another.num, another.levelPos[i], this.num, numLen, another.getLevelSize(i));
                    numLen += another.getLevelSize(i);
                }
                Arrays.sort(this.num, this.levelPos[i], numLen);
            }
            this.levelPos[this.cntLevel] = numLen;
            this.n += otherN;
            while (this.getNumLen() > this.maxMemoryNum) {
                this.compact();
            }
            int newPos0 = this.maxMemoryNum - this.getNumLen();
            System.arraycopy(this.num, this.levelPos[0], oldNum, newPos0, this.getNumLen());
            int i = this.cntLevel;
            while (i >= 0) {
                int n = i--;
                this.levelPos[n] = this.levelPos[n] + (newPos0 - this.levelPos[0]);
            }
            this.num = oldNum;
        }
    }
}

