/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.GroupReference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.EnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.Cardinality;

public final class QueryCardinalityUtil {
    private QueryCardinalityUtil() {
    }

    public static boolean isScalar(PlanNode node) {
        return QueryCardinalityUtil.isScalar(node, Lookup.noLookup());
    }

    public static boolean isScalar(PlanNode node, Lookup lookup) {
        return QueryCardinalityUtil.extractCardinality(node, lookup).isScalar();
    }

    public static boolean isAtMostScalar(PlanNode node) {
        return QueryCardinalityUtil.isAtMostScalar(node, Lookup.noLookup());
    }

    public static boolean isAtMostScalar(PlanNode node, Lookup lookup) {
        return QueryCardinalityUtil.isAtMost(node, lookup, 1L);
    }

    public static boolean isAtMost(PlanNode node, Lookup lookup, long maxCardinality) {
        return QueryCardinalityUtil.extractCardinality(node, lookup).isAtMost(maxCardinality);
    }

    public static boolean isAtLeastScalar(PlanNode node, Lookup lookup) {
        return QueryCardinalityUtil.isAtLeast(node, lookup, 1L);
    }

    public static boolean isAtLeast(PlanNode node, Lookup lookup, long minCardinality) {
        return QueryCardinalityUtil.extractCardinality(node, lookup).isAtLeast(minCardinality);
    }

    public static boolean isEmpty(PlanNode node, Lookup lookup) {
        return QueryCardinalityUtil.isAtMost(node, lookup, 0L);
    }

    public static Cardinality extractCardinality(PlanNode node) {
        return QueryCardinalityUtil.extractCardinality(node, Lookup.noLookup());
    }

    public static Cardinality extractCardinality(PlanNode node, Lookup lookup) {
        return new Cardinality(node.accept(new CardinalityExtractorPlanVisitor(lookup), null));
    }

    private static final class CardinalityExtractorPlanVisitor
    extends PlanVisitor<Range<Long>, Void> {
        private final Lookup lookup;

        public CardinalityExtractorPlanVisitor(Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        public Range<Long> visitPlan(PlanNode node, Void context) {
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitGroupReference(GroupReference node, Void context) {
            return this.lookup.resolve(node).accept(this, context);
        }

        @Override
        public Range<Long> visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return Range.singleton((Comparable)Long.valueOf(1L));
        }

        @Override
        public Range<Long> visitAggregation(AggregationNode node, Void context) {
            if (node.hasSingleGlobalAggregation()) {
                return Range.singleton((Comparable)Long.valueOf(1L));
            }
            Range<Long> sourceCardinalityRange = node.getChild().accept(this, null);
            long lower = node.hasDefaultOutput() || (Long)sourceCardinalityRange.lowerEndpoint() > 0L ? 1L : 0L;
            if (sourceCardinalityRange.hasUpperBound()) {
                long upper = Math.max(lower, (Long)sourceCardinalityRange.upperEndpoint());
                return Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(upper));
            }
            return Range.atLeast((Comparable)Long.valueOf(lower));
        }

        @Override
        public Range<Long> visitExchange(ExchangeNode node, Void context) {
            if (node.getChildren().size() == 1) {
                return ((PlanNode)Iterables.getOnlyElement(node.getChildren())).accept(this, null);
            }
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitProject(ProjectNode node, Void context) {
            return node.getChild().accept(this, null);
        }

        @Override
        public Range<Long> visitFilter(FilterNode node, Void context) {
            Range<Long> sourceCardinalityRange = node.getChild().accept(this, null);
            if (sourceCardinalityRange.hasUpperBound()) {
                return Range.closed((Comparable)Long.valueOf(0L), (Comparable)((Long)sourceCardinalityRange.upperEndpoint()));
            }
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitOffset(OffsetNode node, Void context) {
            Range<Long> sourceCardinalityRange = node.getChild().accept(this, null);
            long lower = Math.max((Long)sourceCardinalityRange.lowerEndpoint() - node.getCount(), 0L);
            if (sourceCardinalityRange.hasUpperBound()) {
                return Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(Math.max((Long)sourceCardinalityRange.upperEndpoint() - node.getCount(), 0L)));
            }
            return Range.atLeast((Comparable)Long.valueOf(lower));
        }

        @Override
        public Range<Long> visitLimit(LimitNode node, Void context) {
            if (node.isWithTies()) {
                Range<Long> sourceCardinalityRange = node.getChild().accept(this, null);
                long lower = Math.min(node.getCount(), (Long)sourceCardinalityRange.lowerEndpoint());
                if (sourceCardinalityRange.hasUpperBound()) {
                    return Range.closed((Comparable)Long.valueOf(lower), (Comparable)((Long)sourceCardinalityRange.upperEndpoint()));
                }
                return Range.atLeast((Comparable)Long.valueOf(lower));
            }
            return this.applyLimit(node.getChild(), node.getCount());
        }

        @Override
        public Range<Long> visitTopK(TopKNode node, Void context) {
            long limit = node.getCount();
            List rangeList = node.getChildren().stream().map(child -> this.applyLimit((PlanNode)child, limit)).collect(Collectors.toList());
            long lower = rangeList.stream().mapToLong(Range::lowerEndpoint).sum();
            long upper = rangeList.stream().mapToLong(Range::upperEndpoint).sum();
            return Range.closed((Comparable)Long.valueOf(Math.min(lower, limit)), (Comparable)Long.valueOf(Math.min(upper, limit)));
        }

        @Override
        public Range<Long> visitAggregationTableScan(AggregationTableScanNode node, Void context) {
            if (!node.getGroupingKeys().isEmpty()) {
                if (node.getProjection() != null && !node.getProjection().getMap().isEmpty()) {
                    return Range.atLeast((Comparable)Long.valueOf(0L));
                }
                return Range.atMost((Comparable)Long.valueOf(node.getDeviceEntries().size()));
            }
            return Range.singleton((Comparable)Long.valueOf(node.getDeviceEntries().size()));
        }

        private Range<Long> applyLimit(PlanNode source, long limit) {
            Range<Long> sourceCardinalityRange = source.accept(this, null);
            if (sourceCardinalityRange.hasUpperBound()) {
                limit = Math.min((Long)sourceCardinalityRange.upperEndpoint(), limit);
            }
            long lower = Math.min(limit, (Long)sourceCardinalityRange.lowerEndpoint());
            return Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(limit));
        }
    }
}

