/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanType;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TableAttributeColumnDropNode
extends PlanNode
implements ISchemaRegionPlan {
    private final String tableName;
    private final String columnName;
    public static final TableAttributeColumnDropNode MOCK_INSTANCE = new TableAttributeColumnDropNode(new PlanNodeId(""), null, null);

    public TableAttributeColumnDropNode(PlanNodeId id, String tableName, String columnName) {
        super(id);
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlanNode clone() {
        return new TableAttributeColumnDropNode(this.id, this.tableName, this.columnName);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TABLE_ATTRIBUTE_COLUMN_DROP;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        this.getType().serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.tableName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.columnName, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        this.getType().serialize(stream);
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.columnName, (OutputStream)stream);
    }

    public static TableAttributeColumnDropNode deserialize(ByteBuffer buffer) {
        String tableName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String columnName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new TableAttributeColumnDropNode(planNodeId, tableName, columnName);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableAttributeColumnDrop(this, context);
    }

    @Override
    public SchemaRegionPlanType getPlanType() {
        return SchemaRegionPlanType.DROP_TABLE_ATTRIBUTE;
    }

    @Override
    public <R, C> R accept(SchemaRegionPlanVisitor<R, C> visitor, C context) {
        return visitor.visitDropTableAttribute(this, context);
    }
}

