/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.ParsingException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LongLiteral
extends Literal {
    private final String value;
    private final long parsedValue;

    public LongLiteral(String value) {
        super(null);
        try {
            this.value = value;
            this.parsedValue = LongLiteral.parse(value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + value);
        }
    }

    public LongLiteral(NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        try {
            this.value = value;
            this.parsedValue = LongLiteral.parse(value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + value, location);
        }
    }

    public String getValue() {
        return this.value;
    }

    public long getParsedValue() {
        return this.parsedValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLongLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.parsedValue == that.parsedValue;
    }

    @Override
    public int hashCode() {
        return (int)(this.parsedValue ^ this.parsedValue >>> 32);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!LongLiteral.sameClass(this, other)) {
            return false;
        }
        return this.parsedValue == ((LongLiteral)other).parsedValue;
    }

    private static long parse(String value) {
        if ((value = value.replace("_", "")).startsWith("0x") || value.startsWith("0X")) {
            return Long.parseLong(value.substring(2), 16);
        }
        if (value.startsWith("0b") || value.startsWith("0B")) {
            return Long.parseLong(value.substring(2), 2);
        }
        if (value.startsWith("0o") || value.startsWith("0O")) {
            return Long.parseLong(value.substring(2), 8);
        }
        return Long.parseLong(value);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.LONG_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.parsedValue, (OutputStream)stream);
    }

    public LongLiteral(ByteBuffer byteBuffer) {
        super(null);
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.parsedValue = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
    }

    @Override
    public Object getTsValue() {
        return this.parsedValue;
    }
}

