/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.source;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;

public class PipeDataRegionEventCounter
extends PipeEventCounter {
    private final AtomicInteger tabletInsertionEventCount = new AtomicInteger(0);
    private final AtomicInteger tsFileInsertionEventCount = new AtomicInteger(0);
    private final AtomicInteger pipeHeartbeatEventCount = new AtomicInteger(0);

    public int getTsFileInsertionEventCount() {
        return this.tsFileInsertionEventCount.get();
    }

    public int getTabletInsertionEventCount() {
        return this.tabletInsertionEventCount.get();
    }

    public int getPipeHeartbeatEventCount() {
        return this.pipeHeartbeatEventCount.get();
    }

    public void increaseEventCount(Event event) {
        if (event instanceof PipeRealtimeEvent) {
            event = ((PipeRealtimeEvent)event).getEvent();
        }
        if (Objects.isNull(event)) {
            return;
        }
        if (event instanceof PipeHeartbeatEvent) {
            this.pipeHeartbeatEventCount.incrementAndGet();
        } else if (event instanceof TabletInsertionEvent) {
            this.tabletInsertionEventCount.incrementAndGet();
        } else if (event instanceof TsFileInsertionEvent) {
            this.tsFileInsertionEventCount.incrementAndGet();
        }
    }

    public void decreaseEventCount(Event event) {
        if (event instanceof PipeRealtimeEvent) {
            event = ((PipeRealtimeEvent)event).getEvent();
        }
        if (Objects.isNull(event)) {
            return;
        }
        if (event instanceof PipeHeartbeatEvent) {
            this.pipeHeartbeatEventCount.decrementAndGet();
        } else if (event instanceof TabletInsertionEvent) {
            this.tabletInsertionEventCount.decrementAndGet();
        } else if (event instanceof TsFileInsertionEvent) {
            this.tsFileInsertionEventCount.decrementAndGet();
        }
    }

    public void reset() {
        this.tabletInsertionEventCount.set(0);
        this.tsFileInsertionEventCount.set(0);
        this.pipeHeartbeatEventCount.set(0);
    }
}

