/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.RawDataAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TemplatedLogicalPlanBuilder
extends LogicalPlanBuilder {
    private final MPPQueryContext context;
    private final Analysis analysis;
    private final List<String> measurementList;
    private final List<IMeasurementSchema> schemaList;

    public TemplatedLogicalPlanBuilder(Analysis analysis, MPPQueryContext context, List<String> measurementList, List<IMeasurementSchema> schemaList) {
        super(analysis, context);
        this.analysis = analysis;
        this.context = context;
        this.measurementList = measurementList;
        this.schemaList = schemaList;
    }

    public TemplatedLogicalPlanBuilder planRawDataSource(PartialPath devicePath, Ordering scanOrder, long offset, long limit, boolean lastLevelUseWildcard) {
        ArrayList<PlanNode> sourceNodeList = new ArrayList<PlanNode>();
        if (this.analysis.getDeviceTemplate().isDirectAligned()) {
            AlignedPath path = new AlignedPath(devicePath);
            path.setMeasurementList(this.measurementList);
            path.addSchemas(this.schemaList);
            AlignedSeriesScanNode alignedSeriesScanNode = new AlignedSeriesScanNode(this.context.getQueryId().genPlanNodeId(), path, scanOrder, limit, offset, null, lastLevelUseWildcard);
            sourceNodeList.add(alignedSeriesScanNode);
        } else {
            for (int i = 0; i < this.measurementList.size(); ++i) {
                MeasurementPath measurementPath = new MeasurementPath(devicePath.concatNode(this.measurementList.get(i)), this.schemaList.get(i));
                SeriesScanNode seriesScanNode = new SeriesScanNode(this.context.getQueryId().genPlanNodeId(), measurementPath, scanOrder, limit, offset, null);
                sourceNodeList.add(seriesScanNode);
            }
        }
        this.root = this.convergeWithTimeJoin(sourceNodeList, scanOrder);
        return this;
    }

    public TemplatedLogicalPlanBuilder planFilter(Expression filterExpression, boolean isGroupByTime, Ordering scanOrder) {
        if (filterExpression == null) {
            return this;
        }
        FilterNode filterNode = new FilterNode(this.context.getQueryId().genPlanNodeId(), this.getRoot(), null, filterExpression, isGroupByTime, scanOrder, true);
        this.analysis.setFromWhere(filterNode);
        this.root = filterNode;
        return this;
    }

    public TemplatedLogicalPlanBuilder planRawDataAggregation(Set<Expression> aggregationExpressions, Expression groupByExpression, GroupByTimeParameter groupByTimeParameter, GroupByParameter groupByParameter, boolean outputEndTime, Ordering scanOrder, List<AggregationDescriptor> deduplicatedAggregationDescriptorList) {
        if (aggregationExpressions == null) {
            return this;
        }
        this.root = new RawDataAggregationNode(this.context.getQueryId().genPlanNodeId(), this.getRoot(), deduplicatedAggregationDescriptorList, groupByTimeParameter, groupByParameter, groupByExpression, outputEndTime, scanOrder, true);
        return this;
    }

    public TemplatedLogicalPlanBuilder planSlidingWindowAggregation(QueryStatement queryStatement, Set<Expression> aggregationExpressions, GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        if (!queryStatement.isGroupByTime() || !this.analysis.getGroupByTimeParameter().hasOverlap()) {
            return this;
        }
        LinkedHashSet<Expression> slidingWindowsExpressions = new LinkedHashSet<Expression>();
        aggregationExpressions.forEach(expression -> {
            if (!"Device".equalsIgnoreCase(expression.getOutputSymbol())) {
                slidingWindowsExpressions.add((Expression)expression);
            }
        });
        this.root = this.createSlidingWindowAggregationNode(this.getRoot(), slidingWindowsExpressions, groupByTimeParameter, AggregationStep.FINAL, scanOrder);
        return this;
    }

    @Override
    public TemplatedLogicalPlanBuilder withNewRoot(PlanNode newRoot) {
        this.root = newRoot;
        return this;
    }
}

