/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImageDiskContainer;
import com.amazonaws.services.ec2.model.ImportImageRequest;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class ImportImageRequestMarshaller
implements Marshaller<Request<ImportImageRequest>, ImportImageRequest> {
    public Request<ImportImageRequest> marshall(ImportImageRequest importImageRequest) {
        ClientData clientData;
        SdkInternalList importImageRequestDiskContainersList;
        if (importImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importImageRequest, "AmazonEC2");
        request.addParameter("Action", "ImportImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importImageRequest.getDescription()));
        }
        if (!(importImageRequestDiskContainersList = (SdkInternalList)importImageRequest.getDiskContainers()).isEmpty() || !importImageRequestDiskContainersList.isAutoConstruct()) {
            int diskContainersListIndex = 1;
            for (ImageDiskContainer importImageRequestDiskContainersListValue : importImageRequestDiskContainersList) {
                UserBucket userBucket;
                if (importImageRequestDiskContainersListValue.getDescription() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Description", StringUtils.fromString((String)importImageRequestDiskContainersListValue.getDescription()));
                }
                if (importImageRequestDiskContainersListValue.getFormat() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Format", StringUtils.fromString((String)importImageRequestDiskContainersListValue.getFormat()));
                }
                if (importImageRequestDiskContainersListValue.getUrl() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Url", StringUtils.fromString((String)importImageRequestDiskContainersListValue.getUrl()));
                }
                if ((userBucket = importImageRequestDiskContainersListValue.getUserBucket()) != null) {
                    if (userBucket.getS3Bucket() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Bucket", StringUtils.fromString((String)userBucket.getS3Bucket()));
                    }
                    if (userBucket.getS3Key() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Key", StringUtils.fromString((String)userBucket.getS3Key()));
                    }
                }
                if (importImageRequestDiskContainersListValue.getDeviceName() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".DeviceName", StringUtils.fromString((String)importImageRequestDiskContainersListValue.getDeviceName()));
                }
                if (importImageRequestDiskContainersListValue.getSnapshotId() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".SnapshotId", StringUtils.fromString((String)importImageRequestDiskContainersListValue.getSnapshotId()));
                }
                ++diskContainersListIndex;
            }
        }
        if (importImageRequest.getLicenseType() != null) {
            request.addParameter("LicenseType", StringUtils.fromString((String)importImageRequest.getLicenseType()));
        }
        if (importImageRequest.getHypervisor() != null) {
            request.addParameter("Hypervisor", StringUtils.fromString((String)importImageRequest.getHypervisor()));
        }
        if (importImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString((String)importImageRequest.getArchitecture()));
        }
        if (importImageRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importImageRequest.getPlatform()));
        }
        if ((clientData = importImageRequest.getClientData()) != null) {
            if (clientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate((Date)clientData.getUploadStart()));
            }
            if (clientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate((Date)clientData.getUploadEnd()));
            }
            if (clientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble((Double)clientData.getUploadSize()));
            }
            if (clientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString((String)clientData.getComment()));
            }
        }
        if (importImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)importImageRequest.getClientToken()));
        }
        if (importImageRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)importImageRequest.getRoleName()));
        }
        return request;
    }
}

