/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.treesitter.parser;

import java.util.function.Function;
import org.apache.ignite3.internal.cli.commands.treesitter.parser.HoconTokenType;
import org.apache.ignite3.internal.cli.commands.treesitter.parser.JsonTokenType;
import org.apache.ignite3.internal.cli.commands.treesitter.parser.SqlTokenType;
import org.treesitter.TSNode;
import org.treesitter.TSTree;
import org.treesitter.TSTreeCursor;

public class Indexer {
    public static SqlTokenType[] indexSql(String text, TSTree tree) {
        return Indexer.index(text, tree, SqlTokenType[]::new, SqlTokenType.SPACE, SqlTokenType::fromNode);
    }

    public static JsonTokenType[] indexJson(String text, TSTree tree) {
        return Indexer.index(text, tree, JsonTokenType[]::new, JsonTokenType.SPACE, JsonTokenType::fromNode);
    }

    public static HoconTokenType[] indexHocon(String text, TSTree tree) {
        return Indexer.index(text, tree, HoconTokenType[]::new, HoconTokenType.SPACE, HoconTokenType::fromNode);
    }

    private static <T> T[] index(String text, TSTree tree, Function<Integer, T[]> tokensArrayFactory, T spaceToken, Function<TSNode, T> nodeToToken) {
        T[] tokens = tokensArrayFactory.apply(text.length());
        TSTreeCursor cursor = new TSTreeCursor(tree.getRootNode());
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isSpaceChar(text.charAt(i))) {
                tokens[i] = spaceToken;
                continue;
            }
            Indexer.findTerminalNode(i, cursor);
            TSNode node = cursor.currentNode();
            tokens[i] = nodeToToken.apply(node);
            cursor.reset(tree.getRootNode());
        }
        return tokens;
    }

    private static void findTerminalNode(int pos, TSTreeCursor cursor) {
        int i = 0;
        while (Indexer.inside(pos, cursor.currentNode()) && -1 != i) {
            i = cursor.gotoFirstChildForByte(pos);
        }
        if (!Indexer.inside(pos, cursor.currentNode())) {
            if (cursor.gotoNextSibling()) {
                Indexer.findTerminalNode(pos, cursor);
            } else {
                cursor.gotoParent();
            }
        }
    }

    private static boolean inside(int pos, TSNode node) {
        return pos >= node.getStartByte() && pos < node.getEndByte();
    }
}

