/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.catalog;

import java.util.Objects;
import org.apache.ignite.catalog.SortOrder;

public final class ColumnSorted {
    private final String columnName;
    private SortOrder sortOrder = SortOrder.DEFAULT;

    private ColumnSorted(String columnName) {
        Objects.requireNonNull(columnName, "Index column name must not be null");
        this.columnName = columnName;
    }

    public static ColumnSorted column(String name) {
        return new ColumnSorted(name);
    }

    public static ColumnSorted column(String name, SortOrder sortOrder) {
        return new ColumnSorted(name).sort(sortOrder);
    }

    public ColumnSorted asc() {
        return this.sort(SortOrder.ASC);
    }

    public ColumnSorted desc() {
        return this.sort(SortOrder.DESC);
    }

    public ColumnSorted sort(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public String columnName() {
        return this.columnName;
    }

    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        return "ColumnSorted{columnName='" + this.columnName + "', sortOrder=" + String.valueOf((Object)this.sortOrder) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnSorted that = (ColumnSorted)o;
        return Objects.equals(this.columnName, that.columnName) && this.sortOrder == that.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.sortOrder});
    }
}

