/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.logit;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageException;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.FeatureChecker;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.storage.logit.option.StoreOptions;
import org.apache.ignite.raft.jraft.storage.logit.storage.LogitLogStorage;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.StringUtils;
import sun.nio.ch.DirectBuffer;

public class LogitLogStorageFactory
implements LogStorageFactory {
    private static final IgniteLogger LOG = Loggers.forClass(LogitLogStorageFactory.class);
    private static final String LOG_DIR_PREFIX = "log-";
    private final ScheduledExecutorService checkpointExecutor;
    private final StoreOptions storeOptions;
    private final Path logPath;

    public LogitLogStorageFactory(String nodeName, StoreOptions storeOptions, Path logPath) {
        this.logPath = logPath;
        this.storeOptions = storeOptions;
        this.checkpointExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"logit-checkpoint-executor", (IgniteLogger)LOG));
        LogitLogStorageFactory.checkVmOptions();
    }

    private static void checkVmOptions() {
        try {
            Class.forName(DirectBuffer.class.getName());
        }
        catch (Throwable e) {
            throw new IgniteInternalException("sun.nio.ch.DirectBuffer is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.checkpointExecutor);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public LogStorage createLogStorage(String groupId, RaftOptions raftOptions) {
        Requires.requireTrue(StringUtils.isNotBlank(groupId), "Blank log storage uri.");
        Path storagePath = this.resolveLogStoragePath(groupId);
        return new LogitLogStorage(storagePath, this.storeOptions, raftOptions, this.checkpointExecutor);
    }

    @Override
    public void destroyLogStorage(String uri) {
        Requires.requireTrue(StringUtils.isNotBlank(uri), "Blank log storage uri.");
        Path storagePath = this.resolveLogStoragePath(uri);
        if (!IgniteUtils.deleteIfExists((Path)storagePath)) {
            throw new LogStorageException("Cannot delete directory " + String.valueOf(storagePath));
        }
    }

    public void sync() {
    }

    public Path resolveLogStoragePath(String groupId) {
        return this.logPath.resolve(LOG_DIR_PREFIX + groupId);
    }
}

