/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.metrics;

import java.util.HashMap;
import org.apache.ignite.internal.metastorage.metrics.MetaStorageMetrics;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class MetaStorageMetricSource
implements MetricSource {
    private static final String SOURCE_NAME = "metastorage";
    private final MetaStorageMetrics metaStorageMetrics;
    private boolean enabled;

    public MetaStorageMetricSource(MetaStorageMetrics metaStorageMetrics) {
        this.metaStorageMetrics = metaStorageMetrics;
    }

    public String name() {
        return SOURCE_NAME;
    }

    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        HashMap<String, LongGauge> metrics = new HashMap<String, LongGauge>();
        metrics.put("SafeTimeLag", new LongGauge("SafeTimeLag", "Number of milliseconds the local MetaStorage SafeTime lags behind the local logical clock.", this.metaStorageMetrics::safeTimeLag));
        this.enabled = true;
        return new MetricSet(SOURCE_NAME, metrics);
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized boolean enabled() {
        return this.enabled;
    }
}

