/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.catalog.definitions.IndexDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.CreateFromAnnotationsImpl;
import org.apache.ignite.internal.catalog.sql.CreateTableImpl;
import org.apache.ignite.internal.catalog.sql.CreateZoneImpl;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryUtils;
import org.apache.ignite.internal.catalog.sql.TableZoneId;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.sql.IgniteSql;

class CreateFromDefinitionImpl
extends AbstractCatalogQuery<TableZoneId> {
    private CreateZoneImpl createZone;
    private String zoneName;
    private CreateTableImpl createTable;
    private String tableName;

    CreateFromDefinitionImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected TableZoneId result() {
        return new TableZoneId(this.tableName, this.zoneName);
    }

    CreateFromDefinitionImpl from(ZoneDefinition def) {
        String zoneName;
        this.createZone = new CreateZoneImpl(this.sql);
        this.zoneName = zoneName = def.zoneName();
        this.createZone.name(zoneName);
        this.createZone.storageProfiles(def.storageProfiles());
        if (def.ifNotExists()) {
            this.createZone.ifNotExists();
        }
        if (QueryUtils.isGreaterThanZero(def.partitions())) {
            this.createZone.partitions(def.partitions());
        }
        if (QueryUtils.isGreaterThanZero(def.replicas())) {
            this.createZone.replicas(def.replicas());
        }
        if (!StringUtils.nullOrBlank(def.distributionAlgorithm())) {
            this.createZone.distributionAlgorithm(def.distributionAlgorithm());
        }
        if (QueryUtils.isGreaterThanOrEqualToZero(def.dataNodesAutoAdjust())) {
            this.createZone.dataNodesAutoAdjust(def.dataNodesAutoAdjust());
        }
        if (QueryUtils.isGreaterThanOrEqualToZero(def.dataNodesAutoAdjustScaleUp())) {
            this.createZone.dataNodesAutoAdjustScaleUp(def.dataNodesAutoAdjustScaleUp());
        }
        if (QueryUtils.isGreaterThanOrEqualToZero(def.dataNodesAutoAdjustScaleDown())) {
            this.createZone.dataNodesAutoAdjustScaleDown(def.dataNodesAutoAdjustScaleDown());
        }
        if (!StringUtils.nullOrBlank(def.filter())) {
            this.createZone.filter(def.filter());
        }
        if (!StringUtils.nullOrBlank(def.consistencyMode())) {
            this.createZone.consistencyMode(def.consistencyMode());
        }
        return this;
    }

    CreateFromDefinitionImpl from(TableDefinition def) {
        List<IndexDefinition> indexes;
        IndexType pkType;
        String tableName;
        this.createTable = new CreateTableImpl(this.sql);
        this.tableName = tableName = def.tableName();
        this.createTable.name(def.schemaName(), tableName);
        if (def.ifNotExists()) {
            this.createTable.ifNotExists();
        }
        if (!CreateFromDefinitionImpl.nullOrEmpty(def.colocationColumns())) {
            this.createTable.colocateBy(def.colocationColumns());
        }
        if (def.zoneName() != null) {
            this.createTable.zone(def.zoneName());
        }
        IndexType indexType = pkType = def.primaryKeyType() == null ? IndexType.DEFAULT : def.primaryKeyType();
        if (def.keyClass() != null) {
            CreateFromAnnotationsImpl.processColumns(this.createTable, pkType, def.keyClass(), true);
            if (def.valueClass() != null) {
                CreateFromAnnotationsImpl.processColumns(this.createTable, pkType, def.valueClass(), false);
            }
        } else {
            List<ColumnDefinition> columns = def.columns();
            if (columns != null) {
                for (ColumnDefinition column : columns) {
                    if (column.type() != null) {
                        this.createTable.addColumn(column.name(), column.type());
                        continue;
                    }
                    if (column.definition() == null) continue;
                    this.createTable.addColumn(column.name(), column.definition());
                }
            }
            if (!CreateFromDefinitionImpl.nullOrEmpty(def.primaryKeyColumns())) {
                this.createTable.primaryKey(pkType, def.primaryKeyColumns());
            }
        }
        if ((indexes = def.indexes()) != null) {
            for (IndexDefinition ix : indexes) {
                this.createTable.addIndex(CreateFromDefinitionImpl.toIndexName(ix), ix.type(), ix.columns());
            }
        }
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (this.createZone != null) {
            ctx.visit(this.createZone).formatSeparator();
        }
        if (this.createTable != null) {
            ctx.visit(this.createTable).formatSeparator();
        }
    }

    private static String toIndexName(IndexDefinition ix) {
        if (!StringUtils.nullOrEmpty(ix.name())) {
            return ix.name();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("ix");
        for (ColumnSorted col : ix.columns()) {
            list.add(col.columnName());
        }
        return String.join((CharSequence)"_", list);
    }

    private static boolean nullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }
}

