/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.marshaller.BinaryMode;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.internal.util.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public final class MarshallerUtil {
    public static int getValueSize(Object val, NativeType type) throws InvalidTypeException {
        switch (type.spec()) {
            case BYTES: {
                return val instanceof byte[] ? ((byte[])val).length : 0;
            }
            case STRING: {
                return ((CharSequence)val).length() << 1;
            }
            case NUMBER: {
                return RowAssembler.sizeInBytes((BigInteger)val);
            }
            case DECIMAL: {
                return RowAssembler.sizeInBytes((BigDecimal)val);
            }
        }
        throw new InvalidTypeException("Unsupported variable-length type: " + type);
    }

    @NotNull
    public static BinaryMode mode(@NotNull Class<?> cls) {
        if (cls == Byte.TYPE) {
            return BinaryMode.P_BYTE;
        }
        if (cls == Short.TYPE) {
            return BinaryMode.P_SHORT;
        }
        if (cls == Integer.TYPE) {
            return BinaryMode.P_INT;
        }
        if (cls == Long.TYPE) {
            return BinaryMode.P_LONG;
        }
        if (cls == Float.TYPE) {
            return BinaryMode.P_FLOAT;
        }
        if (cls == Double.TYPE) {
            return BinaryMode.P_DOUBLE;
        }
        if (cls == Byte.class) {
            return BinaryMode.BYTE;
        }
        if (cls == Short.class) {
            return BinaryMode.SHORT;
        }
        if (cls == Integer.class) {
            return BinaryMode.INT;
        }
        if (cls == Long.class) {
            return BinaryMode.LONG;
        }
        if (cls == Float.class) {
            return BinaryMode.FLOAT;
        }
        if (cls == Double.class) {
            return BinaryMode.DOUBLE;
        }
        if (cls == LocalDate.class) {
            return BinaryMode.DATE;
        }
        if (cls == LocalTime.class) {
            return BinaryMode.TIME;
        }
        if (cls == LocalDateTime.class) {
            return BinaryMode.DATETIME;
        }
        if (cls == Instant.class) {
            return BinaryMode.TIMESTAMP;
        }
        if (cls == byte[].class) {
            return BinaryMode.BYTE_ARR;
        }
        if (cls == String.class) {
            return BinaryMode.STRING;
        }
        if (cls == UUID.class) {
            return BinaryMode.UUID;
        }
        if (cls == BitSet.class) {
            return BinaryMode.BITSET;
        }
        if (cls == BigInteger.class) {
            return BinaryMode.NUMBER;
        }
        if (cls == BigDecimal.class) {
            return BinaryMode.DECIMAL;
        }
        return BinaryMode.POJO;
    }

    public static <T> ObjectFactory<T> factoryForClass(Class<T> targetCls) {
        if (MarshallerUtil.mode(targetCls) == BinaryMode.POJO) {
            return new ObjectFactory<T>(targetCls);
        }
        return null;
    }

    private MarshallerUtil() {
    }
}

