/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.ClientCallStreamObserver;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.ClientResponseObserver;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.StreamObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class ForwardingClientResponseObserver<@UnknownKeyFor ReqT, @UnknownKeyFor RespT>
implements ClientResponseObserver<RespT, ReqT> {
    private final @UnknownKeyFor @NonNull @Initialized Runnable onReadyHandler;
    private final @UnknownKeyFor @NonNull @Initialized Runnable onDoneHandler;
    private final @UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inboundObserver;

    public static <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized ForwardingClientResponseObserver<ReqT, RespT> create(@UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inbound, @UnknownKeyFor @NonNull @Initialized Runnable onReadyHandler) {
        return new ForwardingClientResponseObserver<ReqT, RespT>(inbound, onReadyHandler, () -> {});
    }

    public static <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized ForwardingClientResponseObserver<ReqT, RespT> create(@UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inbound, @UnknownKeyFor @NonNull @Initialized Runnable onReadyHandler, @UnknownKeyFor @NonNull @Initialized Runnable onDoneHandler) {
        return new ForwardingClientResponseObserver<ReqT, RespT>(inbound, onReadyHandler, onDoneHandler);
    }

    private ForwardingClientResponseObserver(@UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inboundObserver, @UnknownKeyFor @NonNull @Initialized Runnable onReadyHandler, @UnknownKeyFor @NonNull @Initialized Runnable onDoneHandler) {
        this.inboundObserver = inboundObserver;
        this.onReadyHandler = onReadyHandler;
        this.onDoneHandler = onDoneHandler;
    }

    public void onNext(ReqT value) {
        this.inboundObserver.onNext(value);
    }

    public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        this.onDoneHandler.run();
        this.inboundObserver.onError(t);
    }

    public void onCompleted() {
        this.onDoneHandler.run();
        this.inboundObserver.onCompleted();
    }

    public void beforeStart(@UnknownKeyFor @NonNull @Initialized ClientCallStreamObserver<RespT> stream) {
        stream.setOnReadyHandler(this.onReadyHandler);
    }
}

