/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.aws2.kinesis.GetKinesisRecordsResult;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisClientThrottledException;
import org.apache.beam.sdk.io.aws2.kinesis.ShardListingUtils;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.beam.sdk.io.aws2.kinesis.TransientKinesisException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardFilter;
import software.amazon.awssdk.services.kinesis.model.ShardFilterType;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.retrieval.AggregatorUtil;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

class SimplifiedKinesisClient
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SimplifiedKinesisClient.class);
    private static final @UnknownKeyFor @NonNull @Initialized String KINESIS_NAMESPACE = "AWS/Kinesis";
    private static final @UnknownKeyFor @NonNull @Initialized String INCOMING_RECORDS_METRIC = "IncomingBytes";
    private static final @UnknownKeyFor @NonNull @Initialized int PERIOD_GRANULARITY_IN_SECONDS = 60;
    private static final @UnknownKeyFor @NonNull @Initialized String STREAM_NAME_DIMENSION = "StreamName";
    private final @UnknownKeyFor @NonNull @Initialized LazyResource<@UnknownKeyFor @NonNull @Initialized KinesisClient> kinesis;
    private final @UnknownKeyFor @NonNull @Initialized LazyResource<@UnknownKeyFor @NonNull @Initialized CloudWatchClient> cloudWatch;
    private final @Nullable @UnknownKeyFor @Initialized Integer limit;

    SimplifiedKinesisClient(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized KinesisClient> kinesisSupplier, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized CloudWatchClient> cloudWatchSupplier, @Nullable @UnknownKeyFor @Initialized Integer limit) {
        this.kinesis = new LazyResource((Supplier)Preconditions.checkNotNull(kinesisSupplier, (Object)"kinesis"));
        this.cloudWatch = new LazyResource((Supplier)Preconditions.checkNotNull(cloudWatchSupplier, (Object)"cloudWatch"));
        this.limit = limit;
    }

    public @UnknownKeyFor @NonNull @Initialized String getShardIterator(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized ShardIteratorType shardIteratorType, @UnknownKeyFor @NonNull @Initialized String startingSequenceNumber, @UnknownKeyFor @NonNull @Initialized Instant timestamp) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return SimplifiedKinesisClient.wrapExceptions(() -> {
            GetShardIteratorRequest request = (GetShardIteratorRequest)GetShardIteratorRequest.builder().streamName(streamName).shardId(shardId).shardIteratorType(shardIteratorType).startingSequenceNumber(startingSequenceNumber).timestamp(TimeUtil.toJava(timestamp)).build();
            LOG.info("Starting getIterator request {}", (Object)request);
            return ((KinesisClient)this.kinesis.get()).getShardIterator(request).shardIterator();
        });
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Shard> listShardsFollowingClosedShard(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String exclusiveStartShardId) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        ShardFilter shardFilter = (ShardFilter)ShardFilter.builder().type(ShardFilterType.AFTER_SHARD_ID).shardId(exclusiveStartShardId).build();
        return SimplifiedKinesisClient.wrapExceptions(() -> ShardListingUtils.listShards((KinesisClient)this.kinesis.get(), streamName, shardFilter));
    }

    public @UnknownKeyFor @NonNull @Initialized GetKinesisRecordsResult getRecords(@UnknownKeyFor @NonNull @Initialized String shardIterator, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return this.getRecords(shardIterator, streamName, shardId, this.limit);
    }

    public @UnknownKeyFor @NonNull @Initialized GetKinesisRecordsResult getRecords(@UnknownKeyFor @NonNull @Initialized String shardIterator, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized Integer limit) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return SimplifiedKinesisClient.wrapExceptions(() -> {
            GetRecordsRequest request = (GetRecordsRequest)GetRecordsRequest.builder().shardIterator(shardIterator).limit(limit).build();
            GetRecordsResponse response = ((KinesisClient)this.kinesis.get()).getRecords(request);
            List records = response.records();
            return new GetKinesisRecordsResult(SimplifiedKinesisClient.deaggregate(records), response.nextShardIterator(), response.millisBehindLatest(), streamName, shardId);
        });
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisClientRecord> deaggregate(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Record> records) {
        return records.isEmpty() ? ImmutableList.of() : new AggregatorUtil().deaggregate(records.stream().map(KinesisClientRecord::fromRecord).collect(Collectors.toList()));
    }

    public @UnknownKeyFor @NonNull @Initialized long getBacklogBytes(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant countSince) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return this.getBacklogBytes(streamName, countSince, new Instant());
    }

    public @UnknownKeyFor @NonNull @Initialized long getBacklogBytes(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant countSince, @UnknownKeyFor @NonNull @Initialized Instant countTo) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return SimplifiedKinesisClient.wrapExceptions(() -> {
            Minutes period = Minutes.minutesBetween((ReadableInstant)countSince, (ReadableInstant)countTo);
            if (period.isLessThan(Minutes.ONE)) {
                return 0L;
            }
            GetMetricStatisticsRequest request = this.createMetricStatisticsRequest(streamName, countSince, countTo, period);
            long totalSizeInBytes = 0L;
            GetMetricStatisticsResponse response = ((CloudWatchClient)this.cloudWatch.get()).getMetricStatistics(request);
            for (Datapoint point : response.datapoints()) {
                totalSizeInBytes += point.sum().longValue();
            }
            return totalSizeInBytes;
        });
    }

    @UnknownKeyFor @NonNull @Initialized GetMetricStatisticsRequest createMetricStatisticsRequest(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant countSince, @UnknownKeyFor @NonNull @Initialized Instant countTo, @UnknownKeyFor @NonNull @Initialized Minutes period) {
        return (GetMetricStatisticsRequest)GetMetricStatisticsRequest.builder().namespace(KINESIS_NAMESPACE).metricName(INCOMING_RECORDS_METRIC).period(Integer.valueOf(period.getMinutes() * 60)).startTime(TimeUtil.toJava(countSince)).endTime(TimeUtil.toJava(countTo)).statistics(new Statistic[]{Statistic.SUM}).dimensions(new Dimension[]{(Dimension)Dimension.builder().name(STREAM_NAME_DIMENSION).value(streamName).build()}).build();
    }

    private static <T> T wrapExceptions(@UnknownKeyFor @NonNull @Initialized Callable<T> callable) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        try {
            return callable.call();
        }
        catch (ExpiredIteratorException e) {
            throw e;
        }
        catch (LimitExceededException | ProvisionedThroughputExceededException e) {
            throw new KinesisClientThrottledException("Too many requests to Kinesis. Wait some time and retry.", (KinesisException)e);
        }
        catch (SdkServiceException e) {
            if (e.isThrottlingException() || SdkDefaultRetrySetting.RETRYABLE_STATUS_CODES.contains(e.statusCode())) {
                throw new TransientKinesisException("Kinesis backend failed. Wait some time and retry.", (SdkException)((Object)e));
            }
            throw e;
        }
        catch (SdkClientException e) {
            if (SdkDefaultRetrySetting.RETRYABLE_EXCEPTIONS.contains(((Object)((Object)e)).getClass())) {
                throw new TransientKinesisException("Retryable failure", (SdkException)((Object)e));
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown kinesis failure, when trying to reach kinesis", e);
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try (LazyResource<KinesisClient> c1 = this.kinesis;){
            LazyResource<CloudWatchClient> c2 = this.cloudWatch;
            if (c2 != null) {
                c2.close();
            }
        }
    }

    private static class LazyResource<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized AutoCloseable>
    implements Supplier<T>,
    AutoCloseable {
        private final @UnknownKeyFor @NonNull @Initialized Supplier<T> initializer;
        private volatile T resource = null;

        private LazyResource(@UnknownKeyFor @NonNull @Initialized Supplier<T> initializer) {
            this.initializer = initializer;
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            T res = this.resource;
            if (res != null) {
                res.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Object res = this.resource;
            if (res == null) {
                LazyResource lazyResource = this;
                synchronized (lazyResource) {
                    res = this.resource;
                    if (res == null) {
                        this.resource = res = (AutoCloseable)this.initializer.get();
                    }
                }
            }
            return res;
        }
    }
}

