/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.uuid;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;

@ValueMetaPlugin(id="32", name="UUID", description="Universally Unique Identifier", image="uuid.svg")
public class ValueMetaUuid
extends ValueMetaBase {
    public static final int TYPE_UUID = 32;

    public ValueMetaUuid() {
        super(null, 32);
    }

    public ValueMetaUuid(String name) {
        super(name, 32);
    }

    public ValueMetaUuid(ValueMetaUuid meta) {
        super(meta.name, 32);
    }

    public ValueMetaUuid clone() {
        return (ValueMetaUuid)super.clone();
    }

    public Class<?> getNativeDataTypeClass() {
        return UUID.class;
    }

    public Object convertData(IValueMeta meta2, Object data2) throws HopValueException {
        return this.toUuid(meta2, data2);
    }

    private UUID toUuid(IValueMeta meta2, Object data2) throws HopValueException {
        if (data2 == null) {
            return null;
        }
        if (data2 instanceof UUID) {
            return (UUID)data2;
        }
        try {
            switch (meta2.getType()) {
                case 32: {
                    switch (meta2.getStorageType()) {
                        case 0: {
                            return UUID.fromString((String)data2);
                        }
                        case 1: {
                            return (UUID)this.convertBinaryStringToNativeType((byte[])data2);
                        }
                        case 2: {
                            return (UUID)meta2.getIndex()[(Integer)data2];
                        }
                    }
                    break;
                }
                case 2: {
                    switch (meta2.getStorageType()) {
                        case 0: {
                            return UUID.fromString((String)data2);
                        }
                        case 1: {
                            return (UUID)this.convertBinaryStringToNativeType((byte[])data2);
                        }
                        case 2: {
                            return UUID.fromString((String)meta2.getIndex()[(Integer)data2]);
                        }
                    }
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new HopValueException(String.valueOf((Object)this) + " : I can't convert the specified value to data type : UUID");
    }

    public int hashCode(Object object) throws HopValueException {
        if (object instanceof UUID) {
            return object.hashCode();
        }
        UUID u = this.toUuid((IValueMeta)this, object);
        return u == null ? 0 : u.hashCode();
    }

    public Object cloneValueData(Object object) throws HopValueException {
        return object;
    }

    protected int typeCompare(Object object1, Object object2) throws HopValueException {
        UUID u1;
        if (object1 instanceof UUID) {
            u1 = (UUID)object1;
            if (object2 instanceof UUID) {
                UUID u2 = (UUID)object2;
                return u1.compareTo(u2);
            }
        }
        u1 = this.toUuid((IValueMeta)this, object1);
        UUID u2 = this.toUuid((IValueMeta)this, object2);
        return u1.compareTo(u2);
    }

    public String getString(Object object) throws HopValueException {
        UUID u = this.toUuid((IValueMeta)this, object);
        return u == null ? null : u.toString();
    }

    /*
     * Loose catch block
     */
    public void setPreparedStatementValue(DatabaseMeta databaseMeta, PreparedStatement preparedStatement, int index, Object data) throws HopDatabaseException {
        UUID u;
        block5: {
            u = this.toUuid((IValueMeta)this, data);
            if (u != null) break block5;
            preparedStatement.setNull(index, 1111);
            return;
            {
                catch (Exception e) {
                    throw new HopDatabaseException("Error setting UUID value #" + index + " [" + this.toStringMeta() + "] on prepared statement", (Throwable)e);
                }
            }
        }
        try {
            preparedStatement.setObject(index, u);
            return;
        }
        catch (Exception exception) {
            preparedStatement.setString(index, u.toString());
        }
    }

    public Object getValueFromResultSet(IDatabase iDatabase, ResultSet resultSet, int index) throws HopDatabaseException {
        try {
            Object o = resultSet.getObject(index + 1);
            return this.convertData((IValueMeta)this, o);
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to get UUID value '" + this.toStringMeta() + "' from database resultset, index " + index, (Throwable)e);
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to read UUID value", (Throwable)e);
        }
    }

    public String getDatabaseColumnTypeDefinition(IDatabase iDatabase, String tk, String pk, boolean useAutoIncrement, boolean addFieldName, boolean addCr) {
        String col = addFieldName ? this.getName() + " " : "";
        String def = "UUID";
        if (iDatabase.isMsSqlServerNativeVariant()) {
            def = "UNIQUEIDENTIFIER";
        }
        return col + def + (addCr ? Const.CR : "");
    }

    public byte[] getBinaryString(Object object) throws HopValueException {
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        UUID u = this.toUuid((IValueMeta)this, object);
        if (u == null) {
            return null;
        }
        try {
            return u.toString().getBytes(this.getStringEncoding() == null ? "UTF-8" : this.getStringEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new HopValueException("Unsupported encoding for UUID", (Throwable)e);
        }
        catch (Exception e) {
            throw new HopValueException("Unable to get binary string for UUID", (Throwable)e);
        }
    }

    public void writeData(DataOutputStream outputStream, Object object) throws HopFileException {
        if (this.getStorageType() != 0) {
            super.writeData(outputStream, object);
            return;
        }
        try {
            outputStream.writeBoolean(object == null);
            if (object != null) {
                UUID u = this.toUuid((IValueMeta)this, object);
                byte[] b = this.getBinaryString(u);
                outputStream.writeInt(b.length);
                outputStream.write(b);
            }
        }
        catch (IOException e) {
            throw new HopFileException(String.valueOf((Object)this) + " : Unable to write value data to output stream", (Throwable)e);
        }
        catch (Exception e) {
            throw new HopFileException("Unable to convert data to UUID before writing to output stream", (Throwable)e);
        }
    }

    protected UUID readUuid(DataInputStream inputStream) throws IOException {
        int inputLength = inputStream.readInt();
        if (inputLength < 0) {
            return null;
        }
        byte[] chars = new byte[inputLength];
        inputStream.readFully(chars);
        String uuidStr = new String(chars, StandardCharsets.UTF_8);
        return UUID.fromString(uuidStr);
    }

    public Object readData(DataInputStream inputStream) throws HopFileException, SocketTimeoutException {
        if (this.getStorageType() != 0) {
            return super.readData(inputStream);
        }
        try {
            if (inputStream.readBoolean()) {
                return null;
            }
            return this.readUuid(inputStream);
        }
        catch (EOFException e) {
            throw new HopEofException((Throwable)e);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HopFileException(String.valueOf((Object)this) + " : Unable to read UUID value data from input stream", (Throwable)e);
        }
    }
}

