/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import javax.net.ssl.SSLProtocolException;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MediaType;

class HttpExchange {
    private static final MediaType HTML_UTF8 = MediaType.parse("text/html;charset=utf-8");
    private final Socket socket;
    private final HttpRequest request;
    private final Matcher matcher;

    HttpExchange(Socket socket, HttpRequest request, Matcher matcher) {
        this.socket = socket;
        this.request = request;
        this.matcher = matcher;
    }

    public String param(int i) {
        return this.matcher.group(i);
    }

    public HttpRequest request() {
        return this.request;
    }

    public void redirect(String location) throws IOException {
        this.send(((HttpResponse.Builder)((HttpResponse.Builder)new HttpResponse.Builder(307, "Redirect").addHeader("Content-Length", "0")).addHeader("Location", location)).build());
    }

    public void send(int status, String html) throws IOException {
        this.send(status, HTML_UTF8, html);
    }

    public void send(int status, MediaType type, String body) throws IOException {
        this.send(((HttpResponse.Builder)new HttpResponse.Builder(status, " ").body(type, body.getBytes(StandardCharsets.UTF_8))).build());
    }

    public void send(HttpResponse response) throws IOException {
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream.write(response.serializeHeader());
            IOUtils.copy(response.body().stream(), outputStream);
        }
        catch (SocketException | SSLProtocolException e) {
            this.socket.close();
        }
    }
}

