/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIs {
    private static final Pattern URL_REGEX = Pattern.compile("\\A(?:([a-zA-Z][^:]*):)?([/\\\\\\r\\n\\t]*)([^/\\\\?#]*)([/\\\\][^?#]*)?(?:[?]([^#]*))?(?:[#](.*))?\\Z", 32);
    private static final int SCHEME = 1;
    private static final int SLASHES = 2;
    private static final int AUTHORITY = 3;
    private static final int PATH = 4;
    private static final int QUERY = 5;
    private static final int FRAGMENT = 6;
    private static final Pattern AUTHORITY_REGEX = Pattern.compile("([^@]*@)?(.*?)(?::([0-9]+))?", 32);
    private static final Pattern IPV4_REGEX = Pattern.compile("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}");
    private static final String ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String DIGIT = "0123456789";
    private static final String ALPHANUM = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String UNRESERVED = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-!.~'()*";
    private static final String PUNCT = ",;:$&+=";
    private static final String RESERVED = ",;:$&+=?/[]@";
    private static final BitSet PATH_ALLOWED = URIs.charBitSet("/@ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-!.~'()*,;:$&+=");
    private static final BitSet QUERY_ALLOWED = URIs.charBitSet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-!.~'()*,;:$&+=?/[]@");

    private static BitSet charBitSet(String chars) {
        BitSet bitSet = new BitSet(128);
        for (char c : chars.toCharArray()) {
            bitSet.set(c);
        }
        return bitSet;
    }

    public static boolean hasHttpOrHttpsScheme(String uri) {
        return URIs.startsWithIgnoreCase(uri, "http:") || URIs.startsWithIgnoreCase(uri, "https:");
    }

    private static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static URI parseLeniently(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            String fragment;
            String query;
            String path;
            String authority;
            String slashes;
            Matcher urlMatcher = URL_REGEX.matcher(uri);
            if (!urlMatcher.matches()) {
                throw new IllegalArgumentException("invalid URI: " + uri);
            }
            StringBuilder builder = new StringBuilder();
            String scheme = urlMatcher.group(1);
            if (scheme != null) {
                builder.append(scheme);
                builder.append(':');
            }
            if ((slashes = urlMatcher.group(2)) != null) {
                builder.append(slashes);
            }
            if ((authority = urlMatcher.group(3)) != null) {
                builder.append(authority);
            }
            if ((path = urlMatcher.group(4)) != null) {
                builder.append(URIs.percentEncodeIfNeeded(path, PATH_ALLOWED));
            }
            if ((query = urlMatcher.group(5)) != null) {
                builder.append('?');
                builder.append(URIs.percentEncodeIfNeeded(query, QUERY_ALLOWED));
            }
            if ((fragment = urlMatcher.group(6)) != null) {
                builder.append('#');
                builder.append(URIs.percentEncodeIfNeeded(fragment, QUERY_ALLOWED));
            }
            return URI.create(builder.toString());
        }
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isASCII(char c) {
        return c <= '\u007f';
    }

    private static String percentEncodeIfNeeded(String s, BitSet allowed) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (allowed.get(c)) {
                out.append(c);
                continue;
            }
            if (c == '%' && i < s.length() - 2 && URIs.isHexDigit(s.charAt(i + 1)) && URIs.isHexDigit(s.charAt(i + 2))) {
                out.append(c);
                continue;
            }
            if (!(URIs.isASCII(c) || Character.isISOControl(c) || Character.isSpaceChar(c))) {
                out.append(c);
                continue;
            }
            for (byte b : Character.toString(c).getBytes(StandardCharsets.UTF_8)) {
                out.append('%').append(String.format("%02x", b));
            }
        }
        return out.toString();
    }

    public static String toNormalizedSurt(String uri) {
        Matcher urlMatcher = URL_REGEX.matcher(uri);
        if (!urlMatcher.matches()) {
            throw new IllegalArgumentException("invalid URL: " + uri);
        }
        String authority = urlMatcher.group(3);
        String path = urlMatcher.group(4);
        String query = urlMatcher.group(5);
        String fragment = urlMatcher.group(6);
        Matcher authorityMatcher = AUTHORITY_REGEX.matcher(authority);
        if (!authorityMatcher.matches()) {
            throw new IllegalStateException("authority didn't match");
        }
        String host = authorityMatcher.group(2);
        String port = authorityMatcher.group(3);
        StringBuilder output = new StringBuilder();
        if (IPV4_REGEX.matcher(host).matches()) {
            output.append(host);
        } else {
            List<String> hostSegments = Arrays.asList(host.toLowerCase(Locale.ROOT).split("\\."));
            if (hostSegments.get(0).equals("www")) {
                hostSegments = hostSegments.subList(1, hostSegments.size());
            }
            Collections.reverse(hostSegments);
            output.append(URIs.normalizePercentEncoding(String.join((CharSequence)",", hostSegments)));
        }
        if (port != null) {
            output.append(':');
            output.append(port);
        }
        output.append(')');
        if (path != null) {
            output.append(URIs.normalizePercentEncoding(URIs.normalizePathSegments(path.toLowerCase(Locale.ROOT))));
        } else {
            output.append('/');
        }
        if (query != null) {
            output.append('?');
            Object[] params = URIs.normalizePercentEncoding(query).toLowerCase(Locale.ROOT).split("&", -1);
            Arrays.sort(params);
            output.append(String.join((CharSequence)"&", (CharSequence[])params));
        }
        if (fragment != null) {
            output.append('#');
            output.append(URIs.normalizePercentEncoding(fragment));
        }
        return output.toString();
    }

    static String normalizePathSegments(String path) {
        ArrayList<String> output = new ArrayList<String>();
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        block9: for (int i = 0; i < n; ++i) {
            String segment;
            switch (segment = stringArray[i]) {
                case "": 
                case ".": {
                    continue block9;
                }
                case "..": {
                    if (output.isEmpty()) continue block9;
                    output.remove(output.size() - 1);
                    continue block9;
                }
                default: {
                    output.add(segment);
                }
            }
        }
        return "/" + String.join((CharSequence)"/", output);
    }

    static String normalizePercentEncoding(String s) {
        return URIs.percentEncodeIllegals(URIs.fullyPercentDecode(s));
    }

    private static String fullyPercentDecode(String s) {
        String prev;
        do {
            prev = s;
        } while (!(s = URIs.percentDecode(s)).equals(prev));
        return prev;
    }

    public static String percentEncodeIllegals(String s) {
        byte[] bytes;
        StringBuilder out = new StringBuilder();
        for (byte rawByte : bytes = s.getBytes(StandardCharsets.UTF_8)) {
            int b = rawByte & 0xFF;
            if (b == 37 || b == 35 || b <= 32 || b >= 127) {
                out.append('%').append(String.format("%02x", b));
                continue;
            }
            out.append((char)b);
        }
        return out.toString();
    }

    public static String percentPlusDecode(String s) {
        return URIs.percentDecode(s.replace('+', ' '));
    }

    private static String percentDecode(String s) {
        ByteBuffer bb = null;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '%') {
                if (bb == null) {
                    bb = ByteBuffer.allocate((s.length() - i) / 3);
                }
                while (i + 2 < s.length() && s.charAt(i) == '%') {
                    int d1 = Character.digit(s.charAt(i + 1), 16);
                    int d2 = Character.digit(s.charAt(i + 2), 16);
                    if (d1 < 0 || d2 < 0) break;
                    bb.put((byte)(d1 << 4 | d2));
                    i += 3;
                }
                bb.flip();
                URIs.tryDecodeUtf8(bb, out);
                bb.clear();
                if (i >= s.length()) continue;
                out.append(s.charAt(i));
                continue;
            }
            out.append(s.charAt(i));
        }
        return out.toString();
    }

    private static void tryDecodeUtf8(ByteBuffer bb, StringBuilder out) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        CharBuffer cb = CharBuffer.allocate(bb.remaining());
        while (bb.hasRemaining()) {
            CoderResult result = decoder.decode(bb, cb, true);
            if (result.isMalformed()) {
                for (int i = 0; i < result.length(); ++i) {
                    out.append('%').append(String.format("%02x", bb.get()));
                }
            }
            out.append(cb.flip());
            cb.clear();
        }
    }
}

