/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.Replacement;
import org.apache.cassandra.config.Replaces;
import org.apache.cassandra.config.ReplacesList;
import org.apache.cassandra.exceptions.ConfigurationException;

public final class Replacements {
    private Replacements() {
    }

    public static Map<Class<? extends Object>, Map<String, Replacement>> getNameReplacements(Class<? extends Object> klass) {
        List<Replacement> replacements = Replacements.getReplacementsRecursive(klass);
        HashMap<Class<? extends Object>, Map<String, Replacement>> objectOldNames = new HashMap<Class<? extends Object>, Map<String, Replacement>>();
        for (Replacement r : replacements) {
            Map oldNames = objectOldNames.computeIfAbsent(r.parent, ignore -> new HashMap());
            if (!oldNames.containsKey(r.oldName)) {
                oldNames.put(r.oldName, r);
                continue;
            }
            throw new ConfigurationException("Invalid annotations, you have more than one @Replaces annotation in Config class with same old name(" + r.oldName + ") defined.");
        }
        return objectOldNames;
    }

    private static List<Replacement> getReplacementsRecursive(Class<?> klass) {
        HashSet seen = new HashSet();
        ArrayList<Replacement> accum = new ArrayList<Replacement>();
        Replacements.getReplacementsRecursive(seen, accum, klass);
        return accum.isEmpty() ? Collections.emptyList() : accum;
    }

    private static void getReplacementsRecursive(Set<Class<?>> seen, List<Replacement> accum, Class<?> klass) {
        accum.addAll(Replacements.getReplacements(klass));
        for (Field field : klass.getDeclaredFields()) {
            if (!seen.add(field.getType())) continue;
            Replacements.getReplacementsRecursive(seen, accum, field.getType());
        }
    }

    private static List<Replacement> getReplacements(Class<?> klass) {
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        for (Field field : klass.getDeclaredFields()) {
            String newName = field.getName();
            Class<?> newType = field.getType();
            ReplacesList[] byType = (ReplacesList[])field.getAnnotationsByType(ReplacesList.class);
            if (byType == null || byType.length == 0) {
                Replaces r = field.getAnnotation(Replaces.class);
                if (r == null) continue;
                Replacements.addReplacement(klass, replacements, newName, newType, r);
                continue;
            }
            for (ReplacesList replacesList : byType) {
                for (Replaces r : replacesList.value()) {
                    Replacements.addReplacement(klass, replacements, newName, newType, r);
                }
            }
        }
        return replacements.isEmpty() ? Collections.emptyList() : replacements;
    }

    private static void addReplacement(Class<?> klass, List<Replacement> replacements, String newName, Class<?> newType, Replaces r) {
        Class<?> expectedNewType;
        String oldName = r.oldName();
        boolean deprecated = r.deprecated();
        Class<?> oldType = r.converter().getOldType();
        if (oldType == null) {
            oldType = newType;
        }
        if ((expectedNewType = r.converter().getNewType()) != null) assert (expectedNewType.equals(newType)) : String.format("Converter is expected to return %s but %s#%s expects %s", expectedNewType, klass, newName, newType);
        replacements.add(new Replacement(klass, oldName, oldType, newName, r.converter(), deprecated));
    }
}

