/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.repeatfields;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.repeatfields.Repeat;
import org.apache.hop.pipeline.transforms.repeatfields.RepeatFields;
import org.apache.hop.pipeline.transforms.repeatfields.RepeatFieldsMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RepeatFieldsDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = RepeatFields.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "RepeatFieldsWarning";
    private ColumnInfo[] ciGroup;
    private TableView wGroup;
    private ColumnInfo[] ciRepeats;
    private TableView wRepeats;
    private final RepeatFieldsMeta input;
    private final List<String> inputFields = new ArrayList<String>();

    public RepeatFieldsDialog(Shell parent, IVariables variables, RepeatFieldsMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlGroup = new Label((Composite)this.shell, 0);
        wlGroup.setText(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.Group.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGroup);
        FormData fdlGroup = new FormData();
        fdlGroup.left = new FormAttachment(0, 0);
        fdlGroup.top = new FormAttachment((Control)this.wlTransformName, 2 * margin);
        wlGroup.setLayoutData((Object)fdlGroup);
        int groupRows = this.input.getGroupFields().size();
        this.ciGroup = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.ColumnInfo.GroupField", (String[])new String[0]), 2, new String[]{""}, false)};
        this.wGroup = new TableView(this.variables, (Composite)this.shell, 68354, this.ciGroup, groupRows, null, this.props);
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)wlGroup, margin);
        fdGet.right = new FormAttachment(100, 0);
        wGet.setLayoutData((Object)fdGet);
        wGet.addListener(13, e -> this.getGroups());
        FormData fdGroup = new FormData();
        fdGroup.left = new FormAttachment(0, 0);
        fdGroup.top = new FormAttachment((Control)wlGroup, margin);
        fdGroup.right = new FormAttachment((Control)wGet, -margin);
        fdGroup.bottom = new FormAttachment(30, 0);
        this.wGroup.setLayoutData((Object)fdGroup);
        Label wlRepeats = new Label((Composite)this.shell, 0);
        wlRepeats.setText(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.RepeatFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRepeats);
        FormData fdlRepeats = new FormData();
        fdlRepeats.left = new FormAttachment(0, 0);
        fdlRepeats.top = new FormAttachment((Control)this.wGroup, margin);
        wlRepeats.setLayoutData((Object)fdlRepeats);
        this.ciRepeats = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.ColumnInfo.RepeatType", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.ColumnInfo.SourceFieldName", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.ColumnInfo.TargetFieldName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.ColumnInfo.IndicatorFieldName", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.ColumnInfo.IndicatorValue", (String[])new String[0]), 1, false)};
        this.ciRepeats[0].setComboValues(RepeatFieldsMeta.RepeatType.getDescriptions());
        this.ciRepeats[1].setUsingVariables(true);
        this.ciRepeats[2].setUsingVariables(true);
        this.ciRepeats[3].setUsingVariables(true);
        this.wRepeats = new TableView(this.variables, (Composite)this.shell, 68354, this.ciRepeats, this.input.getRepeats().size(), null, this.props);
        Button wGetRepeats = new Button((Composite)this.shell, 8);
        wGetRepeats.setText(BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.GetRepeatFields.Button", (String[])new String[0]));
        FormData fdGetRepeats = new FormData();
        fdGetRepeats.top = new FormAttachment((Control)wlRepeats, margin);
        fdGetRepeats.right = new FormAttachment(100, 0);
        wGetRepeats.setLayoutData((Object)fdGetRepeats);
        wGetRepeats.addListener(13, e -> this.getRepeats());
        FormData fdRepeats = new FormData();
        fdRepeats.left = new FormAttachment(0, 0);
        fdRepeats.top = new FormAttachment((Control)wlRepeats, margin);
        fdRepeats.right = new FormAttachment((Control)wGetRepeats, -margin);
        fdRepeats.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wRepeats.setLayoutData((Object)fdRepeats);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciGroup[0].setComboValues(fieldNames);
        this.ciRepeats[1].setComboValues(fieldNames);
        this.ciRepeats[3].setComboValues(fieldNames);
    }

    public void getData() {
        int i;
        for (i = 0; i < this.input.getGroupFields().size(); ++i) {
            TableItem item = this.wGroup.table.getItem(i);
            item.setText(1, Const.NVL((String)this.input.getGroupFields().get(i), (String)""));
        }
        for (i = 0; i < this.input.getRepeats().size(); ++i) {
            Repeat repeat = this.input.getRepeats().get(i);
            TableItem item = this.wRepeats.table.getItem(i);
            item.setText(1, repeat.getType() != null ? repeat.getType().getDescription() : "");
            item.setText(2, Const.NVL((String)repeat.getSourceField(), (String)""));
            item.setText(3, Const.NVL((String)repeat.getTargetField(), (String)""));
            item.setText(4, Const.NVL((String)repeat.getIndicatorFieldName(), (String)""));
            item.setText(5, Const.NVL((String)repeat.getIndicatorValue(), (String)""));
        }
        this.wGroup.setRowNums();
        this.wGroup.optWidth(true);
        this.wRepeats.setRowNums();
        this.wRepeats.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.showSortWarning();
        this.dispose();
    }

    private void showSortWarning() {
        if (!this.input.getGroupFields().isEmpty() && "Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.SortWarningDialog.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.SortWarningDialog.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.SortWarningDialog.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"RepeatFieldsDialog.SortWarningDialog.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
    }

    private void getInfo(RepeatFieldsMeta meta) {
        meta.getGroupFields().clear();
        for (TableItem item : this.wGroup.getNonEmptyItems()) {
            this.input.getGroupFields().add(item.getText(1));
        }
        meta.getRepeats().clear();
        for (TableItem item : this.wRepeats.getNonEmptyItems()) {
            Repeat repeat = new Repeat();
            repeat.setType(RepeatFieldsMeta.RepeatType.lookupDescription(item.getText(1)));
            repeat.setSourceField(item.getText(2));
            repeat.setTargetField(item.getText(3));
            repeat.setIndicatorFieldName(item.getText(4));
            repeat.setIndicatorValue(item.getText(5));
            meta.getRepeats().add(repeat);
        }
    }

    private void getGroups() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wGroup, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getRepeats() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wRepeats, (int)2, (int[])new int[]{2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

