/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400JDBCArray;
import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCCallableStatement;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionAbortRunnable;
import com.ibm.as400.access.AS400JDBCDatabaseMetaData;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCPreparedStatementImpl;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.AS400JDBCSavepoint;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTable13488;
import com.ibm.as400.access.Copyright;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBConcatenatedRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplyServerAttributes;
import com.ibm.as400.access.DBSQLAttributesDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLibraryList;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDSortSequence;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.ServerTrace;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AS400JDBCConnectionImpl
extends AS400JDBCConnection {
    private static final boolean TESTING_THREAD_SAFETY = false;
    private static int DEBUG_COMM_TRACE_ = 0;
    static final String CLIENT_FUNCTIONAL_LEVEL_ = "V7R2M01   ";
    private static final int DRDA_SCROLLABLE_CUTOFF_ = 129;
    private static final int DRDA_SCROLLABLE_MAX_ = 255;
    private static final int INITIAL_STATEMENT_TABLE_SIZE_ = 256;
    static final int UNICODE_CCSID_ = 13488;
    static final int MAX_STATEMENTS_ = 9999;
    private final boolean[] assigned_ = new boolean[9999];
    private AS400ImplRemote as400_;
    private AS400 as400PublicClassObj_;
    private boolean cancelling_;
    private CancelLock cancelLock_ = new CancelLock();
    private String catalog_;
    boolean checkStatementHoldability_ = false;
    private boolean closing_;
    private boolean aborted_ = false;
    private Thread abortingThread_ = null;
    ConvTable converter_;
    private int dataCompression_ = -1;
    private boolean disableCompression_ = false;
    JDDataSourceURL dataSourceUrl_;
    private boolean drda_;
    private String defaultSchema_;
    private boolean extendedFormats_;
    private Vector heldRequests_;
    private Lock heldRequestsLock = new ReentrantLock();
    private int holdability_ = -9999;
    private int id_;
    private AS400JDBCDatabaseMetaData metaData_;
    private JDPackageManager packageManager_;
    private JDProperties properties_;
    boolean readOnly_;
    private AS400Server server_;
    private int serverFunctionalLevel_;
    private String serverJobIdentifier_ = null;
    private SQLWarning sqlWarning_;
    private Vector statements_ = new Vector(256);
    JDTransactionManager transactionManager_;
    static final ConvTable unicodeConverter_ = new ConvTable13488();
    ConvTable packageCCSID_Converter = null;
    int vrm_;
    private int correlationID_ = 0;
    private int traceServer_ = 0;
    private boolean databaseHostServerTrace_ = false;
    private boolean mustSpecifyForUpdate_ = true;
    private int statementCount_ = 0;
    private boolean thousandStatements_ = false;
    private String qaqqiniLibrary_ = null;
    int newAutoCommitSupport_ = 1;
    private boolean wrappedInsert_ = false;
    static final String applicationNamePropertyName_ = "ApplicationName";
    static final String clientUserPropertyName_ = "ClientUser";
    static final String clientHostnamePropertyName_ = "ClientHostname";
    static final String clientAccountingPropertyName_ = "ClientAccounting";
    static final String clientProgramIDPropertyName_ = "ClientProgramID";
    private String applicationName_ = "";
    private String clientUser_ = "";
    private String clientHostname_ = "";
    private String clientAccounting_ = "";
    private String clientProgramID_ = "";
    private String ignoreWarnings_ = "";
    private boolean ignoreAllWarnings_ = false;
    private int concurrentAccessResolution_ = 0;
    private boolean useBlockUpdate_ = false;
    private int maximumBlockedInputRows_ = 32000;
    protected static final int QUERY_TIMEOUT_QQRYTIMLMT = 0;
    protected static final int QUERY_TIMEOUT_CANCEL = 1;
    private int queryTimeoutMechanism_ = 0;
    boolean variableFieldCompressionPropertyEvaluated_ = false;
    boolean useVariableFieldCompression_ = false;
    boolean useVariableFieldInsertCompression_ = false;
    String queryReplaceTruncatedParameter_ = null;
    private static final int CHARACTER_TRUNCATION_DEFAULT = 0;
    private static final int CHARACTER_TRUNCATION_WARNING = 1;
    private static final int CHARACTER_TRUNCATION_NONE = 2;
    private int characterTruncation_ = 0;
    private static final int NUMERIC_RANGE_ERROR_DEFAULT = 0;
    private static final int NUMERIC_RANGE_ERROR_WARNING = 1;
    private static final int NUMERIC_RANGE_ERROR_NONE = 2;
    private int numericRangeError_ = 0;
    String lastServerSQLState_;
    private String alternateServer_ = null;
    String portNumberString = "*N";
    int portNumber = 0;
    private String systemName_;
    String[] emptyStringArray = null;

    AS400JDBCConnectionImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(int id) throws SQLException {
        CancelLock cancelLock = this.cancelLock_;
        synchronized (cancelLock) {
            block22: {
                this.cancelling_ = true;
                AS400JDBCConnectionImpl cancelConnection = null;
                try {
                    if (this.serverJobIdentifier_ != null && this.serverFunctionalLevel_ >= 5) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Cancelling statement " + id);
                        }
                        cancelConnection = new AS400JDBCConnectionImpl();
                        cancelConnection.setProperties(this.dataSourceUrl_, this.properties_, this.as400_, true, false);
                        DBBaseRequestDS request = null;
                        DBReplyRequestedDS cancelReply = null;
                        try {
                            request = DBDSPool.getDBSQLRequestDS(6168, this.id_, Integer.MIN_VALUE, 0);
                            ((DBSQLRequestDS)request).setJobIdentifier(this.serverJobIdentifier_, this.converter_);
                            cancelReply = cancelConnection.sendAndReceive(request);
                            int errorClass = cancelReply.getErrorClass();
                            int returnCode = cancelReply.getReturnCode();
                            if (errorClass != 0) {
                                JDError.throwSQLException(this, this, this.id_, errorClass, returnCode);
                            }
                            break block22;
                        }
                        catch (DBDataStreamException e) {
                            JDError.throwSQLException((Object)this, "HY000", e);
                            break block22;
                        }
                        finally {
                            if (request != null) {
                                request.returnToPool();
                                request = null;
                            }
                            if (cancelReply != null) {
                                cancelReply.returnToPool();
                                cancelReply = null;
                            }
                        }
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Cancel of statement " + id + " requested, but is not supported by system");
                    }
                }
                finally {
                    if (cancelConnection != null) {
                        try {
                            cancelConnection.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.cancelling_ = false;
                    this.cancelLock_.notifyAll();
                }
            }
        }
    }

    @Override
    public void checkAccess(JDSQLStatement sqlStatement) throws SQLException {
        String access = this.properties_.getString(0);
        if (access.equalsIgnoreCase("read only") && !sqlStatement.isSelect() && !sqlStatement.getIsMetaDataCall()) {
            JDError.throwSQLException((Object)this, "42505");
        }
        if ((this.readOnly_ || access.equalsIgnoreCase("read call")) && !sqlStatement.isSelect() && !sqlStatement.isProcedureCall()) {
            JDError.throwSQLException((Object)this, "42505");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkCancel() {
        CancelLock cancelLock = this.cancelLock_;
        synchronized (cancelLock) {
            while (this.cancelling_) {
                try {
                    this.cancelLock_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public boolean checkHoldabilityConstants(int holdability) {
        return holdability == 1 || holdability == 2 || holdability == -9999;
    }

    @Override
    public void checkOpen() throws SQLException {
        if (this.server_ == null) {
            JDError.throwSQLException((Object)this, "08003");
        }
        if (this.aborted_ && Thread.currentThread() != this.abortingThread_) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Returning closed since aborted_");
            }
            JDError.throwSQLException((Object)this, "08003");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.closing_) {
            return;
        }
        this.closing_ = true;
        if (this.isClosed()) {
            return;
        }
        this.pseudoClose();
        if (this.server_ != null) {
            this.as400_.disconnectServer(this.server_);
            this.server_ = null;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logClose(this);
        }
    }

    @Override
    public void handleAbort() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "handleAbort() called");
        }
        this.abortingThread_ = Thread.currentThread();
        Vector statements = (Vector)this.statements_.clone();
        Enumeration list = statements.elements();
        while (list.hasMoreElements()) {
            AS400JDBCStatement statement = (AS400JDBCStatement)list.nextElement();
            statement.cancelled_ = true;
        }
        try {
            this.cancel(0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.closing_ = true;
        try {
            this.pseudoClose();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.server_ != null) {
            this.as400_.disconnectServer(this.server_);
            this.server_ = null;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (!this.transactionManager_.isLocalTransaction()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (this.transactionManager_.getAutoCommit() && this.properties_.getBoolean(75)) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        this.transactionManager_.commit();
        if (this.transactionManager_.getHoldIndicator() == 0 || this.checkStatementHoldability_ && this.getVRM() >= JDUtilities.vrm520) {
            this.markCursorsClosed(false);
        }
        if (!this.getAutoCommit() && this.properties_.getBoolean(63)) {
            this.markStatementsClosed();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Transaction commit");
        }
    }

    @Override
    public void setCheckStatementHoldability(boolean check) {
        this.checkStatementHoldability_ = check;
    }

    @Override
    public int correctResultSetType(int resultSetType, int resultSetConcurrency) throws SQLException {
        int newResultSetType = resultSetConcurrency == 1008 ? 1005 : 1004;
        this.postWarningSQLState("01S02");
        return newResultSetType;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(this, 1003, 1007, this.getInternalHoldability());
    }

    public Statement createStatement(AS400JDBCConnection con) throws SQLException {
        return this.createStatement(con, 1003, 1007, this.getInternalHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(this, resultSetType, resultSetConcurrency, this.getInternalHoldability());
    }

    public Statement createStatement(AS400JDBCConnection con, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(con, resultSetType, resultSetConcurrency, this.getInternalHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Statement createStatement(AS400JDBCConnection con, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        int size;
        this.checkOpen();
        if (!this.metaData_.supportsResultSetConcurrency(resultSetType, resultSetConcurrency)) {
            resultSetType = this.correctResultSetType(resultSetType, resultSetConcurrency);
        }
        if (!this.checkHoldabilityConstants(resultSetHoldability)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        int statementId = this.getUnusedId(resultSetType);
        AS400JDBCStatement statement = new AS400JDBCStatement(con, statementId, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), this.properties_.getBoolean(17), this.properties_.getString(30), resultSetType, resultSetConcurrency, resultSetHoldability, -9999);
        this.statements_.addElement(statement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarningSQLState("01G00");
        }
        if (JDTrace.isTraceOn() && (size = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + size);
        }
        return statement;
    }

    @Override
    public void debug(DBBaseRequestDS request) {
        if (DEBUG_COMM_TRACE_ >= 1) {
            System.out.println("Server request: " + Integer.toString(request.getServerID(), 16).toUpperCase() + ":" + Integer.toString(request.getReqRepID(), 16).toUpperCase() + ".");
        }
        if (DEBUG_COMM_TRACE_ >= 2) {
            request.dump(System.out);
        }
    }

    @Override
    public void debug(DBReplyRequestedDS reply) {
        if (DEBUG_COMM_TRACE_ >= 1) {
            System.out.println("Server reply:   " + Integer.toString(reply.getServerID(), 16).toUpperCase() + ":" + Integer.toString(reply.getReturnDataFunctionId(), 16).toUpperCase() + ".");
        }
        if (DEBUG_COMM_TRACE_ >= 2) {
            reply.dump(System.out);
        }
        if (DEBUG_COMM_TRACE_ >= 1) {
            int returnCode = reply.getReturnCode();
            int errorClass = reply.getErrorClass();
            if (errorClass != 0 || returnCode != 0) {
                System.out.println("Server error = " + errorClass + ":" + returnCode + ".");
            }
        }
    }

    public void finalize() throws Throwable {
        if (!this.isClosed()) {
            JDTrace.logInformation(this, "WARNING: Finalizer thread closing connection object.");
            this.close();
        }
        super.finalize();
    }

    @Override
    public AS400Impl getAS400() throws SQLException {
        return this.as400_;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.transactionManager_.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.catalog_;
    }

    @Override
    public int getConcurrentAccessResolution() {
        return this.concurrentAccessResolution_;
    }

    @Override
    public ConvTable getConverter(int ccsid) throws SQLException {
        try {
            if (ccsid == 0 || ccsid == 1 || ccsid == 65535 || ccsid == -1) {
                return this.converter_;
            }
            return ConvTable.getTable(ccsid, null);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public int getDataCompression() {
        return this.dataCompression_;
    }

    @Override
    public String getDefaultSchema() throws SQLException {
        return this.defaultSchema_ == null ? "QGPL" : this.defaultSchema_;
    }

    @Override
    public String getDefaultSchema(boolean returnRawValue) throws SQLException {
        return returnRawValue || this.defaultSchema_ != null ? this.defaultSchema_ : "QGPL";
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        if (this.holdability_ == 1 || this.holdability_ == 2) {
            return this.holdability_;
        }
        if (this.transactionManager_.getHoldIndicator() == 1) {
            return 1;
        }
        if (this.transactionManager_.getHoldIndicator() == 0) {
            return 2;
        }
        JDError.throwSQLException((Object)this, "HY000");
        return 1;
    }

    @Override
    public int getID() {
        return this.id_;
    }

    @Override
    public int getInternalHoldability() {
        return this.holdability_;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData_;
    }

    @Override
    public JDProperties getProperties() throws SQLException {
        return this.properties_;
    }

    @Override
    public String getServerJobIdentifier() {
        return this.serverJobIdentifier_;
    }

    @Override
    public int getServerFunctionalLevel() {
        return this.serverFunctionalLevel_;
    }

    @Override
    public AS400 getSystem() {
        return this.as400PublicClassObj_;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.transactionManager_.getIsolation();
    }

    @Override
    public JDTransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    @Override
    public Map getTypeMap() throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnusedId(int resultSetType) throws SQLException {
        boolean[] blArray = this.assigned_;
        synchronized (this.assigned_) {
            if (this.drda_) {
                if (resultSetType == 1003) {
                    for (int i = 1; i < 129; ++i) {
                        if (this.assigned_[i]) continue;
                        this.assigned_[i] = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return i;
                    }
                } else {
                    for (int i = 129; i < 255; ++i) {
                        if (this.assigned_[i]) continue;
                        this.assigned_[i] = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return i;
                    }
                }
            } else {
                for (int i = 1; i < 9999; ++i) {
                    if (this.assigned_[i]) continue;
                    this.assigned_[i] = true;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return i;
                }
            }
            JDError.throwSQLException((Object)this, "HY014");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    @Override
    public boolean getMustSpecifyForUpdate() {
        return this.mustSpecifyForUpdate_;
    }

    @Override
    public String getURL() throws SQLException {
        return this.dataSourceUrl_.toString();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.as400_.getUserId();
    }

    @Override
    public int getVRM() throws SQLException {
        return this.vrm_;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    @Override
    public boolean isCursorNameUsed(String cursorName) throws SQLException {
        Vector statements = (Vector)this.statements_.clone();
        Enumeration list = statements.elements();
        while (list.hasMoreElements()) {
            try {
                if (!((AS400JDBCStatement)list.nextElement()).getCursorName().equalsIgnoreCase(cursorName)) continue;
                return true;
            }
            catch (Exception e) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logException(this, "isCursorNameUsed caught exception", e);
            }
        }
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.aborted_ && Thread.currentThread() != this.abortingThread_) {
            return true;
        }
        if (this.server_ == null) {
            return true;
        }
        if (!this.server_.isConnected()) {
            this.server_ = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.readOnly_ || this.isReadOnlyAccordingToProperties();
    }

    @Override
    public boolean isReadOnlyAccordingToProperties() throws SQLException {
        this.checkOpen();
        return this.properties_.getString(0).equalsIgnoreCase("read only") || this.properties_.getString(0).equalsIgnoreCase("read call");
    }

    @Override
    public void markCursorsClosed(boolean isRollback) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Testing to see if cursors should be held.");
        }
        Vector statements = (Vector)this.statements_.clone();
        Enumeration list = statements.elements();
        while (list.hasMoreElements()) {
            AS400JDBCStatement statement = (AS400JDBCStatement)list.nextElement();
            try {
                if (statement.isHoldStatement()) continue;
                statement.markCursorClosed(isRollback);
            }
            catch (SQLException ex) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logException(this, "markCursorsClosed caught exception", ex);
            }
        }
    }

    @Override
    public void markStatementsClosed() {
        if (!this.statements_.isEmpty()) {
            Vector statements = (Vector)this.statements_.clone();
            Enumeration list = statements.elements();
            while (list.hasMoreElements()) {
                AS400JDBCStatement statement = (AS400JDBCStatement)list.nextElement();
                try {
                    if (!statement.isHoldStatement()) continue;
                    statement.setAssociatedWithLocators(false);
                    statement.finishClosing();
                }
                catch (SQLException e) {
                    if (!JDTrace.isTraceOn()) continue;
                    JDTrace.logInformation(this, "Closing statement after rollback failed: " + e.getMessage());
                }
            }
        }
    }

    @Override
    public String makeGeneratedKeySelectStatement(String sql, int[] columnIndexes, String[] columnNames) throws SQLException {
        if (columnIndexes != null) {
            if (columnIndexes.length == 0) {
                JDError.throwSQLException("HY024");
            }
            StringBuilder selectAll = new StringBuilder("SELECT * FROM NEW TABLE(");
            selectAll.append(sql);
            selectAll.append(")");
            PreparedStatement genPrepStat = this.prepareStatement(selectAll.toString());
            JDServerRow results = ((AS400JDBCPreparedStatement)genPrepStat).getResultRow();
            columnNames = new String[columnIndexes.length];
            try {
                for (int j = 0; j < columnIndexes.length; ++j) {
                    columnNames[j] = results.getFieldName(columnIndexes[j]);
                }
            }
            catch (SQLException e) {
                genPrepStat.close();
                JDError.throwSQLException("HY024");
            }
            genPrepStat.close();
        }
        if (columnNames == null || columnNames.length == 0) {
            JDError.throwSQLException("HY024");
            return "";
        }
        StringBuilder selectFrom = new StringBuilder("SELECT " + columnNames[0]);
        for (int i = 1; i < columnNames.length; ++i) {
            selectFrom.append(",");
            selectFrom.append(columnNames[i]);
        }
        selectFrom.append(" FROM NEW TABLE(");
        selectFrom.append(sql);
        selectFrom.append(")");
        return selectFrom.toString();
    }

    @Override
    public String makeGeneratedKeySelectStatement(String sql) throws SQLException {
        StringBuilder selectFrom = new StringBuilder("SELECT *SQLGENCOLUMNS FROM NEW TABLE(");
        selectFrom.append(sql);
        selectFrom.append(")");
        return selectFrom.toString();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.nativeSQL(this, sql);
    }

    public String nativeSQL(AS400JDBCConnection con, String sql) throws SQLException {
        JDSQLStatement sqlStatement = new JDSQLStatement(sql, this.properties_.getString(5), true, this.properties_.getString(30), con);
        return sqlStatement.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyClose(AS400JDBCStatement statement, int id) throws SQLException {
        this.statements_.removeElement(statement);
        --this.statementCount_;
        boolean[] blArray = this.assigned_;
        synchronized (this.assigned_) {
            this.assigned_[id] = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void postWarningSQLState(String sqlState) throws SQLException {
        if (!this.ignoreWarning(sqlState)) {
            SQLWarning sqlWarning = JDError.getSQLWarning(sqlState);
            if (this.sqlWarning_ == null) {
                this.sqlWarning_ = sqlWarning;
            } else {
                this.sqlWarning_.setNextWarning(sqlWarning);
            }
        }
    }

    @Override
    public void postWarning(int id, int errorClass, int returnCode) throws SQLException {
        String sqlState = JDError.getSQLState(this, id);
        if (!this.ignoreWarning(sqlState)) {
            SQLWarning sqlWarning = JDError.getSQLWarning(this, id, errorClass, returnCode);
            if (this.sqlWarning_ == null) {
                this.sqlWarning_ = sqlWarning;
            } else {
                this.sqlWarning_.setNextWarning(sqlWarning);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(this, sql, 1003, 1007, this.getInternalHoldability());
    }

    public CallableStatement prepareCall(AS400JDBCConnection con, String sql) throws SQLException {
        return this.prepareCall(con, sql, 1003, 1007, this.getInternalHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(this, sql, resultSetType, resultSetConcurrency, this.getInternalHoldability());
    }

    public CallableStatement prepareCall(AS400JDBCConnection con, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(con, sql, resultSetType, resultSetConcurrency, this.getInternalHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(AS400JDBCConnection con, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        int size;
        this.checkOpen();
        if (!this.metaData_.supportsResultSetConcurrency(resultSetType, resultSetConcurrency)) {
            resultSetType = this.correctResultSetType(resultSetType, resultSetConcurrency);
        }
        if (!this.checkHoldabilityConstants(resultSetHoldability)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        JDSQLStatement sqlStatement = new JDSQLStatement(sql, this.properties_.getString(5), true, this.properties_.getString(30), this);
        int statementId = this.getUnusedId(resultSetType);
        AS400JDBCCallableStatement statement = new AS400JDBCCallableStatement(con, statementId, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), sqlStatement, this.properties_.getString(30), resultSetType, resultSetConcurrency, resultSetHoldability, -9999);
        this.statements_.addElement(statement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarningSQLState("01G00");
        }
        if (JDTrace.isTraceOn() && (size = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + size);
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(this, sql);
    }

    public PreparedStatement prepareStatement(AS400JDBCConnection con, String sql) throws SQLException {
        return this.prepareStatement(con, sql, 1003, 1007, this.getInternalHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement((AS400JDBCConnection)this, sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(AS400JDBCConnection con, String sql, int autoGeneratedKeys) throws SQLException {
        int size;
        if (this.getVRM() < JDUtilities.vrm520) {
            JDError.throwSQLException((Object)this, "IM001");
        }
        this.checkOpen();
        JDSQLStatement sqlStatement = new JDSQLStatement(sql, this.properties_.getString(5), true, this.properties_.getString(30), con);
        if (this.getVRM() >= JDUtilities.vrm610 && autoGeneratedKeys == 1 && sqlStatement.isInsert_) {
            String selectStatement = this.makeGeneratedKeySelectStatement(sql);
            sqlStatement = new JDSQLStatement(selectStatement, this.properties_.getString(5), true, this.properties_.getString(30), con);
            this.wrappedInsert_ = true;
        }
        int statementId = this.getUnusedId(1003);
        if (this.wrappedInsert_) {
            sqlStatement.setSelectFromInsert(true);
            this.wrappedInsert_ = false;
        }
        AS400JDBCPreparedStatementImpl statement = new AS400JDBCPreparedStatementImpl(con, statementId, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), this.properties_.getBoolean(17), sqlStatement, false, this.properties_.getString(30), 1003, 1007, this.getInternalHoldability(), autoGeneratedKeys);
        this.statements_.addElement(statement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarningSQLState("01G00");
        }
        if (JDTrace.isTraceOn() && (size = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + size);
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(this, sql, resultSetType, resultSetConcurrency, this.getInternalHoldability());
    }

    public PreparedStatement prepareStatement(AS400JDBCConnection con, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(con, sql, resultSetType, resultSetConcurrency, this.getInternalHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(AS400JDBCConnection con, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        int size;
        this.checkOpen();
        if (!this.metaData_.supportsResultSetConcurrency(resultSetType, resultSetConcurrency)) {
            resultSetType = this.correctResultSetType(resultSetType, resultSetConcurrency);
        }
        if (!this.checkHoldabilityConstants(resultSetHoldability)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        JDSQLStatement sqlStatement = new JDSQLStatement(sql, this.properties_.getString(5), true, this.properties_.getString(30), con);
        int statementId = this.getUnusedId(resultSetType);
        AS400JDBCPreparedStatementImpl statement = new AS400JDBCPreparedStatementImpl(con, statementId, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), this.properties_.getBoolean(17), sqlStatement, false, this.properties_.getString(30), resultSetType, resultSetConcurrency, resultSetHoldability, -9999);
        this.statements_.addElement(statement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarningSQLState("01G00");
        }
        if (JDTrace.isTraceOn() && (size = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + size);
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement((AS400JDBCConnection)this, sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(AS400JDBCConnection con, String sql, int[] columnIndexes) throws SQLException {
        if (this.getVRM() >= JDUtilities.vrm610) {
            this.checkOpen();
            JDSQLStatement sqlStatement = new JDSQLStatement(sql, this.properties_.getString(5), true, this.properties_.getString(30), con);
            if (sqlStatement.isInsert_) {
                this.wrappedInsert_ = true;
                return this.prepareStatement(con, this.makeGeneratedKeySelectStatement(sql, columnIndexes, null), 1);
            }
            return this.prepareStatement(con, sql);
        }
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement((AS400JDBCConnection)this, sql, columnNames);
    }

    public PreparedStatement prepareStatement(AS400JDBCConnection con, String sql, String[] columnNames) throws SQLException {
        if (this.getVRM() >= JDUtilities.vrm610) {
            this.checkOpen();
            JDSQLStatement sqlStatement = new JDSQLStatement(sql, this.properties_.getString(5), true, this.properties_.getString(30), con);
            if (sqlStatement.isInsert_) {
                this.wrappedInsert_ = true;
                return this.prepareStatement(con, this.makeGeneratedKeySelectStatement(sql, null, columnNames), 1);
            }
            return this.prepareStatement(con, sql);
        }
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public void processSavepointRequest(String savepointStatement) throws SQLException {
        if (this.vrm_ < JDUtilities.vrm520) {
            JDError.throwSQLException((Object)this, "IM001");
        }
        if (!this.transactionManager_.isLocalTransaction()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (this.getAutoCommit()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        try (Statement statement = null;){
            statement = this.createStatement();
            statement.executeUpdate(savepointStatement);
        }
    }

    @Override
    public void pseudoClose() throws SQLException {
        if (this.transactionManager_.isLocalTransaction() && this.transactionManager_.isLocalActive()) {
            this.rollback();
        }
        Vector statements = (Vector)this.statements_.clone();
        Enumeration list = statements.elements();
        while (list.hasMoreElements()) {
            AS400JDBCStatement statement = (AS400JDBCStatement)list.nextElement();
            try {
                if (statement.isHoldStatement()) {
                    statement.setAssociatedWithLocators(false);
                    statement.finishClosing();
                }
                if (statement.isClosed()) continue;
                statement.close();
            }
            catch (SQLException e) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Closing statement while closing connection failed: " + e.getMessage());
            }
        }
        if (this.traceServer_ > 0 || this.databaseHostServerTrace_) {
            String serverJobIdentifier = this.getServerJobIdentifier();
            boolean preV5R1 = true;
            boolean SQLNaming = this.properties_.getString(9).equals("sql");
            try {
                preV5R1 = this.getVRM() <= JDUtilities.vrm450;
            }
            catch (Exception e) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not get server VRM");
            }
            boolean endedTraceJob = false;
            if ((this.traceServer_ & 0x10) > 0) {
                try {
                    if (preV5R1) {
                        JDUtilities.runCommand(this, "QSYS/TRCJOB SET(*OFF) OUTPUT(*PRINT)", SQLNaming);
                    } else {
                        JDUtilities.runCommand(this, "QSYS/ENDTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") DTAOPT(*LIB) DTALIB(QUSRSYS) RPLDTA(*YES) PRTTRC(*YES)", SQLNaming);
                        JDUtilities.runCommand(this, "QSYS/DLTTRC DTAMBR(QJT" + serverJobIdentifier.substring(20) + ") DTALIB(QUSRSYS)", SQLNaming);
                    }
                    endedTraceJob = true;
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed");
                }
            }
            if (this.getVRM() >= JDUtilities.vrm530 && !endedTraceJob && ((this.traceServer_ & 0x40) > 0 || this.databaseHostServerTrace_)) {
                try {
                    JDUtilities.runCommand(this, "QSYS/ENDTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") DTAOPT(*LIB) DTALIB(QUSRSYS) RPLDTA(*YES) PRTTRC(*YES)", SQLNaming);
                    JDUtilities.runCommand(this, "QSYS/DLTTRC DTAMBR(QJT" + serverJobIdentifier.substring(20) + ") DTALIB(QUSRSYS)", SQLNaming);
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end database host server tracing failed.");
                }
            }
            if ((this.traceServer_ & 4) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/ENDDBG", SQLNaming);
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not end debug on server job ");
                }
            }
            if ((this.traceServer_ & 2) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/ENDDBMON", SQLNaming);
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not end database monitor");
                }
            }
            if ((this.traceServer_ & 0x20) > 0 && !preV5R1) {
                try {
                    JDUtilities.runCommand(this, "QSYS/PRTSQLINF *JOB", SQLNaming);
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not print SQL information");
                }
            }
            if ((this.traceServer_ & 8) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/DSPJOBLOG JOB(*) OUTPUT(*PRINT)", SQLNaming);
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not save job log");
                }
            }
            if ((this.traceServer_ & 1) > 0) {
                JDTrace.setTraceOn(false);
            }
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            throw new NullPointerException("savepoint");
        }
        AS400JDBCSavepoint sp = (AS400JDBCSavepoint)savepoint;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Releasing savepoint " + sp.getName());
        }
        if (sp.getStatus() != 1) {
            JDError.throwSQLException((Object)this, "3B502");
        }
        String SQLCommand = "RELEASE SAVEPOINT " + sp.getName();
        this.processSavepointRequest(SQLCommand);
        sp.setStatus(2);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Savepoint " + sp.getName() + " released.");
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (!this.transactionManager_.isLocalTransaction()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (this.transactionManager_.getAutoCommit() && this.properties_.getBoolean(75)) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (!this.transactionManager_.getAutoCommit()) {
            this.transactionManager_.rollback();
            this.markCursorsClosed(true);
            if (this.properties_.getBoolean(63)) {
                this.markStatementsClosed();
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Transaction rollback");
            }
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            throw new NullPointerException("savepoint");
        }
        AS400JDBCSavepoint sp = (AS400JDBCSavepoint)savepoint;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Rollback with savepoint " + sp.getName());
        }
        if (sp.getStatus() != 1) {
            JDError.throwSQLException((Object)this, "3B502");
        }
        String SQLCommand = "ROLLBACK TO SAVEPOINT " + sp.getName();
        this.processSavepointRequest(SQLCommand);
        sp.setStatus(2);
        if (this.properties_.getBoolean(63)) {
            this.markStatementsClosed();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Rollback with savepoint " + sp.getName() + " complete.");
        }
    }

    @Override
    public void send(DBBaseRequestDS request) throws SQLException {
        this.send(request, this.id_, true);
    }

    @Override
    public void send(DBBaseRequestDS request, int id) throws SQLException {
        this.send(request, id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DBBaseRequestDS request, int id, boolean leavePending) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        try {
            if (JDTrace.isTraceOn() && request.getOperationResultBitmap() != 0) {
                JDTrace.logInformation(this, "Reply requested but not collected:" + request.getReqRepID());
            }
            request.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386 && !this.disableCompression_) {
                request.addOperationResultBitmap(524288);
                request.addOperationResultBitmap(262144);
                request.compress();
            }
            try {
                this.heldRequestsLock.lock();
                ClientAccessDataStream actualRequest = this.heldRequests_ != null ? new DBConcatenatedRequestDS(this.heldRequests_, request) : request;
                this.heldRequests_ = null;
                this.server_.send(actualRequest);
            }
            finally {
                this.heldRequestsLock.unlock();
            }
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(request);
            }
        }
        catch (IOException e) {
            this.as400_.disconnectServer(this.server_);
            this.server_ = null;
            JDError.throwSQLException((Object)this, "08S01", e);
        }
        catch (Exception e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
    }

    @Override
    public void sendAndHold(DBBaseRequestDS request, int id) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        try {
            if (JDTrace.isTraceOn() && request.getOperationResultBitmap() != 0) {
                JDTrace.logInformation(this, "Reply requested but not collected:" + request.getReqRepID());
            }
            request.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386 && !this.disableCompression_) {
                request.addOperationResultBitmap(524288);
                request.addOperationResultBitmap(262144);
                request.compress();
            }
            try {
                this.heldRequestsLock.lock();
                if (this.heldRequests_ == null) {
                    this.heldRequests_ = new Vector();
                }
                this.heldRequests_.addElement(request);
            }
            finally {
                this.heldRequestsLock.unlock();
            }
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(request);
                System.out.println("This request was HELD.");
            }
        }
        catch (Exception e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
    }

    @Override
    public DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request) throws SQLException {
        return this.sendAndReceive(request, this.id_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request, int id) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        DBReplyRequestedDS reply = null;
        try {
            request.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386 && !this.disableCompression_) {
                request.addOperationResultBitmap(524288);
                request.addOperationResultBitmap(262144);
                request.compress();
            }
            try {
                this.heldRequestsLock.lock();
                ClientAccessDataStream actualRequest = this.heldRequests_ != null ? new DBConcatenatedRequestDS(this.heldRequests_, request) : request;
                this.heldRequests_ = null;
                reply = (DBReplyRequestedDS)this.server_.sendAndReceive(actualRequest);
            }
            finally {
                this.heldRequestsLock.unlock();
            }
            reply.parse(this.dataCompression_);
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(request);
                this.debug(reply);
            }
        }
        catch (IOException e) {
            this.as400_.disconnectServer(this.server_);
            this.server_ = null;
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Communication Link Failure ");
                Trace.log(2, e);
                Trace.log(2, "Server job is " + this.serverJobIdentifier_);
                if (request != null && request.data_ != null) {
                    Trace.log(2, "Request bytes", request.data_);
                }
            }
            JDError.throwSQLException((Object)this, "08S01", e);
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Unexpected exception ");
                Trace.log(2, e);
                Trace.log(2, "Server job is " + this.serverJobIdentifier_);
                if (request != null && request.data_ != null) {
                    Trace.log(2, "Request bytes", request.data_);
                }
            } else if (JDTrace.isTraceOn()) {
                JDTrace.logException(this, "Unexpected exception", e);
                JDTrace.logInformation(this, "Server job is " + this.serverJobIdentifier_);
            }
            JDError.throwSQLException((Object)this, "HY000", e);
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBReplyRequestedDS sendAndMultiReceive(DBBaseRequestDS request) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        DBReplyRequestedDS reply = null;
        try {
            request.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386 && !this.disableCompression_) {
                request.addOperationResultBitmap(524288);
                request.addOperationResultBitmap(262144);
                request.compress();
            }
            try {
                this.heldRequestsLock.lock();
                ClientAccessDataStream actualRequest = this.heldRequests_ != null ? new DBConcatenatedRequestDS(this.heldRequests_, request) : request;
                this.heldRequests_ = null;
                this.correlationID_ = this.server_.send(actualRequest);
                reply = (DBReplyRequestedDS)this.server_.receive(this.correlationID_);
            }
            finally {
                this.heldRequestsLock.unlock();
            }
            reply.parse(this.dataCompression_);
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(request);
                this.debug(reply);
            }
        }
        catch (IOException e) {
            this.as400_.disconnectServer(this.server_);
            this.server_ = null;
            JDError.throwSQLException((Object)this, "08S01", e);
        }
        catch (Exception e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
        return reply;
    }

    @Override
    public DBReplyRequestedDS receiveMoreData() throws SQLException {
        DBReplyRequestedDS reply;
        block5: {
            reply = null;
            try {
                if (this.correlationID_ <= 0) break block5;
                try {
                    this.heldRequestsLock.lock();
                    reply = (DBReplyRequestedDS)this.server_.receive(this.correlationID_);
                }
                finally {
                    this.heldRequestsLock.unlock();
                }
                reply.parse(this.dataCompression_);
            }
            catch (Exception e) {
                JDError.throwSQLException((Object)this, "HY000", e);
            }
        }
        return reply;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this.transactionManager_.setAutoCommit(autoCommit);
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setAutoCommit", "Auto commit", this.transactionManager_.getAutoCommit());
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConcurrentAccessResolution(int concurrentAccessResolution) throws SQLException {
        DBBaseRequestDS request = null;
        DBReplyRequestedDS reply = null;
        try {
            if (this.getVRM() >= JDUtilities.vrm710) {
                request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                int car = this.properties_.getInt(79);
                ((DBSQLAttributesDS)request).setConcurrentAccessResolution(car);
                reply = this.sendAndReceive(request);
                int errorClass = reply.getErrorClass();
                if (errorClass != 0) {
                    JDError.throwSQLException(this, this, this.id_, errorClass, reply.getReturnCode());
                }
            }
        }
        catch (Exception e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
        finally {
            if (request != null) {
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
        }
        this.concurrentAccessResolution_ = concurrentAccessResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDB2eWLMCorrelator(byte[] bytes) throws SQLException {
        if (this.vrm_ >= JDUtilities.vrm530) {
            DBBaseRequestDS request = null;
            DBReplyRequestedDS reply = null;
            try {
                if (bytes == null && JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Correlator is null");
                }
                request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                ((DBSQLAttributesDS)request).seteWLMCorrelator(bytes);
                reply = this.sendAndReceive(request);
                int errorClass = reply.getErrorClass();
                if (errorClass != 0) {
                    JDError.throwSQLException(this, this, this.id_, errorClass, reply.getReturnCode());
                }
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("HY000", e);
            }
            finally {
                if (request != null) {
                    request.returnToPool();
                    request = null;
                }
                if (reply != null) {
                    reply.returnToPool();
                    reply = null;
                }
            }
        }
    }

    @Override
    public void setDRDA(boolean drda) throws SQLException {
        this.drda_ = drda;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setDRDA", "DRDA", this.drda_);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        if (!this.checkHoldabilityConstants(holdability)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.holdability_ = holdability;
        if (holdability == 2) {
            this.transactionManager_.setHoldIndicator("FALSE");
        } else if (holdability == 1) {
            this.transactionManager_.setHoldIndicator("TRUE");
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setHoldability", "Holdability", this.holdability_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400 as400) throws SQLException {
        try {
            this.portNumber = 0;
            if (dataSourceUrl.isPortSpecified()) {
                this.portNumber = dataSourceUrl.getPortNumber();
            }
            if (this.portNumber == 0) {
                this.portNumber = properties.getInt(92);
            }
            if (this.portNumber > 0) {
                as400.skipSignonServer_ = true;
                as400.connectService(4, this.portNumber);
                this.portNumberString = "" + this.portNumber;
            } else {
                as400.connectService(4);
            }
            this.systemName_ = as400.getSystemName();
            this.as400PublicClassObj_ = as400;
        }
        catch (AS400SecurityException e) {
            JDError.throwSQLException((Object)this, "08004", e);
        }
        catch (IOException e) {
            JDError.throwSQLException((Object)this, "08001", e);
        }
        finally {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Calling DriverManager.getDrivers");
            }
            Enumeration<Driver> en = DriverManager.getDrivers();
            Driver firstDriver = null;
            Driver nextDriver = null;
            while (en.hasMoreElements()) {
                nextDriver = en.nextElement();
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "..found driver " + nextDriver.toString() + ":" + nextDriver.hashCode() + " class:" + nextDriver.getClass().toString());
                }
                if (!(nextDriver instanceof AS400JDBCDriver)) continue;
                if (firstDriver == null) {
                    firstDriver = nextDriver;
                    continue;
                }
                DriverManager.deregisterDriver(nextDriver);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "done looking at drivers");
            }
        }
        this.setProperties(dataSourceUrl, properties, as400.getImpl(), false, as400.skipSignonServer_);
    }

    @Override
    public void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400Impl as400) throws SQLException {
        this.setProperties(dataSourceUrl, properties, as400, false, false);
    }

    @Override
    public boolean ignoreWarning(String sqlState) {
        if (this.ignoreAllWarnings_) {
            return true;
        }
        return this.ignoreWarnings_.indexOf(sqlState) >= 0;
    }

    public boolean ignoreWarning(SQLWarning warning) {
        return this.ignoreWarning(warning.getSQLState());
    }

    @Override
    public void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400Impl as400, boolean newServer, boolean skipSignonServer) throws SQLException {
        String queryReplaceTruncatedParameterString;
        String urlSchema;
        this.as400_ = (AS400ImplRemote)as400;
        this.dataSourceUrl_ = dataSourceUrl;
        this.extendedFormats_ = false;
        this.properties_ = properties;
        this.ignoreWarnings_ = this.properties_.getString(77).toUpperCase().trim();
        if (this.ignoreWarnings_.equals("ALL")) {
            this.ignoreAllWarnings_ = true;
        }
        if (this.properties_.getString(72).equals("-1")) {
            if (this.as400_.getVRM() < JDUtilities.vrm710) {
                this.properties_.setString(72, "0");
            } else {
                this.properties_.setString(72, "1");
            }
        }
        this.newAutoCommitSupport_ = this.as400_.getVRM() <= JDUtilities.vrm520 ? 0 : (!this.properties_.getBoolean(59) ? 1 : 2);
        if (this.as400_.getVRM() >= JDUtilities.vrm710) {
            this.useBlockUpdate_ = this.properties_.getBoolean(82);
        }
        this.maximumBlockedInputRows_ = this.properties_.getInt(83);
        if (this.maximumBlockedInputRows_ > 32000) {
            this.maximumBlockedInputRows_ = 32000;
        }
        if (this.maximumBlockedInputRows_ < 1) {
            this.maximumBlockedInputRows_ = 1;
        }
        if (this.dataSourceUrl_.isExtraPathSpecified()) {
            this.postWarningSQLState("01H10");
        }
        if (properties.isExtraPropertySpecified()) {
            this.postWarningSQLState("01H20");
        }
        if (this.dataSourceUrl_.isPortSpecified() && this.dataSourceUrl_.getPortNumber() == 0) {
            this.postWarningSQLState("01H10");
        }
        if ((urlSchema = this.dataSourceUrl_.getSchema()) == null) {
            JDError.throwSQLException((Object)this, "01H13");
        }
        JDLibraryList libraryList = new JDLibraryList(this.properties_.getString(8), urlSchema, this.properties_.getString(9));
        this.defaultSchema_ = libraryList.getDefaultSchema();
        this.transactionManager_ = new JDTransactionManager(this, this.id_, this.properties_.getString(27), this.properties_.getBoolean(76));
        this.transactionManager_.setHoldIndicator(this.properties_.getString(39));
        if (this.properties_.getString(39) != null) {
            if (this.transactionManager_.getHoldIndicator() == 1) {
                this.holdability_ = 1;
            } else if (this.transactionManager_.getHoldIndicator() == 0) {
                this.holdability_ = 2;
            }
        }
        this.readOnly_ = this.properties_.equals(0, "read only");
        this.traceServer_ = this.properties_.getInt(46) | ServerTrace.getJDBCServerTraceCategories();
        this.qaqqiniLibrary_ = this.properties_.getString(57);
        String queryTimeoutMechanismString = this.properties_.getString(84);
        if (queryTimeoutMechanismString != null) {
            this.queryTimeoutMechanism_ = (queryTimeoutMechanismString = queryTimeoutMechanismString.trim().toLowerCase()).equals("cancel") ? 1 : 0;
        }
        if ((queryReplaceTruncatedParameterString = this.properties_.getString(89)) != null) {
            this.queryReplaceTruncatedParameter_ = (queryReplaceTruncatedParameterString = queryReplaceTruncatedParameterString.trim()).equals(JDProperties.QUERY_REPLACE_TRUNCATED_PARAMETER_STRING_DEFAULT) ? null : queryReplaceTruncatedParameterString;
        }
        boolean dataTruncation = this.properties_.getBoolean(33);
        String characterTruncation = this.properties_.getString(91);
        if (characterTruncation == null || characterTruncation == "default") {
            this.characterTruncation_ = dataTruncation ? 0 : 2;
        } else if (characterTruncation.equals("warning")) {
            this.characterTruncation_ = 1;
        } else if (characterTruncation.equals("none")) {
            this.characterTruncation_ = 2;
        }
        String numericRangeError = this.properties_.getString(90);
        if (numericRangeError == null) {
            numericRangeError = "default";
        }
        if (numericRangeError.equals("default")) {
            this.numericRangeError_ = 0;
        } else if (numericRangeError.equals("warning")) {
            this.numericRangeError_ = 1;
        } else if (numericRangeError.equals("none")) {
            this.numericRangeError_ = 2;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation("Toolbox for Java - " + Copyright.version);
            JDTrace.logInformation("JDBC Level: " + JDUtilities.JDBCLevel_);
        }
        try {
            this.server_ = this.as400_.getConnection(4, -1, newServer, skipSignonServer);
        }
        catch (AS400SecurityException e) {
            JDError.throwSQLException((Object)this, "08004", e);
        }
        catch (IOException e) {
            JDError.throwSQLException((Object)this, "08001", e);
        }
        this.catalog_ = dataSourceUrl.getServerName();
        if (this.catalog_.length() == 0) {
            this.catalog_ = this.as400_.getSystemName().toUpperCase();
        }
        this.setServerAttributes();
        libraryList.addOnServer(this, this.id_);
        boolean useDRDAversion = this.properties_.getBoolean(88);
        this.metaData_ = new AS400JDBCDatabaseMetaData(this, this.id_, useDRDAversion);
        if (this.newAutoCommitSupport_ == 0) {
            this.transactionManager_.setAutoCommit(true);
        }
        this.packageManager_ = new JDPackageManager(this, this.id_, this.properties_, this.transactionManager_.getCommitMode());
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, null);
            JDTrace.logProperty((Object)this, "setProperties", "Auto commit", this.transactionManager_.getAutoCommit());
            JDTrace.logProperty((Object)this, "setProperties", "Read only", this.readOnly_);
            JDTrace.logProperty((Object)this, "setProperties", "Transaction isolation", this.transactionManager_.getIsolation());
            if (this.packageManager_.isEnabled()) {
                JDTrace.logInformation(this, "SQL package = " + this.packageManager_.getLibraryName() + "/" + this.packageManager_.getName());
            }
        }
        if (this.traceServer_ > 0) {
            boolean traceDatabaseHostServer;
            String serverJobIdentifier = this.getServerJobIdentifier();
            String serverJobId = serverJobIdentifier.substring(20).trim() + "/" + serverJobIdentifier.substring(10, 19).trim() + "/" + serverJobIdentifier.substring(0, 10).trim();
            JDTrace.logDataEvenIfTracingIsOff(this, Copyright.version);
            JDTrace.logDataEvenIfTracingIsOff(this, serverJobId);
            JDTrace.logDataEvenIfTracingIsOff(this, "Server functional level:  " + this.getServerFunctionalLevel());
            boolean preV5R1 = true;
            boolean SQLNaming = this.properties_.getString(9).equals("sql");
            try {
                preV5R1 = this.getVRM() <= JDUtilities.vrm450;
            }
            catch (Exception e) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not get server VRM");
            }
            if ((this.traceServer_ & 1) > 0 && !JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
            try {
                JDUtilities.runCommand(this, "QSYS/CHGJOB LOG(4 00 *SECLVL) LOGCLPGM(*YES)", SQLNaming);
            }
            catch (Exception e) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not change log level");
            }
            if ((this.traceServer_ & 4) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/STRDBG UPDPROD(*YES)", SQLNaming);
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not start debug on server job ");
                }
            }
            if ((this.traceServer_ & 2) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/STRDBMON OUTFILE(QUSRSYS/QJT" + serverJobIdentifier.substring(20) + ") JOB(*) TYPE(*DETAIL)", SQLNaming);
                }
                catch (Exception e) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not start database monitor");
                }
            }
            boolean traceServerJob = (this.traceServer_ & 0x10) > 0;
            boolean bl = traceDatabaseHostServer = this.getVRM() >= JDUtilities.vrm530 && (this.traceServer_ & 0x40) > 0;
            if (traceServerJob || traceDatabaseHostServer) {
                try {
                    if (preV5R1 && traceServerJob) {
                        JDUtilities.runCommand(this, "QSYS/TRCJOB MAXSTG(16000)", SQLNaming);
                    } else if (!traceDatabaseHostServer) {
                        JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") JOB(*) MAXSTG(128000)", SQLNaming);
                    } else if (!traceServerJob) {
                        if (this.getVRM() == JDUtilities.vrm530) {
                            JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) TRCTYPE((TESTA *INFO))", SQLNaming);
                        } else {
                            JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) TRCTYPE((*DBHSVR *INFO))", SQLNaming);
                        }
                    } else if (this.getVRM() == JDUtilities.vrm530) {
                        JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*ALL) TRCTYPE((TESTA *INFO))", SQLNaming);
                    } else {
                        JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*ALL) TRCTYPE((*DBHSVR *INFO))", SQLNaming);
                    }
                }
                catch (Exception e) {
                    if (traceServerJob && !traceDatabaseHostServer) {
                        JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not trace server job");
                    }
                    if (traceDatabaseHostServer && !traceServerJob) {
                        JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start database host server tracing failed, could not trace server job");
                    }
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job and database host server tracing failed, could not trace server job");
                }
            }
        }
        if (this.qaqqiniLibrary_.length() > 0 && !this.qaqqiniLibrary_.equals("null")) {
            boolean SQLNaming = this.properties_.getString(9).equals("sql");
            try {
                JDUtilities.runCommand(this, "CHGQRYA QRYOPTLIB(" + this.qaqqiniLibrary_ + ")", SQLNaming);
            }
            catch (Exception e) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to issue Change Query Attributes command using QAQQINI Library name failed.");
            }
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        if (this.transactionManager_.isLocalActive() || this.transactionManager_.isGlobalActive()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (!readOnly && (this.properties_.getString(0).equalsIgnoreCase("read only") || this.properties_.getString(0).equalsIgnoreCase("read call"))) {
            JDError.throwSQLException((Object)this, "42505");
        }
        this.readOnly_ = readOnly;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setProperties", "Read only", this.readOnly_);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null, AS400JDBCSavepoint.getNextId());
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.setSavepoint(name, 0);
    }

    @Override
    public Savepoint setSavepoint(String name, int id) throws SQLException {
        if (id > 0) {
            name = "T_JDBCINTERNAL_" + id;
        }
        this.processSavepointRequest("SAVEPOINT " + name + " ON ROLLBACK RETAIN CURSORS");
        return new AS400JDBCSavepoint(name, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setServerAttributes() throws SQLException {
        DBReplyRequestedDS reply = null;
        try {
            String rdbEntry;
            int decimalSeparator;
            int timeSeparator;
            int timeFormat;
            int dateSeparator;
            int dateFormat;
            if (this.as400_ == null) {
                throw new NullPointerException("as400_ not set");
            }
            this.vrm_ = this.as400_.getVRM();
            DBBaseRequestDS request = null;
            DBReplyServerAttributes serverAttributes = null;
            try {
                StringBuffer RDBName;
                String alternateServers;
                int enableClientAffinitiesList;
                ConvTable ccsid37Converter;
                ConvTable libraryNameConverter;
                block165: {
                    block164: {
                        int sendCCSIDInt;
                        request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        int thisRequestCcsid = 37;
                        if (this.as400_ != null && this.portNumber == 0) {
                            thisRequestCcsid = this.as400_.getCcsid();
                        }
                        libraryNameConverter = ConvTable.getTable(thisRequestCcsid, null);
                        ccsid37Converter = ConvTable.getTable(37, null);
                        String sendCCSID = this.properties_.getString(51);
                        int default_ccsid = Integer.parseInt("13488");
                        if (sendCCSID.equalsIgnoreCase("system")) {
                            int hostCCSID = this.as400PublicClassObj_ == null ? 37 : this.as400PublicClassObj_.getCcsid();
                            sendCCSIDInt = hostCCSID;
                        } else {
                            try {
                                sendCCSIDInt = Integer.valueOf(sendCCSID);
                                if (sendCCSIDInt <= 0) {
                                    sendCCSIDInt = default_ccsid;
                                }
                                if (this.vrm_ < JDUtilities.vrm530 && sendCCSIDInt == 1200) {
                                    sendCCSIDInt = default_ccsid;
                                }
                            }
                            catch (Exception e) {
                                sendCCSIDInt = default_ccsid;
                            }
                        }
                        this.packageCCSID_Converter = ConvTable.getTable(sendCCSIDInt, null);
                        this.properties_.setString(51, Integer.valueOf(sendCCSIDInt).toString());
                        ((DBSQLAttributesDS)request).setClientCCSID(sendCCSIDInt);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Client CCSID = " + sendCCSIDInt);
                        }
                        String nlv = this.as400_.getNLV();
                        ((DBSQLAttributesDS)request).setLanguageFeatureCode(nlv);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Setting server NLV = " + nlv);
                        }
                        String clientFunctionalLevel = CLIENT_FUNCTIONAL_LEVEL_;
                        ((DBSQLAttributesDS)request).setClientFunctionalLevel(clientFunctionalLevel);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Client functional level = V7R2M01   ");
                        }
                        ((DBSQLAttributesDS)request).setTranslateIndicator(240);
                        ((DBSQLAttributesDS)request).setDRDAPackageSize(1);
                        if (this.newAutoCommitSupport_ != 0) {
                            if (this.properties_.getBoolean(76)) {
                                ((DBSQLAttributesDS)request).setAutoCommit(232);
                            } else {
                                ((DBSQLAttributesDS)request).setAutoCommit(213);
                            }
                        }
                        if (this.newAutoCommitSupport_ == 1 && this.properties_.getBoolean(76)) {
                            ((DBSQLAttributesDS)request).setCommitmentControlLevelParserOption(0);
                        } else {
                            ((DBSQLAttributesDS)request).setCommitmentControlLevelParserOption(this.transactionManager_.getCommitMode());
                        }
                        dateFormat = this.properties_.getIndex(3);
                        if (dateFormat != -1) {
                            ((DBSQLAttributesDS)request).setDateFormatParserOption(dateFormat);
                        }
                        if ((dateSeparator = this.properties_.getIndex(4)) != -1) {
                            ((DBSQLAttributesDS)request).setDateSeparatorParserOption(dateSeparator);
                        }
                        if ((timeFormat = this.properties_.getIndex(24)) != -1) {
                            ((DBSQLAttributesDS)request).setTimeFormatParserOption(timeFormat);
                        }
                        if ((timeSeparator = this.properties_.getIndex(25)) != -1) {
                            ((DBSQLAttributesDS)request).setTimeSeparatorParserOption(timeSeparator);
                        }
                        if ((decimalSeparator = this.properties_.getIndex(5)) != -1) {
                            ((DBSQLAttributesDS)request).setDecimalSeparatorParserOption(decimalSeparator);
                        }
                        ((DBSQLAttributesDS)request).setNamingConventionParserOption(this.properties_.getIndex(9));
                        int decimalDataErrors = this.properties_.getIndex(86);
                        if (decimalDataErrors != -1) {
                            ((DBSQLAttributesDS)request).setIgnoreDecimalDataErrorParserOption(decimalDataErrors);
                        }
                        if (!this.properties_.getBoolean(36)) break block164;
                        if (this.vrm_ >= JDUtilities.vrm510) {
                            this.dataCompression_ = 14386;
                            ((DBSQLAttributesDS)request).setDataCompressionOption(0);
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "Data compression = RLE");
                            }
                            break block165;
                        } else {
                            this.dataCompression_ = 1;
                            ((DBSQLAttributesDS)request).setDataCompressionOption(1);
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "Data compression = old");
                            }
                        }
                        break block165;
                    }
                    this.dataCompression_ = 0;
                    ((DBSQLAttributesDS)request).setDataCompressionOption(0);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Data compression = none");
                    }
                }
                if (this.defaultSchema_ != null) {
                    ((DBSQLAttributesDS)request).setDefaultSQLLibraryName(this.defaultSchema_, libraryNameConverter);
                }
                ((DBSQLAttributesDS)request).setPackageAddStatementAllowed(this.properties_.getBoolean(11) ? 1 : 0);
                if (this.vrm_ >= JDUtilities.vrm440) {
                    if (this.vrm_ >= JDUtilities.vrm540) {
                        ((DBSQLAttributesDS)request).setUseExtendedFormatsIndicator(242);
                    } else {
                        ((DBSQLAttributesDS)request).setUseExtendedFormatsIndicator(241);
                    }
                    int lobThreshold = this.properties_.getInt(31);
                    if (lobThreshold <= 0) {
                        ((DBSQLAttributesDS)request).setLOBFieldThreshold(0);
                    } else if (lobThreshold >= 0xF00000) {
                        ((DBSQLAttributesDS)request).setLOBFieldThreshold(0xF00000);
                    } else {
                        ((DBSQLAttributesDS)request).setLOBFieldThreshold(lobThreshold);
                    }
                    this.extendedFormats_ = true;
                }
                if (this.vrm_ >= JDUtilities.vrm520) {
                    ((DBSQLAttributesDS)request).setAmbiguousSelectOption(1);
                    this.mustSpecifyForUpdate_ = false;
                    if (this.vrm_ > JDUtilities.vrm740) {
                        ((DBSQLAttributesDS)request).setClientSupportInformation(-167772160);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "ROWID supported = true");
                            JDTrace.logInformation(this, "True auto-commit supported = true");
                            JDTrace.logInformation(this, "128 byte column names supported = true");
                            JDTrace.logInformation(this, "128 length schema names supported = true");
                            JDTrace.logInformation(this, "client support 0x04000000 boolean");
                            JDTrace.logInformation(this, "client support 0x02000000 multiple SQLCAs");
                        }
                    } else if (this.vrm_ >= JDUtilities.vrm710) {
                        ((DBSQLAttributesDS)request).setClientSupportInformation(-234881024);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "ROWID supported = true");
                            JDTrace.logInformation(this, "True auto-commit supported = true");
                            JDTrace.logInformation(this, "128 byte column names supported = true");
                            JDTrace.logInformation(this, "128 length schema names supported = true");
                            JDTrace.logInformation(this, "client support 0x02000000 multiple SQLCAs");
                        }
                    } else if (this.vrm_ >= JDUtilities.vrm540) {
                        ((DBSQLAttributesDS)request).setClientSupportInformation(-536870912);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "ROWID supported = true");
                            JDTrace.logInformation(this, "True auto-commit supported = true");
                            JDTrace.logInformation(this, "128 byte column names supported = true");
                        }
                    } else if (this.vrm_ >= JDUtilities.vrm530) {
                        ((DBSQLAttributesDS)request).setClientSupportInformation(-1073741824);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "ROWID supported = true");
                            JDTrace.logInformation(this, "True auto-commit supported = true");
                        }
                    } else {
                        ((DBSQLAttributesDS)request).setClientSupportInformation(Integer.MIN_VALUE);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "ROWID supported = true");
                        }
                    }
                }
                if (this.vrm_ >= JDUtilities.vrm530) {
                    boolean holdLocators;
                    int parserOption;
                    int maximumPrecision = this.properties_.getInt(53);
                    int maximumScale = this.properties_.getInt(54);
                    int minimumDivideScale = this.properties_.getInt(52);
                    if (maximumScale > 31) {
                        maximumPrecision = 63;
                    }
                    ((DBSQLAttributesDS)request).setDecimalPrecisionIndicators(maximumPrecision, maximumScale, minimumDivideScale);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Maximum decimal precision = " + maximumPrecision);
                        JDTrace.logInformation(this, "Maximum decimal scale = " + maximumScale);
                        JDTrace.logInformation(this, "Minimum divide scale = " + minimumDivideScale);
                    }
                    if ((parserOption = this.properties_.getIndex(55)) != -1) {
                        ((DBSQLAttributesDS)request).setHexConstantParserOption(parserOption);
                        if (JDTrace.isTraceOn()) {
                            String msg = parserOption == 0 ? "Translate hex = character" : "Translate hex = binary";
                            JDTrace.logInformation(this, msg);
                        }
                    }
                    if (!(holdLocators = this.properties_.getBoolean(62))) {
                        ((DBSQLAttributesDS)request).setInputLocatorType(213);
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Hold Locators = " + holdLocators);
                        }
                    }
                    ((DBSQLAttributesDS)request).setLocatorPersistence(1);
                }
                if (this.vrm_ >= JDUtilities.vrm540) {
                    int queryOptimizeGoal = this.properties_.getInt(66);
                    if (queryOptimizeGoal != 0) {
                        if (queryOptimizeGoal == 1) {
                            ((DBSQLAttributesDS)request).setQueryOptimizeGoal(198);
                        } else if (queryOptimizeGoal == 2) {
                            ((DBSQLAttributesDS)request).setQueryOptimizeGoal(193);
                        }
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "query optimize goal = " + queryOptimizeGoal);
                    }
                }
                if ((enableClientAffinitiesList = this.properties_.getInt(93)) > 0 && ((alternateServers = this.properties_.getString(94)) == null || alternateServers.length() == 0)) {
                    ((DBSQLAttributesDS)request).setRequestAlternateServer(1);
                }
                if (this.vrm_ >= JDUtilities.vrm610) {
                    int queryStorageLimit = this.properties_.getInt(73);
                    if (queryStorageLimit != -1) {
                        if (queryStorageLimit < -1) {
                            ((DBSQLAttributesDS)request).setQueryStorageLimit(-1);
                        } else if (queryStorageLimit > 2147352578) {
                            ((DBSQLAttributesDS)request).setQueryStorageLimit(2147352578);
                        } else {
                            ((DBSQLAttributesDS)request).setQueryStorageLimit(queryStorageLimit);
                        }
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "query storage limit = " + queryStorageLimit);
                    }
                }
                if (JDTrace.isTraceOn()) {
                    if (this.extendedFormats_) {
                        JDTrace.logInformation(this, "Using extended datastreams");
                    } else {
                        JDTrace.logInformation(this, "Using original datastreams");
                    }
                }
                if (this.vrm_ >= JDUtilities.vrm520 && (RDBName = new StringBuffer(this.properties_.getString(47))).length() > 0) {
                    RDBName.append("                  ");
                    RDBName.setLength(18);
                    ((DBSQLAttributesDS)request).setRDBName(RDBName.toString().toUpperCase(), ccsid37Converter);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "RDB Name = -->" + RDBName + "<--");
                    }
                }
                if (!this.properties_.equals(20, "hex")) {
                    JDSortSequence sortSequence = new JDSortSequence(this.properties_.getString(20), this.properties_.getString(21), this.properties_.getString(22), this.properties_.getString(23));
                    ((DBSQLAttributesDS)request).setNLSSortSequence(sortSequence.getType(), sortSequence.getTableFile(), sortSequence.getTableLibrary(), sortSequence.getLanguageId(), ccsid37Converter);
                }
                if (this.vrm_ >= JDUtilities.vrm610) {
                    ((DBSQLAttributesDS)request).setInterfaceType("JDBC", ccsid37Converter);
                    ((DBSQLAttributesDS)request).setInterfaceName("IBM Toolbox for Java", ccsid37Converter);
                    ((DBSQLAttributesDS)request).setInterfaceLevel("07060003", ccsid37Converter);
                    int roundingMode = 0;
                    String roundingModeStr = this.properties_.getString(74);
                    if (roundingModeStr.equals("half even")) {
                        roundingMode = 0;
                    } else if (roundingModeStr.equals("up")) {
                        roundingMode = 6;
                    } else if (roundingModeStr.equals("down")) {
                        roundingMode = 2;
                    } else if (roundingModeStr.equals("ceiling")) {
                        roundingMode = 3;
                    } else if (roundingModeStr.equals("floor")) {
                        roundingMode = 4;
                    } else if (roundingModeStr.equals("half up")) {
                        roundingMode = 1;
                    } else if (roundingModeStr.equals("half down")) {
                        roundingMode = 5;
                    }
                    if (roundingMode != 0) {
                        ((DBSQLAttributesDS)request).setDecfloatRoundingMode((short)roundingMode);
                    }
                    ((DBSQLAttributesDS)request).setCloseEOF(232);
                }
                if (this.vrm_ >= JDUtilities.vrm710) {
                    int car = this.properties_.getInt(79);
                    if (!this.properties_.getString(79).equals("0")) {
                        ((DBSQLAttributesDS)request).setConcurrentAccessResolution(car);
                        this.concurrentAccessResolution_ = car;
                    }
                }
                reply = this.sendAndReceive(request);
                int errorClass = reply.getErrorClass();
                int returnCode = reply.getReturnCode();
                if (errorClass == 7 && (returnCode == 301 || returnCode == 303)) {
                    this.postWarning(this.id_, errorClass, returnCode);
                } else if (errorClass == 7 && returnCode == 304) {
                    this.postWarning(this.id_, errorClass, returnCode);
                } else if (errorClass == 7 && returnCode == -704) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JDError.throwSQLException((Object)this, "42705");
                } else if (errorClass != 0) {
                    JDError.throwSQLException(this, this, this.id_, errorClass, returnCode);
                }
                serverAttributes = reply.getServerAttributes();
            }
            finally {
                if (request != null) {
                    request.returnToPool();
                    request = null;
                }
            }
            String alternateServer = reply.getAlternateServer();
            this.alternateServer_ = alternateServer != null && alternateServer.length() > 0 ? alternateServer : null;
            int serverCCSID = serverAttributes.getServerCCSID();
            this.vrm_ = serverAttributes.getVRM();
            this.converter_ = ConvTable.getTable(serverCCSID, null);
            if (this.as400PublicClassObj_ != null && this.as400PublicClassObj_.skipSignonServer_) {
                this.as400PublicClassObj_.setSignonInfo(serverCCSID, this.vrm_, this.as400_.getUserId());
            }
            String serverFunctionalLevelAsString = serverAttributes.getServerFunctionalLevel(this.converter_);
            try {
                this.serverFunctionalLevel_ = Integer.parseInt(serverFunctionalLevelAsString.substring(6));
            }
            catch (NumberFormatException e) {
                this.serverFunctionalLevel_ = 0;
            }
            if (this.serverFunctionalLevel_ >= 5) {
                this.serverJobIdentifier_ = serverAttributes.getServerJobIdentifier(this.converter_);
            }
            if (this.vrm_ == JDUtilities.vrm510 && this.serverFunctionalLevel_ >= 10) {
                this.mustSpecifyForUpdate_ = false;
            }
            if (JDTrace.isTraceOn()) {
                int v = (this.vrm_ & 0xFFFF0000) >>> 16;
                int r = (this.vrm_ & 0xFF00) >>> 8;
                int m = this.vrm_ & 0xFF;
                JDTrace.logInformation(this, "JDBC driver major version = 14");
                if (v == 5 && r >= 3 || v > 5) {
                    JDTrace.logInformation(this, "IBM i VRM = V" + v + "R" + r + "M" + m);
                } else {
                    JDTrace.logInformation(this, "OS/400 VRM = V" + v + "R" + r + "M" + m);
                }
                JDTrace.logInformation(this, "Server CCSID = " + serverCCSID);
                JDTrace.logInformation(this, "Server functional level = " + serverFunctionalLevelAsString + " (" + this.serverFunctionalLevel_ + ")");
                StringBuffer buffer = new StringBuffer();
                if (this.serverJobIdentifier_ == null) {
                    buffer.append("Not available");
                } else {
                    buffer.append(this.serverJobIdentifier_.substring(20, 26).trim());
                    buffer.append('/');
                    buffer.append(this.serverJobIdentifier_.substring(10, 20).trim());
                    buffer.append('/');
                    buffer.append(this.serverJobIdentifier_.substring(0, 10).trim());
                }
                JDTrace.logInformation(this, "Server job identifier = " + buffer);
            }
            if ((rdbEntry = serverAttributes.getRelationalDBName(this.converter_).trim()).length() > 0 && !rdbEntry.equalsIgnoreCase("*N")) {
                this.catalog_ = rdbEntry;
            }
            if (decimalSeparator == -1) {
                switch (serverAttributes.getDecimalSeparatorPO()) {
                    case 0: {
                        this.properties_.setString(5, ".");
                        break;
                    }
                    case 1: {
                        this.properties_.setString(5, ",");
                        break;
                    }
                }
            }
            if (dateFormat == -1) {
                switch (serverAttributes.getDateFormatPO()) {
                    case 0: {
                        this.properties_.setString(3, "julian");
                        break;
                    }
                    case 1: {
                        this.properties_.setString(3, "mdy");
                        break;
                    }
                    case 2: {
                        this.properties_.setString(3, "dmy");
                        break;
                    }
                    case 3: {
                        this.properties_.setString(3, "ymd");
                        break;
                    }
                    case 4: {
                        this.properties_.setString(3, "usa");
                        break;
                    }
                    case 5: {
                        this.properties_.setString(3, "iso");
                        break;
                    }
                    case 6: {
                        this.properties_.setString(3, "eur");
                        break;
                    }
                    case 7: {
                        this.properties_.setString(3, "jis");
                        break;
                    }
                }
            }
            if (dateSeparator == -1) {
                switch (serverAttributes.getDateSeparatorPO()) {
                    case 0: {
                        this.properties_.setString(4, "/");
                        break;
                    }
                    case 1: {
                        this.properties_.setString(4, "-");
                        break;
                    }
                    case 2: {
                        this.properties_.setString(4, ".");
                        break;
                    }
                    case 3: {
                        this.properties_.setString(4, ",");
                        break;
                    }
                    case 4: {
                        this.properties_.setString(4, "b");
                        break;
                    }
                }
            }
            if (timeFormat == -1) {
                switch (serverAttributes.getTimeFormatPO()) {
                    case 0: {
                        this.properties_.setString(24, "hms");
                        break;
                    }
                    case 1: {
                        this.properties_.setString(24, "usa");
                        break;
                    }
                    case 2: {
                        this.properties_.setString(24, "iso");
                        break;
                    }
                    case 3: {
                        this.properties_.setString(24, "eur");
                        break;
                    }
                    case 4: {
                        this.properties_.setString(24, "jis");
                        break;
                    }
                }
            }
            if (timeSeparator != -1) return;
            switch (serverAttributes.getTimeSeparatorPO()) {
                case 0: {
                    this.properties_.setString(25, ":");
                    return;
                }
                case 1: {
                    this.properties_.setString(25, ".");
                    return;
                }
                case 2: {
                    this.properties_.setString(25, ",");
                    return;
                }
                case 3: {
                    this.properties_.setString(25, "b");
                    return;
                }
            }
            return;
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return;
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return;
        }
        finally {
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
        }
    }

    @Override
    public void setSystem(AS400 as400) throws SQLException {
        this.as400PublicClassObj_ = as400;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        this.transactionManager_.setIsolation(level);
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setTransactionIsolation", "Transaction isolation", this.transactionManager_.getIsolation());
        }
    }

    @Override
    public void setTypeMap(Map typeMap) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
    }

    @Override
    public String toString() {
        return this.catalog_;
    }

    @Override
    public boolean useExtendedFormats() throws SQLException {
        return this.extendedFormats_;
    }

    @Override
    public String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCConnection", "java.sql.Connection"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        DBBaseRequestDS request = null;
        DBReplyRequestedDS reply = null;
        int errorClass = 0;
        int returnCode = 0;
        ReentrantLock lock = new ReentrantLock();
        if (timeout < 0) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        try {
            class CommTimer
            implements Runnable {
                Thread otherThread;
                ReentrantLock lock;
                int timeout;

                @Override
                public void run() {
                    block2: {
                        try {
                            Thread.sleep(this.timeout * 1000);
                            this.lock.lockInterruptibly();
                            this.otherThread.interrupt();
                            this.lock.unlock();
                        }
                        catch (InterruptedException ie) {
                            if (!JDTrace.isTraceOn()) break block2;
                            JDTrace.logInformation(this, "Connection.isValid timer interrupted and stopped");
                        }
                    }
                }

                public CommTimer(Thread otherThread, int timeout, ReentrantLock lock) {
                    this.otherThread = otherThread;
                    this.timeout = timeout;
                    this.lock = lock;
                }
            }
            CommTimer timer = null;
            Thread t = null;
            if (timeout > 0) {
                timer = new CommTimer(Thread.currentThread(), timeout, lock);
                t = new Thread(timer);
                t.start();
            }
            try {
                request = DBDSPool.getDBSQLRequestDS(0, this.id_, Integer.MIN_VALUE, 0);
                reply = this.sendAndReceive(request);
                lock.lockInterruptibly();
                if (t != null) {
                    t.interrupt();
                }
                lock.unlock();
                errorClass = reply.getErrorClass();
                returnCode = reply.getReturnCode();
            }
            catch (Exception ex) {
                try {
                    lock.lockInterruptibly();
                    if (t != null) {
                        t.interrupt();
                    }
                    lock.unlock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Connection.isValid timed out or could not verify valid connection");
                }
                boolean bl = false;
                if (request != null) {
                    request.returnToPool();
                    request = null;
                }
                if (reply != null) {
                    reply.returnToPool();
                    reply = null;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Connection.isValid call complete");
                }
                return bl;
            }
            if (errorClass == 7 && returnCode == -201) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (request != null) {
                request.returnToPool();
                request = null;
            }
            if (reply != null) {
                reply.returnToPool();
                reply = null;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Connection.isValid call complete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        DBBaseRequestDS request = null;
        DBReplyRequestedDS setClientInfoReply = null;
        ConvTable tempConverter = null;
        String oldValue = null;
        if (value == null) {
            value = "";
        }
        try {
            int errorClass;
            if (this.getVRM() >= JDUtilities.vrm610) {
                request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                tempConverter = ConvTable.getTable(this.as400_.getCcsid(), null);
            }
            if (name.equals(applicationNamePropertyName_)) {
                oldValue = this.applicationName_;
                this.applicationName_ = value;
                if (request != null) {
                    ((DBSQLAttributesDS)request).setClientInfoApplicationName(value, tempConverter);
                }
            } else if (name.equals(clientUserPropertyName_)) {
                oldValue = this.clientUser_;
                this.clientUser_ = value;
                if (request != null) {
                    ((DBSQLAttributesDS)request).setClientInfoClientUser(value, tempConverter);
                }
            } else if (name.equals(clientAccountingPropertyName_)) {
                oldValue = this.clientAccounting_;
                this.clientAccounting_ = value;
                if (request != null) {
                    ((DBSQLAttributesDS)request).setClientInfoClientAccounting(value, tempConverter);
                }
            } else if (name.equals(clientHostnamePropertyName_)) {
                oldValue = this.clientHostname_;
                this.clientHostname_ = value;
                if (request != null) {
                    ((DBSQLAttributesDS)request).setClientInfoClientHostname(value, tempConverter);
                }
            } else if (name.equals(clientProgramIDPropertyName_)) {
                oldValue = this.clientProgramID_;
                this.clientProgramID_ = value;
                if (request != null) {
                    ((DBSQLAttributesDS)request).setClientInfoProgramID(value, tempConverter);
                }
            } else {
                oldValue = null;
                this.postWarningSQLState("42601");
            }
            if (this.getVRM() >= JDUtilities.vrm610 && oldValue != null && (errorClass = (setClientInfoReply = this.sendAndReceive(request)).getErrorClass()) != 0) {
                JDError.throwSQLException(this, this, this.id_, errorClass, setClientInfoReply.getReturnCode());
            }
        }
        catch (Exception e) {
            if (name.equals(applicationNamePropertyName_)) {
                this.applicationName_ = oldValue;
            } else if (name.equals(clientUserPropertyName_)) {
                this.clientUser_ = oldValue;
            } else if (name.equals(clientAccountingPropertyName_)) {
                this.clientAccounting_ = oldValue;
            } else if (name.equals(clientHostnamePropertyName_)) {
                this.clientHostname_ = oldValue;
            } else if (name.equals(clientProgramIDPropertyName_)) {
                this.clientProgramID_ = oldValue;
            }
            HashMap<String, ClientInfoStatus> m = new HashMap<String, ClientInfoStatus>();
            m.put(name, ClientInfoStatus.REASON_UNKNOWN);
            JDError.throwSQLClientInfoException(this, "HY000", e, m);
        }
        finally {
            if (request != null) {
                request.returnToPool();
                request = null;
            }
            if (setClientInfoReply != null) {
                setClientInfoReply.returnToPool();
                setClientInfoReply = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        String newApplicationName = properties.getProperty(applicationNamePropertyName_);
        String newClientHostname = properties.getProperty(clientHostnamePropertyName_);
        String newClientUser = properties.getProperty(clientUserPropertyName_);
        String newClientAccounting = properties.getProperty(clientAccountingPropertyName_);
        String newClientProgramID = properties.getProperty(clientProgramIDPropertyName_);
        if (newApplicationName == null) {
            newApplicationName = "";
        }
        if (newClientHostname == null) {
            newClientHostname = "";
        }
        if (newClientUser == null) {
            newClientUser = "";
        }
        if (newClientAccounting == null) {
            newClientAccounting = "";
        }
        if (newClientProgramID == null) {
            newClientProgramID = "";
        }
        DBBaseRequestDS request = null;
        DBReplyRequestedDS setClientInfoReply = null;
        ConvTable tempConverter = null;
        try {
            if (this.getVRM() >= JDUtilities.vrm610) {
                request = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                tempConverter = ConvTable.getTable(this.as400_.getCcsid(), null);
                ((DBSQLAttributesDS)request).setClientInfoApplicationName(newApplicationName, tempConverter);
                ((DBSQLAttributesDS)request).setClientInfoClientUser(newClientUser, tempConverter);
                ((DBSQLAttributesDS)request).setClientInfoClientAccounting(newClientAccounting, tempConverter);
                ((DBSQLAttributesDS)request).setClientInfoClientHostname(newClientHostname, tempConverter);
                ((DBSQLAttributesDS)request).setClientInfoProgramID(newClientProgramID, tempConverter);
                setClientInfoReply = this.sendAndReceive(request);
                int errorClass = setClientInfoReply.getErrorClass();
                if (errorClass != 0) {
                    JDError.throwSQLException(this, this, this.id_, errorClass, setClientInfoReply.getReturnCode());
                }
            }
            this.applicationName_ = newApplicationName;
            this.clientHostname_ = newClientHostname;
            this.clientUser_ = newClientUser;
            this.clientAccounting_ = newClientAccounting;
            this.clientProgramID_ = newClientProgramID;
        }
        catch (Exception e) {
            HashMap<String, ClientInfoStatus> m = new HashMap<String, ClientInfoStatus>();
            Enumeration<Object> clientInfoNames = properties.keys();
            while (clientInfoNames.hasMoreElements()) {
                String clientInfoName = (String)clientInfoNames.nextElement();
                m.put(clientInfoName, ClientInfoStatus.REASON_UNKNOWN);
            }
            JDError.throwSQLClientInfoException(this, "HY000", e, m);
        }
        finally {
            if (request != null) {
                request.returnToPool();
                request = null;
            }
            if (setClientInfoReply != null) {
                setClientInfoReply.returnToPool();
                setClientInfoReply = null;
            }
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (name.equals(applicationNamePropertyName_)) {
            return this.applicationName_;
        }
        if (name.equals(clientUserPropertyName_)) {
            return this.clientUser_;
        }
        if (name.equals(clientAccountingPropertyName_)) {
            return this.clientAccounting_;
        }
        if (name.equals(clientHostnamePropertyName_)) {
            return this.clientHostname_;
        }
        if (name.equals(clientProgramIDPropertyName_)) {
            return this.clientProgramID_;
        }
        this.postWarningSQLState("42601");
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties props = new Properties();
        props.setProperty(applicationNamePropertyName_, this.applicationName_);
        props.setProperty(clientAccountingPropertyName_, this.clientAccounting_);
        props.setProperty(clientHostnamePropertyName_, this.clientHostname_);
        props.setProperty(clientUserPropertyName_, this.clientUser_);
        props.setProperty(clientProgramIDPropertyName_, this.clientProgramID_);
        return props;
    }

    @Override
    public Clob createClob() throws SQLException {
        return new AS400JDBCClob("", Integer.MAX_VALUE);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new AS400JDBCBlob(new byte[0], Integer.MAX_VALUE);
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new AS400JDBCNClob("", Integer.MAX_VALUE);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new AS400JDBCSQLXML(0x7FFFFFFE);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new AS400JDBCArray(typeName, elements, this.vrm_, this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public void setDBHostServerTrace(boolean trace) {
        block13: {
            try {
                if (this.getVRM() >= JDUtilities.vrm530) {
                    boolean traceServerJob = (this.traceServer_ & 0x10) > 0;
                    boolean traceDatabaseHostServer = (this.traceServer_ & 0x40) > 0;
                    String serverJobIdentifier = this.getServerJobIdentifier();
                    boolean SQLNaming = this.properties_.getString(9).equals("sql");
                    if (!traceDatabaseHostServer) {
                        if (trace) {
                            try {
                                if (this.getVRM() == JDUtilities.vrm530) {
                                    JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) TRCTYPE((TESTA *INFO))", SQLNaming);
                                } else {
                                    JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) TRCTYPE((*DBHSVR *INFO))", SQLNaming);
                                }
                                this.databaseHostServerTrace_ = true;
                            }
                            catch (Exception e) {
                                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start database host server tracing failed, could not trace server job");
                            }
                        } else if (!traceServerJob) {
                            try {
                                JDUtilities.runCommand(this, "QSYS/ENDTRC SSNID(QJT" + serverJobIdentifier.substring(20) + ") DTAOPT(*LIB) DTALIB(QUSRSYS) RPLDTA(*YES) PRTTRC(*YES)", SQLNaming);
                                JDUtilities.runCommand(this, "QSYS/DLTTRC DTAMBR(QJT" + serverJobIdentifier.substring(20) + ") DTALIB(QUSRSYS)", SQLNaming);
                                this.databaseHostServerTrace_ = false;
                            }
                            catch (Exception e) {
                                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end database host server tracing failed.");
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                if (!JDTrace.isTraceOn()) break block13;
                JDTrace.logInformation(this, "Attempt to start/stop database host server tracing failed.");
            }
        }
    }

    @Override
    public boolean doUpdateDeleteBlocking() {
        return this.useBlockUpdate_;
    }

    @Override
    public int getMaximumBlockedInputRows() {
        return this.maximumBlockedInputRows_;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        SecurityManager security;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "abort() called");
        }
        if (executor == null) {
            JDError.throwSQLException("HY105");
        }
        if ((security = System.getSecurityManager()) != null) {
            SQLPermission sqlPermission = new SQLPermission("callAbort");
            security.checkPermission(sqlPermission);
        }
        if (this.aborted_ || this.server_ == null) {
            return;
        }
        this.aborted_ = true;
        AS400JDBCConnectionAbortRunnable runnable = new AS400JDBCConnectionAbortRunnable(this);
        executor.execute(runnable);
    }

    @Override
    public String getSchema() throws SQLException {
        Statement s = this.createStatement();
        boolean SQLNaming = this.properties_.getString(9).equals("sql");
        String query = SQLNaming ? "SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1" : "SELECT CURRENT SCHEMA FROM SYSIBM/SYSDUMMY1";
        ResultSet rs = s.executeQuery(query);
        rs.next();
        String schema = rs.getString(1);
        rs.close();
        s.close();
        return schema;
    }

    @Override
    public void setNetworkTimeout(int timeout) throws SQLException {
        String threadUsedProperty;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            SQLPermission sqlPermission = new SQLPermission("setNetworkTimeout");
            security.checkPermission(sqlPermission);
        }
        if ((threadUsedProperty = this.properties_.getString(38)) == null) {
            if (timeout > 0) {
                JDError.throwSQLException("IM001", "thread used != false");
            }
        } else if (threadUsedProperty.equalsIgnoreCase("true") && timeout > 0) {
            JDError.throwSQLException("IM001", "thread used != false");
        }
        if (timeout < 0) {
            JDError.throwSQLException("HY105");
        }
        this.checkOpen();
        try {
            this.server_.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            JDError.throwSQLException("08S01", e);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this.server_.getSoTimeout();
        }
        catch (SocketException e) {
            JDError.throwSQLException("08S01", e);
            return 0;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        String threadUsedProperty;
        SecurityManager security;
        if (milliseconds < 0) {
            JDError.throwSQLException("HY105", "milliseconds<0");
        }
        if (executor == null) {
            JDError.throwSQLException("HY105", "executor=null");
        }
        if ((security = System.getSecurityManager()) != null) {
            SQLPermission sqlPermission = new SQLPermission("setNetworkTimeout");
            security.checkPermission(sqlPermission);
        }
        if ((threadUsedProperty = this.properties_.getString(38)) == null) {
            if (milliseconds > 0) {
                JDError.throwSQLException("IM001", "thread used != false");
            }
        } else if (threadUsedProperty.equalsIgnoreCase("true") && milliseconds > 0) {
            JDError.throwSQLException("IM001", "thread used != false");
        }
        this.checkOpen();
        try {
            this.server_.setSoTimeout(milliseconds);
        }
        catch (SocketException socketException) {
            JDError.throwSQLException("08S01", socketException);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        PreparedStatement ps;
        this.checkOpen();
        if (schema.length() <= 0 || schema.charAt(0) != '\"') {
            schema = schema.toUpperCase().trim();
        }
        boolean SQLNaming = this.properties_.getString(9).equals("sql");
        if ("DEFAULT".equals(schema) || !SQLNaming && "*LIBL".equals(schema)) {
            ps = this.prepareStatement("SET CURRENT SCHEMA DEFAULT ");
        } else {
            ps = this.prepareStatement("SET CURRENT SCHEMA ? ");
            ps.setString(1, schema);
        }
        ps.executeUpdate();
        ps.close();
    }

    @Override
    public boolean isQueryTimeoutMechanismCancel() {
        return this.queryTimeoutMechanism_ == 1;
    }

    @Override
    public void setupVariableFieldCompression() {
        if (!this.variableFieldCompressionPropertyEvaluated_) {
            boolean variableFieldInsertCompressionAvailable = false;
            if (this.serverFunctionalLevel_ >= 16) {
                variableFieldInsertCompressionAvailable = true;
            }
            if (this.serverFunctionalLevel_ >= 14) {
                String property = null;
                try {
                    property = this.getProperties().getString(65);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (property == null) {
                    property = "default";
                }
                if ("false".equals(property = property.toLowerCase().trim())) {
                    this.useVariableFieldCompression_ = false;
                    this.useVariableFieldInsertCompression_ = false;
                    this.variableFieldCompressionPropertyEvaluated_ = true;
                } else if ("true".equals(property)) {
                    this.useVariableFieldCompression_ = true;
                    this.useVariableFieldInsertCompression_ = false;
                    this.variableFieldCompressionPropertyEvaluated_ = true;
                } else if ("insert".equals(property)) {
                    this.useVariableFieldCompression_ = false;
                    this.useVariableFieldInsertCompression_ = variableFieldInsertCompressionAvailable;
                    this.variableFieldCompressionPropertyEvaluated_ = true;
                } else {
                    this.useVariableFieldCompression_ = true;
                    this.useVariableFieldInsertCompression_ = variableFieldInsertCompressionAvailable;
                    this.variableFieldCompressionPropertyEvaluated_ = true;
                }
            } else {
                this.useVariableFieldCompression_ = false;
                this.useVariableFieldInsertCompression_ = false;
                this.variableFieldCompressionPropertyEvaluated_ = true;
            }
        }
    }

    @Override
    public boolean useVariableFieldCompression() {
        if (!this.variableFieldCompressionPropertyEvaluated_) {
            this.setupVariableFieldCompression();
        }
        return this.useVariableFieldCompression_;
    }

    @Override
    public boolean useVariableFieldInsertCompression() {
        if (!this.variableFieldCompressionPropertyEvaluated_) {
            this.setupVariableFieldCompression();
        }
        return this.useVariableFieldInsertCompression_;
    }

    @Override
    public void setDisableCompression(boolean disableCompression_) {
        this.disableCompression_ = disableCompression_;
    }

    @Override
    public void dumpStatementCreationLocation() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Dumping creation information for statements");
            Vector statements = (Vector)this.statements_.clone();
            Enumeration list = statements.elements();
            while (list.hasMoreElements()) {
                AS400JDBCStatement statement = (AS400JDBCStatement)list.nextElement();
                if (statement.creationLocation_ == null) {
                    JDTrace.logInformation(statement, "No creation information");
                    continue;
                }
                JDTrace.logException(statement, "Creation information", statement.creationLocation_);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean testDataTruncation(AS400JDBCStatement statementWarningObject, AS400JDBCResultSet resultSetWarningObject, int parameterIndex, boolean isParameter, SQLData data, JDSQLStatement sqlStatement) throws SQLException {
        boolean checkRawBytes = false;
        if (data != null && data.getOutOfBounds()) {
            data.clearOutOfBounds();
            switch (this.numericRangeError_) {
                case 0: {
                    JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    break;
                }
                case 1: {
                    if (statementWarningObject != null) {
                        statementWarningObject.postWarningSQLState("07006");
                        break;
                    }
                    if (resultSetWarningObject == null) break;
                    resultSetWarningObject.postWarningSQLState("07006");
                    break;
                }
            }
        }
        if (data != null && this.characterTruncation_ != 2 && data.isText()) {
            int truncated = data.getTruncated();
            if (truncated <= 0) return checkRawBytes;
            data.clearTruncated();
            int actualSize = data.getActualSize();
            if (this.getVRM() >= JDUtilities.vrm610 && !data.isText()) {
                if (this.characterTruncation_ != 1) throw new DataTruncation(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
                if (statementWarningObject != null) {
                    statementWarningObject.postDataTruncationWarning(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
                    return checkRawBytes;
                } else {
                    if (resultSetWarningObject == null) return checkRawBytes;
                    resultSetWarningObject.postDataTruncationWarning(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
                }
                return checkRawBytes;
            } else if (sqlStatement != null && sqlStatement.isSelect() && !sqlStatement.isSelectFromInsert()) {
                if (statementWarningObject != null) {
                    statementWarningObject.postDataTruncationWarning(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
                } else if (resultSetWarningObject != null) {
                    resultSetWarningObject.postDataTruncationWarning(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
                }
                if (this.queryReplaceTruncatedParameter_ == null) return checkRawBytes;
                data.set(this.queryReplaceTruncatedParameter_, null, 0);
                return checkRawBytes;
            } else {
                if (this.characterTruncation_ != 1) throw new DataTruncation(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
                if (statementWarningObject != null) {
                    statementWarningObject.postDataTruncationWarning(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
                    return true;
                }
                if (resultSetWarningObject == null) return checkRawBytes;
                resultSetWarningObject.postDataTruncationWarning(parameterIndex, isParameter, false, actualSize + truncated, actualSize);
            }
            return checkRawBytes;
        } else {
            if (data == null) return checkRawBytes;
            if (this.characterTruncation_ != 2) return checkRawBytes;
            if (!data.isText()) return checkRawBytes;
            int truncated = data.getTruncated();
            if (truncated <= 0) return checkRawBytes;
            data.clearTruncated();
            return true;
        }
    }

    @Override
    public ConvTable getConverter() {
        return this.converter_;
    }

    @Override
    public void setLastServerSQLState(String lastSqlState) {
        this.lastServerSQLState_ = lastSqlState;
    }

    @Override
    public String getLastServerSQLState() {
        return this.lastServerSQLState_;
    }

    @Override
    public ConvTable getPackageCCSID_Converter() {
        return this.packageCCSID_Converter;
    }

    void transferObjects(AS400JDBCConnectionImpl newConnection) {
        System.arraycopy(this.assigned_, 0, newConnection.assigned_, 0, 9999);
        newConnection.statements_ = this.statements_;
        this.statements_ = new Vector();
    }

    void closeAllResultSets() {
        if (this.statements_ != null) {
            Enumeration statementsEnum = this.statements_.elements();
            while (statementsEnum.hasMoreElements()) {
                AS400JDBCStatement statement = (AS400JDBCStatement)statementsEnum.nextElement();
                try {
                    statement.closeResultSet(240);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void resetStatements(JDTransactionManager tm) {
        if (this.statements_ != null) {
            Enumeration statementsEnum = this.statements_.elements();
            while (statementsEnum.hasMoreElements()) {
                AS400JDBCStatement statement = (AS400JDBCStatement)statementsEnum.nextElement();
                statement.setConnectionReset(true);
                statement.transactionManager_ = tm;
            }
        }
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly_;
    }

    @Override
    public boolean getCheckStatementHoldability() {
        return this.checkStatementHoldability_;
    }

    @Override
    int getNewAutoCommitSupport() {
        return this.newAutoCommitSupport_;
    }

    @Override
    boolean canSeamlessFailover() {
        if (this.transactionManager_ != null) {
            if (this.transactionManager_.isLocalActive()) {
                return false;
            }
            if (this.transactionManager_.isGlobalActive()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getReconnectURLs() {
        if (this.emptyStringArray == null) {
            this.emptyStringArray = new String[0];
        }
        return this.emptyStringArray;
    }

    public String getAlternateServer() {
        return this.alternateServer_;
    }

    public String getHostName() {
        return this.systemName_;
    }

    public String getPort() {
        return this.portNumberString;
    }

    static {
        AS400Server.addReplyStream((DataStream)DBDSPool.getDBReplyRequestedDS(), 4);
    }

    private class CancelLock {
        private CancelLock() {
        }
    }
}

