/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio;

import io.minio.MinioClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.StorageUnitConverter;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.vfs.minio.MinioFileObject;

public class MinioFileSystem
extends AbstractFileSystem {
    private static final Class<?> PKG = MinioFileSystem.class;
    private static final ILogChannel consoleLog = new LogChannel((Object)BaseMessages.getString(PKG, (String)"TITLE.Minio", (String[])new String[0]));
    private String endPointHostname;
    private int endPointPort;
    private boolean endPointSecure;
    private String accessKey;
    private String secretKey;
    private String region;
    protected long partSize;
    private MinioClient client;
    public static final List<Capability> CAPABILITIES = Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.RANDOM_ACCESS_READ);
    public StorageUnitConverter storageUnitConverter;
    private static final String MIN_PART_SIZE = "5MB";
    private static final String MAX_PART_SIZE = "5GB";

    protected MinioFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(CAPABILITIES);
    }

    public MinioClient getClient() {
        if (this.client == null) {
            this.client = MinioClient.builder().credentials(this.accessKey, this.secretKey).endpoint(this.endPointHostname, this.endPointPort, this.endPointSecure).region(this.region).build();
        }
        return this.client;
    }

    public FileObject createFile(AbstractFileName name) throws Exception {
        return new MinioFileObject(name, this);
    }

    public long parsePartSize(String partSizeString) {
        long parsePartSize = this.convertToLong(partSizeString);
        if (parsePartSize < this.convertToLong(MIN_PART_SIZE)) {
            consoleLog.logBasic(BaseMessages.getString(PKG, (String)"WARN.S3MultiPart.DefaultPartSize", (String[])new String[]{partSizeString, MIN_PART_SIZE}));
            parsePartSize = this.convertToLong(MIN_PART_SIZE);
        }
        if (parsePartSize > this.convertToLong(MAX_PART_SIZE)) {
            consoleLog.logBasic(BaseMessages.getString(PKG, (String)"WARN.S3MultiPart.MaximumPartSize", (String[])new String[]{partSizeString, MAX_PART_SIZE}));
        }
        return parsePartSize;
    }

    public long convertToLong(String partSize) {
        return this.storageUnitConverter.displaySizeToByteCount(partSize);
    }

    @Generated
    public String getEndPointHostname() {
        return this.endPointHostname;
    }

    @Generated
    public int getEndPointPort() {
        return this.endPointPort;
    }

    @Generated
    public boolean isEndPointSecure() {
        return this.endPointSecure;
    }

    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public long getPartSize() {
        return this.partSize;
    }

    @Generated
    public StorageUnitConverter getStorageUnitConverter() {
        return this.storageUnitConverter;
    }

    @Generated
    public void setEndPointHostname(String endPointHostname) {
        this.endPointHostname = endPointHostname;
    }

    @Generated
    public void setEndPointPort(int endPointPort) {
        this.endPointPort = endPointPort;
    }

    @Generated
    public void setEndPointSecure(boolean endPointSecure) {
        this.endPointSecure = endPointSecure;
    }

    @Generated
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    @Generated
    public void setClient(MinioClient client) {
        this.client = client;
    }

    @Generated
    public void setStorageUnitConverter(StorageUnitConverter storageUnitConverter) {
        this.storageUnitConverter = storageUnitConverter;
    }
}

