/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import org.apache.hop.core.gui.Point;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public String toString() {
        return "Rectangle(" + this.x + "," + this.y + "-" + this.width + "x" + this.height + ")";
    }

    public boolean contains(int x2, int y2) {
        return x2 >= this.x && x2 <= this.x + this.width && y2 >= this.y && y2 <= this.y + this.height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public int getCentreX() {
        return this.x + this.width / 2;
    }

    public int getCentreY() {
        return this.y + this.height / 2;
    }

    public double distance(Rectangle r) {
        double deltaX = this.getCentreX() - r.getCentreX();
        double deltaY = this.getCentreY() - r.getCentreY();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public boolean isEmpty() {
        return this.width == 0 && this.height == 0;
    }
}

