/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.git.config.GitConfig;

public class GitConfigSingleton {
    private static GitConfigSingleton configSingleton;
    private GitConfig gitConfig;

    private GitConfigSingleton() {
        Object configObject = HopConfig.getInstance().getConfigMap().get("gitConfig");
        if (configObject == null) {
            this.gitConfig = new GitConfig();
        } else {
            try {
                ObjectMapper mapper = HopJson.newMapper();
                this.gitConfig = (GitConfig)mapper.readValue(new Gson().toJson(configObject), GitConfig.class);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading git configuration, check property 'gitConfig' in the Hop config json file", (Throwable)e);
                this.gitConfig = new GitConfig();
            }
        }
        HopConfig.getInstance().getConfigMap().put("gitConfig", this.gitConfig);
    }

    public static GitConfigSingleton getInstance() {
        return configSingleton;
    }

    public static GitConfig getConfig() {
        if (configSingleton == null) {
            configSingleton = new GitConfigSingleton();
        }
        return GitConfigSingleton.configSingleton.gitConfig;
    }

    public static void saveConfig() throws HopException {
        HopConfig.getInstance().saveOption("gitConfig", (Object)GitConfigSingleton.configSingleton.gitConfig);
        HopConfig.getInstance().saveToFile();
    }
}

