/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.FieldMaskUtil;
import com.google.protobuf.util.Timestamps;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class UpdateBackupRequest {
    private final UpdateBackupRequest.Builder requestBuilder = com.google.bigtable.admin.v2.UpdateBackupRequest.newBuilder();
    private final String backupId;
    private final String clusterId;

    public static UpdateBackupRequest of(String clusterId, String backupId) {
        UpdateBackupRequest request = new UpdateBackupRequest(clusterId, backupId);
        return request;
    }

    private UpdateBackupRequest(String clusterId, String backupId) {
        Preconditions.checkNotNull((Object)clusterId);
        Preconditions.checkNotNull((Object)backupId);
        this.backupId = backupId;
        this.clusterId = clusterId;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(Backup.class, (int[])new int[]{fieldNumber});
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union((FieldMask)this.requestBuilder.getUpdateMask(), (FieldMask)newMask, (FieldMask[])new FieldMask[0]));
    }

    public UpdateBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull((Object)expireTime);
        this.requestBuilder.getBackupBuilder().setExpireTime(Timestamps.fromMillis((long)expireTime.toEpochMilli()));
        this.updateFieldMask(3);
        return this;
    }

    public UpdateBackupRequest setHotToStandardTime(Instant hotToStandardTime) {
        Preconditions.checkNotNull((Object)hotToStandardTime);
        this.requestBuilder.getBackupBuilder().setHotToStandardTime(Timestamps.fromMillis((long)hotToStandardTime.toEpochMilli()));
        this.updateFieldMask(12);
        return this;
    }

    public UpdateBackupRequest clearHotToStandardTime() {
        this.requestBuilder.getBackupBuilder().clearHotToStandardTime();
        this.updateFieldMask(12);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateBackupRequest that = (UpdateBackupRequest)o;
        return Objects.equal((Object)this.requestBuilder.getBackupBuilder().getExpireTime(), (Object)that.requestBuilder.getBackupBuilder().getExpireTime()) && Objects.equal((Object)this.requestBuilder.getBackupBuilder().getHotToStandardTime(), (Object)that.requestBuilder.getBackupBuilder().getHotToStandardTime()) && Objects.equal((Object)this.requestBuilder.getUpdateMask(), (Object)that.requestBuilder.getUpdateMask()) && Objects.equal((Object)this.clusterId, (Object)that.clusterId) && Objects.equal((Object)this.backupId, (Object)that.backupId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.getBackupBuilder().getExpireTime(), this.requestBuilder.getBackupBuilder().getHotToStandardTime(), this.requestBuilder.getUpdateMask(), this.backupId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        this.requestBuilder.getBackupBuilder().setName(NameUtil.formatBackupName(projectId, instanceId, this.clusterId, this.backupId));
        return this.requestBuilder.build();
    }
}

