/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform.copy;

import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.copy.CopyContext;
import org.apache.hop.pipeline.transform.copy.ITransformMetaCopyFactory;

public class DefaultTransformMetaCopyFactory
implements ITransformMetaCopyFactory {
    private static final ILogChannel log = new LogChannel((Object)"DefaultTransformMetaCopyFactory");
    private static final DefaultTransformMetaCopyFactory INSTANCE = new DefaultTransformMetaCopyFactory();

    public static DefaultTransformMetaCopyFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public TransformMeta copy(TransformMeta source) {
        return this.copy(source, CopyContext.DEFAULT);
    }

    @Override
    public TransformMeta copy(TransformMeta source, CopyContext context) {
        if (source == null) {
            return null;
        }
        if (log.isDebug()) {
            log.logDebug("Copying TransformMeta: " + source.getName() + " with context: " + String.valueOf(context));
        }
        TransformMeta copy = new TransformMeta();
        copy.setTransformPluginId(source.getTransformPluginId());
        copy.setName(source.getName());
        copy.setSelected(source.isSelected());
        copy.setDistributes(source.isDistributes());
        copy.setRowDistribution(source.getRowDistribution());
        copy.setCopiesString(source.getCopiesString());
        copy.setDescription(source.getDescription());
        copy.setTerminator(source.hasTerminator());
        if (source.getLocation() != null) {
            copy.setLocation(new Point(source.getLocation().x, source.getLocation().y));
        }
        if (source.getTransform() != null) {
            ITransformMeta innerCopy = this.copy(source.getTransform(), context);
            copy.setTransform(innerCopy);
        }
        if (context.isCopyPartitioning()) {
            if (source.getTransformPartitioningMeta() != null) {
                copy.setTransformPartitioningMeta(source.getTransformPartitioningMeta().clone());
            }
            if (source.getTargetTransformPartitioningMeta() != null) {
                copy.setTargetTransformPartitioningMeta(source.getTargetTransformPartitioningMeta().clone());
            }
        }
        if (context.isCopyErrorHandling() && source.getTransformErrorMeta() != null) {
            copy.setTransformErrorMeta(source.getTransformErrorMeta().clone());
        }
        if (context.isCopyAttributes()) {
            copy.setAttributesMap(this.copyAttributesMap(source.getAttributesMap()));
        }
        if (context.isPreserveParentReferences()) {
            copy.setParentPipelineMeta(source.getParentPipelineMeta());
        }
        if (context.isPreserveChangedState()) {
            boolean hasChanges;
            boolean bl = hasChanges = source.hasChanged() || source.getTransform() != null && source.getTransform().hasChanged();
            if (hasChanges) {
                if (log.isDebug()) {
                    log.logDebug("Preserving changed state for TransformMeta: " + source.getName());
                }
                copy.setChanged();
                if (copy.getTransform() != null) {
                    copy.getTransform().setChanged();
                }
            }
        } else {
            if (log.isDebug()) {
                log.logDebug("Clearing changed state for TransformMeta: " + source.getName());
            }
            copy.setChanged(false);
            if (copy.getTransform() != null && copy.getTransform() instanceof BaseTransformMeta) {
                ((BaseTransformMeta)copy.getTransform()).setChanged(false);
            }
        }
        return copy;
    }

    @Override
    public ITransformMeta copy(ITransformMeta source) {
        return this.copy(source, CopyContext.DEFAULT);
    }

    @Override
    public ITransformMeta copy(ITransformMeta source, CopyContext context) {
        if (source == null) {
            return null;
        }
        if (log.isDebug()) {
            log.logDebug("Copying ITransformMeta: " + source.getClass().getSimpleName() + " with context: " + String.valueOf(context));
        }
        try {
            boolean hadChanges = context.isPreserveChangedState() && source.hasChanged();
            ITransformMeta copy = (ITransformMeta)source.clone();
            if (hadChanges) {
                if (log.isDebug()) {
                    log.logDebug("Restoring changed state for ITransformMeta: " + source.getClass().getSimpleName());
                }
                copy.setChanged();
            }
            return copy;
        }
        catch (Exception e) {
            log.logError("Error copying ITransformMeta: " + source.getClass().getSimpleName(), (Throwable)e);
            throw new RuntimeException("Failed to copy transform metadata", e);
        }
    }

    private Map<String, Map<String, String>> copyAttributesMap(Map<String, Map<String, String>> source) {
        if (source == null) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> copy = new HashMap<String, Map<String, String>>(source.size());
        for (Map.Entry<String, Map<String, String>> entry : source.entrySet()) {
            Map<String, String> value = entry.getValue();
            HashMap<String, String> valueCopy = value == null ? null : new HashMap<String, String>(value);
            copy.put(entry.getKey(), valueCopy);
        }
        return copy;
    }
}

