/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model.arrows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ArrowsAppImporter {
    public static GraphModel importFromArrowsJson(String jsonString) throws HopException {
        try {
            GraphModel graphModel = new GraphModel();
            JSONParser parser = new JSONParser();
            JSONObject jModel = (JSONObject)parser.parse(jsonString);
            HashMap<String, GraphNode> nodesMap = new HashMap<String, GraphNode>();
            JSONArray jNodes = (JSONArray)jModel.get((Object)"nodes");
            for (Object node : jNodes) {
                JSONObject jNode = (JSONObject)node;
                GraphNode graphNode = new GraphNode();
                String name = (String)jNode.get((Object)"caption");
                graphNode.setName(name);
                JSONArray jLabels = (JSONArray)jNode.get((Object)"labels");
                for (Object jLabel : jLabels) {
                    String label = (String)jLabel;
                    graphNode.getLabels().add(label);
                }
                graphNode.getProperties().addAll(ArrowsAppImporter.importProperties(jNode, "properties"));
                graphModel.getNodes().add(graphNode);
                String key = (String)jNode.get((Object)"id");
                nodesMap.put(key, graphNode);
            }
            JSONArray jRelationships = (JSONArray)jModel.get((Object)"relationships");
            for (Object relationship : jRelationships) {
                String toKey;
                GraphNode toNode;
                JSONObject jRelationship = (JSONObject)relationship;
                GraphRelationship graphRelationship = new GraphRelationship();
                String label = (String)jRelationship.get((Object)"type");
                graphRelationship.setLabel(label);
                if (StringUtils.isNotEmpty((String)label)) {
                    graphRelationship.setName(label);
                } else {
                    String id = (String)jRelationship.get((Object)"id");
                    graphRelationship.setName(id);
                }
                String fromKey = (String)jRelationship.get((Object)"fromId");
                GraphNode fromNode = (GraphNode)nodesMap.get(fromKey);
                if (fromNode != null) {
                    graphRelationship.setNodeSource(fromNode.getName());
                }
                if ((toNode = (GraphNode)nodesMap.get(toKey = (String)jRelationship.get((Object)"toId"))) != null) {
                    graphRelationship.setNodeTarget(toNode.getName());
                }
                graphRelationship.getProperties().addAll(ArrowsAppImporter.importProperties(jRelationship, "properties"));
                graphModel.getRelationships().add(graphRelationship);
            }
            return graphModel;
        }
        catch (Exception e) {
            throw new HopException("Error parsing Cypher Workbench model", (Throwable)e);
        }
    }

    private static List<GraphProperty> importProperties(JSONObject j, String propertiesKey) {
        ArrayList<GraphProperty> properties = new ArrayList<GraphProperty>();
        JSONObject jNodeProperties = (JSONObject)j.get((Object)propertiesKey);
        if (jNodeProperties != null) {
            for (Object jPropertyKey : jNodeProperties.keySet()) {
                String propertyName = (String)jPropertyKey;
                String propertyTypeString = (String)jNodeProperties.get(jPropertyKey);
                GraphPropertyType propertyType = GraphPropertyType.parseCode(propertyTypeString);
                GraphProperty nodeProperty = new GraphProperty(propertyName, propertyName, propertyType, false, false, false, false);
                properties.add(nodeProperty);
            }
        }
        return properties;
    }
}

