/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.BaseStatement;
import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.RedshiftLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class MetadataAPIHelper {
    protected final RedshiftConnectionImpl connection;
    protected final Field[] GET_CATALOGS_COLS;
    protected final Field[] GET_SCHEMAS_COLS;
    protected final Field[] GET_TABLES_COLS;
    protected final Field[] GET_COLUMNS_COLS;
    public static final String SHOW_DATABASES_DATABASE_NAME = "database_name";
    public static final String SHOW_SCHEMAS_DATABASE_NAME = "database_name";
    public static final String SHOW_SCHEMAS_SCHEMA_NAME = "schema_name";
    public static final String SHOW_TABLES_DATABASE_NAME = "database_name";
    public static final String SHOW_TABLES_SCHEMA_NAME = "schema_name";
    public static final String SHOW_TABLES_TABLE_NAME = "table_name";
    public static final String SHOW_TABLES_TABLE_TYPE = "table_type";
    public static final String SHOW_TABLES_REMARKS = "remarks";
    public static final String SHOW_COLUMNS_DATABASE_NAME = "database_name";
    public static final String SHOW_COLUMNS_SCHEMA_NAME = "schema_name";
    public static final String SHOW_COLUMNS_TABLE_NAME = "table_name";
    public static final String SHOW_COLUMNS_COLUMN_NAME = "column_name";
    public static final String SHOW_COLUMNS_ORDINAL_POSITION = "ordinal_position";
    public static final String SHOW_COLUMNS_COLUMN_DEFAULT = "column_default";
    public static final String SHOW_COLUMNS_IS_NULLABLE = "is_nullable";
    public static final String SHOW_COLUMNS_DATA_TYPE = "data_type";
    public static final String SHOW_COLUMNS_CHARACTER_MAXIMUM_LENGTH = "character_maximum_length";
    public static final String SHOW_COLUMNS_NUMERIC_PRECISION = "numeric_precision";
    public static final String SHOW_COLUMNS_NUMERIC_SCALE = "numeric_scale";
    public static final String SHOW_COLUMNS_REMARKS = "remarks";
    protected final String SQL_SHOWDATABASES = "SHOW DATABASES;";
    protected final String SQL_SHOWDATABASESLIKE = "SHOW DATABASES LIKE {0};";
    protected final String SQL_SHOWSCHEMAS = "SHOW SCHEMAS FROM DATABASE {0};";
    protected final String SQL_SHOWSCHEMASLIKE = "SHOW SCHEMAS FROM DATABASE {0} LIKE {1};";
    protected final String SQL_SHOWTABLES = "SHOW TABLES FROM SCHEMA {0}.{1};";
    protected final String SQL_SHOWTABLESLIKE = "SHOW TABLES FROM SCHEMA {0}.{1} LIKE {2};";
    protected final String SQL_SHOWCOLUMNS = "SHOW COLUMNS FROM TABLE {0}.{1}.{2};";
    protected final String SQL_SHOWCOLUMNSLIKE = "SHOW COLUMNS FROM TABLE {0}.{1}.{2} LIKE {3};";
    protected final String SQL_PREP_SHOWDATABASES = "SHOW DATABASES;";
    protected final String SQL_PREP_SHOWDATABASESLIKE = "SHOW DATABASES LIKE '$1';";
    protected final String SQL_PREP_SHOWSCHEMAS = "SHOW SCHEMAS FROM DATABASE $1;";
    protected final String SQL_PREP_SHOWSCHEMASLIKE = "SHOW SCHEMAS FROM DATABASE $1 LIKE '$2';";
    protected final String SQL_PREP_SHOWTABLES = "SHOW TABLES FROM SCHEMA $1.$2 LIKE '$3';";
    protected final String SQL_PREP_SHOWCOLUMNS = "SHOW COLUMNS FROM TABLE $1.$2.$3 LIKE '$4';";
    protected final String prepare_QUOTE_IDENT = "select pg_catalog.QUOTE_IDENT($1);";
    protected final int QUOTE_IDENT_parameter_index = 1;
    protected final int QUOTE_IDENT_result_col_index = 1;
    protected final String prepare_QUOTE_LITERAL = "select pg_catalog.QUOTE_LITERAL($1);";
    protected final int QUOTE_LITERAL_parameter_index = 1;
    protected final int QUOTE_LITERAL_result_col_index = 1;
    private static final Map<String, String> rsTypeMap = new HashMap<String, String>();
    private static final Map<String, Integer> rsColumnSizeMap;

    public MetadataAPIHelper(RedshiftConnectionImpl connection) {
        this.connection = connection;
        this.GET_CATALOGS_COLS = this.getCatalogsField();
        this.GET_SCHEMAS_COLS = this.getSchemasField();
        this.GET_TABLES_COLS = this.getTablesField();
        this.GET_COLUMNS_COLS = this.getColumnsField();
    }

    public static <T extends Enum<T>> Field[] getField(Supplier<T[]> enumObject) {
        Enum[] enumValue = (Enum[])enumObject.get();
        Field[] columns = new Field[enumValue.length];
        for (Enum metadata : enumValue) {
            columns[((enumFunc)((Object)metadata)).getIndex()] = new Field(((enumFunc)((Object)metadata)).getName(), ((enumFunc)((Object)metadata)).getOidType());
        }
        return columns;
    }

    private Field[] getCatalogsField() {
        return MetadataAPIHelper.getField(GetCatalogs_Metadata::values);
    }

    private Field[] getSchemasField() {
        return MetadataAPIHelper.getField(GetSchemas_Metadata::values);
    }

    private Field[] getTablesField() {
        return MetadataAPIHelper.getField(GetTables_Metadata::values);
    }

    private Field[] getColumnsField() {
        return MetadataAPIHelper.getField(GetColumns_Metadata::values);
    }

    protected Statement createMetaDataStatement() throws SQLException {
        return this.connection.createStatement(1004, 1007);
    }

    protected PreparedStatement createMetaDataPreparedStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    protected ResultSet createEmptyRs(Field[] col, int size) throws SQLException {
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(col, this.getEmptyTupleList(col, size));
    }

    protected ResultSet createNullRs(Field[] col, int size) throws SQLException {
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(col, this.getNullTupleList(size));
    }

    protected ResultSet createRs(Field[] col, List<Tuple> data) throws SQLException {
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(col, data);
    }

    protected ResultSet runQuery(String sql) throws SQLException {
        return this.createMetaDataStatement().executeQuery(sql);
    }

    protected byte[][] getEmptyTuple(Field[] col, int size) throws SQLException {
        byte[][] tuple = new byte[size][];
        byte[] temStr = this.encodeStr("");
        byte[] temNum = this.encodeStr("0");
        for (int i = 0; i < size; ++i) {
            tuple[i] = col[i].getOID() == 1043 ? temStr : temNum;
        }
        return tuple;
    }

    protected List<Tuple> getEmptyTupleList(Field[] col, int size) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Create empty tuple list", new Object[0]);
        }
        ArrayList<Tuple> emptyTuple = new ArrayList<Tuple>();
        emptyTuple.add(new Tuple(this.getEmptyTuple(col, size)));
        return emptyTuple;
    }

    protected byte[][] getNullTuple(int size) throws SQLException {
        return new byte[size][];
    }

    protected List<Tuple> getNullTupleList(int size) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Create null tuple list", new Object[0]);
        }
        ArrayList<Tuple> nullTuple = new ArrayList<Tuple>();
        nullTuple.add(new Tuple(this.getNullTuple(size)));
        return nullTuple;
    }

    protected byte[] encodeStr(String str) throws SQLException {
        return this.connection.encodeString(str);
    }

    protected String getRSType(String rsType) throws SQLException {
        return rsTypeMap.getOrDefault(rsType, rsType);
    }

    protected String getSQLType(String rsType) throws SQLException {
        return Integer.toString(this.connection.getTypeInfo().getSQLType(rsType));
    }

    protected String getColumnSize(String rsType, String character_maximum_length, String numeric_precision) {
        switch (rsType) {
            case "decimal": 
            case "numeric": {
                return numeric_precision;
            }
            case "varchar": 
            case "character varying": 
            case "char": 
            case "character": 
            case "nchar": 
            case "bpchar": 
            case "nvarchar": {
                return character_maximum_length;
            }
            case "geometry": 
            case "super": 
            case "varbyte": 
            case "geography": {
                return null;
            }
        }
        return Integer.toString(rsColumnSizeMap.getOrDefault(rsType, Integer.MAX_VALUE));
    }

    protected String getDecimalDigit(String rsType, String numeric_scale, int precision, boolean customizePrecision) {
        switch (rsType) {
            case "float4": 
            case "real": {
                return "8";
            }
            case "float8": 
            case "double precision": {
                return "17";
            }
            case "time": 
            case "time without time zone": 
            case "timetz": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp without time zone": 
            case "timestamptz": 
            case "timestamp with time zone": 
            case "intervald2s": {
                return customizePrecision ? String.valueOf(precision) : "6";
            }
            case "intervaly2m": {
                return customizePrecision ? String.valueOf(precision) : "0";
            }
            case "geometry": 
            case "super": 
            case "varbyte": 
            case "geography": {
                return null;
            }
            case "numeric": {
                return numeric_scale;
            }
        }
        return "0";
    }

    protected String getNumPrefixRadix(String rsType) {
        switch (rsType) {
            case "varbyte": 
            case "geography": {
                return "2";
            }
        }
        return "10";
    }

    protected String getNullable(String nullable) {
        switch (nullable) {
            case "YES": {
                return Integer.toString(1);
            }
            case "NO": {
                return Integer.toString(0);
            }
        }
        return Integer.toString(2);
    }

    protected String getAutoIncrement(String colDef) {
        if (colDef != null && (colDef.contains("\"identity\"") || colDef.contains("default_identity"))) {
            return "YES";
        }
        return "NO";
    }

    static {
        rsTypeMap.put("character varying", "varchar");
        rsTypeMap.put("\"char\"", "char");
        rsTypeMap.put("character", "char");
        rsTypeMap.put("smallint", "int2");
        rsTypeMap.put("integer", "int4");
        rsTypeMap.put("bigint", "int8");
        rsTypeMap.put("real", "float4");
        rsTypeMap.put("double precision", "float8");
        rsTypeMap.put("boolean", "bool");
        rsTypeMap.put("time without time zone", "time");
        rsTypeMap.put("time with time zone", "timetz");
        rsTypeMap.put("timestamp without time zone", "timestamp");
        rsTypeMap.put("timestamp with time zone", "timestamptz");
        rsTypeMap.put("interval year to month", "intervaly2m");
        rsTypeMap.put("interval year", "intervaly2m");
        rsTypeMap.put("interval month", "intervaly2m");
        rsTypeMap.put("interval day to second", "intervald2s");
        rsTypeMap.put("interval day", "intervald2s");
        rsTypeMap.put("interval second", "intervald2s");
        rsColumnSizeMap = new HashMap<String, Integer>();
        rsColumnSizeMap.put("bit", 1);
        rsColumnSizeMap.put("bool", 1);
        rsColumnSizeMap.put("int2", 5);
        rsColumnSizeMap.put("int4", 10);
        rsColumnSizeMap.put("int8", 19);
        rsColumnSizeMap.put("float4", 8);
        rsColumnSizeMap.put("float8", 17);
        rsColumnSizeMap.put("date", 13);
        rsColumnSizeMap.put("time", 15);
        rsColumnSizeMap.put("timetz", 21);
        rsColumnSizeMap.put("timestamp", 29);
        rsColumnSizeMap.put("timestamptz", 35);
        rsColumnSizeMap.put("intervaly2m", 32);
        rsColumnSizeMap.put("intervald2s", 64);
    }

    public static interface enumFunc<T extends Enum<T>> {
        public int getIndex();

        public String getName();

        public int getOidType();
    }

    public static enum GetColumns_Metadata implements enumFunc<GetColumns_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043)),
        TABLE_SCHEM(new BaseMetadata(1, "TABLE_SCHEM", 1043)),
        TABLE_NAME(new BaseMetadata(2, "TABLE_NAME", 1043)),
        COLUMN_NAME(new BaseMetadata(3, "COLUMN_NAME", 1043)),
        DATA_TYPE(new BaseMetadata(4, "DATA_TYPE", 23)),
        TYPE_NAME(new BaseMetadata(5, "TYPE_NAME", 1043)),
        COLUMN_SIZE(new BaseMetadata(6, "COLUMN_SIZE", 23)),
        BUFFER_LENGTH(new BaseMetadata(7, "BUFFER_LENGTH", 23)),
        DECIMAL_DIGITS(new BaseMetadata(8, "DECIMAL_DIGITS", 23)),
        NUM_PREC_RADIX(new BaseMetadata(9, "NUM_PREC_RADIX", 23)),
        NULLABLE(new BaseMetadata(10, "NULLABLE", 23)),
        REMARKS(new BaseMetadata(11, "REMARKS", 1043)),
        COLUMN_DEF(new BaseMetadata(12, "COLUMN_DEF", 1043)),
        SQL_DATA_TYPE(new BaseMetadata(13, "SQL_DATA_TYPE", 23)),
        SQL_DATETIME_SUB(new BaseMetadata(14, "SQL_DATETIME_SUB", 23)),
        CHAR_OCTET_LENGTH(new BaseMetadata(15, "CHAR_OCTET_LENGTH", 23)),
        ORDINAL_POSITION(new BaseMetadata(16, "ORDINAL_POSITION", 23)),
        IS_NULLABLE(new BaseMetadata(17, "IS_NULLABLE", 1043)),
        SCOPE_CATALOG(new BaseMetadata(18, "SCOPE_CATALOG", 1043)),
        SCOPE_SCHEMA(new BaseMetadata(19, "SCOPE_SCHEMA", 1043)),
        SCOPE_TABLE(new BaseMetadata(20, "SCOPE_TABLE", 1043)),
        SOURCE_DATA_TYPE(new BaseMetadata(21, "SOURCE_DATA_TYPE", 21)),
        IS_AUTOINCREMENT(new BaseMetadata(22, "IS_AUTOINCREMENT", 1043)),
        IS_GENERATEDCOLUMN(new BaseMetadata(23, "IS_GENERATEDCOLUMN", 1043));

        private final BaseMetadata metadata;

        private GetColumns_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetTables_Metadata implements enumFunc<GetTables_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043)),
        TABLE_SCHEM(new BaseMetadata(1, "TABLE_SCHEM", 1043)),
        TABLE_NAME(new BaseMetadata(2, "TABLE_NAME", 1043)),
        TABLE_TYPE(new BaseMetadata(3, "TABLE_TYPE", 1043)),
        REMARKS(new BaseMetadata(4, "REMARKS", 1043)),
        TYPE_CAT(new BaseMetadata(5, "TYPE_CAT", 1043)),
        TYPE_SCHEM(new BaseMetadata(6, "TYPE_SCHEM", 1043)),
        TYPE_NAME(new BaseMetadata(7, "TYPE_NAME", 1043)),
        SELF_REFERENCING_COL_NAME(new BaseMetadata(8, "SELF_REFERENCING_COL_NAME", 1043)),
        REF_GENERATION(new BaseMetadata(9, "REF_GENERATION", 1043));

        private final BaseMetadata metadata;

        private GetTables_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetSchemas_Metadata implements enumFunc<GetSchemas_Metadata>
    {
        TABLE_SCHEM(new BaseMetadata(0, "TABLE_SCHEM", 1043)),
        TABLE_CATALOG(new BaseMetadata(1, "TABLE_CATALOG", 1043));

        private final BaseMetadata metadata;

        private GetSchemas_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetCatalogs_Metadata implements enumFunc<GetCatalogs_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043));

        private final BaseMetadata metadata;

        private GetCatalogs_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    private static class BaseMetadata {
        private final int colIndex;
        private final String colName;
        private final int colOidType;

        BaseMetadata(int colIndex, String colName, int colOidType) {
            this.colIndex = colIndex;
            this.colName = colName;
            this.colOidType = colOidType;
        }

        public int getIndex() {
            return this.colIndex;
        }

        public String getName() {
            return this.colName;
        }

        public int getOidType() {
            return this.colOidType;
        }
    }
}

