/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.connectiongroup;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.rest.connectiongroup.APIConnectionGroup;
import org.apache.guacamole.rest.connectiongroup.ConnectionGroupTree;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectionGroupResource
extends DirectoryObjectResource<ConnectionGroup, APIConnectionGroup> {
    @AssistedInject
    public ConnectionGroupResource(@Assisted AuthenticatedUser authenticatedUser, @Assisted UserContext userContext, @Assisted Directory<ConnectionGroup> directory, @Assisted ConnectionGroup connectionGroup, DirectoryObjectTranslator<ConnectionGroup, APIConnectionGroup> translator) {
        super(authenticatedUser, userContext, ConnectionGroup.class, directory, (Identifiable)connectionGroup, translator);
    }

    @GET
    @Path(value="tree")
    public APIConnectionGroup getConnectionGroupTree(@QueryParam(value="permission") List<ObjectPermission.Type> permissions) throws GuacamoleException {
        ConnectionGroupTree tree = new ConnectionGroupTree(this.getUserContext(), (ConnectionGroup)this.getInternalObject(), permissions);
        return tree.getRootAPIConnectionGroup();
    }
}

