/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.scheduling;

import java.util.concurrent.ScheduledFuture;
import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPool;
import org.apache.felix.hc.core.impl.scheduling.AsyncJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncIntervalJob
extends AsyncJob {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncIntervalJob.class);
    private final HealthCheckExecutorThreadPool healthCheckExecutorThreadPool;
    private final Long asyncIntervalInSec;
    private ScheduledFuture<?> scheduleFuture = null;

    public AsyncIntervalJob(Runnable runnable, HealthCheckExecutorThreadPool healthCheckExecutorThreadPool, Long asyncIntervalInSec) {
        super(runnable);
        this.healthCheckExecutorThreadPool = healthCheckExecutorThreadPool;
        this.asyncIntervalInSec = asyncIntervalInSec;
    }

    @Override
    public boolean schedule() {
        this.scheduleFuture = this.healthCheckExecutorThreadPool.scheduleAtFixedRate(this.runnable, this.asyncIntervalInSec);
        LOG.info("Scheduled job {} for execution every {}sec", (Object)this, (Object)this.asyncIntervalInSec);
        return true;
    }

    @Override
    public boolean unschedule() {
        if (this.scheduleFuture != null) {
            LOG.debug("Unscheduling async job for {}", (Object)this.runnable);
            return this.scheduleFuture.cancel(false);
        }
        LOG.debug("No scheduled future for {} exists", (Object)this.runnable);
        return false;
    }

    public String toString() {
        return "[Async interval job for " + this.runnable + "]";
    }
}

