/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import java.util.ArrayList;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;

public class SearchResultEditorCellModifier
implements ICellModifier {
    private ValueEditorManager valueEditorManager;
    private SearchResultEditorCursor cursor;

    public SearchResultEditorCellModifier(ValueEditorManager valueEditorManager, SearchResultEditorCursor cursor) {
        this.valueEditorManager = valueEditorManager;
        this.cursor = cursor;
    }

    public void dispose() {
        this.valueEditorManager = null;
    }

    public boolean canModify(Object element, String property) {
        if (element instanceof ISearchResult && property != null) {
            ISearchResult result = (ISearchResult)element;
            AttributeHierarchy ah = result.getAttributeWithSubtypes(property);
            if ("Dn".equals(property)) {
                return false;
            }
            if (ah == null) {
                ah = new AttributeHierarchy(result.getEntry(), property, new IAttribute[]{new Attribute(result.getEntry(), property)});
            }
            return this.valueEditorManager.getCurrentValueEditor(ah).getRawValue(ah) != null;
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof ISearchResult && property != null) {
            ISearchResult result = this.cursor.getSelectedSearchResult();
            AttributeHierarchy ah = result.getAttributeWithSubtypes(property);
            if (!this.canModify(element, property)) {
                return null;
            }
            if (ah == null) {
                ah = new AttributeHierarchy(result.getEntry(), property, new IAttribute[]{new Attribute(result.getEntry(), property)});
            }
            return this.valueEditorManager.getCurrentValueEditor(ah).getRawValue(ah);
        }
        return null;
    }

    public void modify(Object element, String property, Object newRawValue) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (element instanceof ISearchResult && property != null) {
            ISearchResult result = this.cursor.getSelectedSearchResult();
            AttributeHierarchy ah = result.getAttributeWithSubtypes(property);
            if (ah == null && newRawValue != null) {
                new CompoundModification().createValue(result.getEntry(), property, newRawValue);
            } else if (ah != null && newRawValue == null) {
                ArrayList<IValue> values = new ArrayList<IValue>();
                IAttribute[] iAttributeArray = ah.getAttributes();
                int n = iAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAttribute attribute = iAttributeArray[n2];
                    IValue[] iValueArray = attribute.getValues();
                    int n3 = iValueArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IValue value = iValueArray[n4];
                        values.add(value);
                        ++n4;
                    }
                    ++n2;
                }
                new CompoundModification().deleteValues(values);
            } else if (ah != null && ah.size() == 1 && ah.getAttribute().getValueSize() == 1 && newRawValue != null) {
                new CompoundModification().modifyValue(ah.getAttribute().getValues()[0], newRawValue);
            }
        }
    }
}

