/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.BrowserConnectionWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserInput;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserConnectionWidgetContributionItem
extends ContributionItem
implements ConnectionUpdateListener {
    private SchemaPage schemaPage;
    private ToolItem toolitem;
    private Composite toolItemComposite;
    private BrowserConnectionWidget browserConnectionWidget;

    public BrowserConnectionWidgetContributionItem(SchemaPage schemaPage) {
        this.schemaPage = schemaPage;
    }

    private Control createControl(Composite parent) {
        this.toolItemComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.toolItemComposite.setLayout((Layout)gridLayout);
        this.toolItemComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.browserConnectionWidget = new BrowserConnectionWidget();
        this.browserConnectionWidget.createWidget(this.toolItemComposite);
        this.browserConnectionWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                BrowserConnectionWidgetContributionItem.this.schemaPage.getSchemaBrowser().setInput(new SchemaBrowserInput(BrowserConnectionWidgetContributionItem.this.getConnection(), null));
            }
        });
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
        this.toolitem.setWidth(250);
        return this.toolItemComposite;
    }

    public void dispose() {
        ConnectionEventRegistry.removeConnectionUpdateListener((ConnectionUpdateListener)this);
        this.toolItemComposite.dispose();
        this.toolItemComposite = null;
        this.browserConnectionWidget = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        throw new UnsupportedOperationException(Messages.getString("BrowserConnectionWidgetContributionItem.CantAddControl"));
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    public IBrowserConnection getConnection() {
        return this.browserConnectionWidget.getBrowserConnection();
    }

    public void setConnection(IBrowserConnection connection) {
        this.browserConnectionWidget.setBrowserConnection(connection);
    }

    public void updateEnabledState() {
        this.browserConnectionWidget.setEnabled(!this.schemaPage.isShowDefaultSchema());
    }

    public final void connectionUpdated(Connection connection) {
        if (connection == null) {
            return;
        }
        IBrowserConnection selectedConnection = this.browserConnectionWidget.getBrowserConnection();
        if (connection.equals(selectedConnection.getConnection())) {
            this.browserConnectionWidget.setBrowserConnection(this.browserConnectionWidget.getBrowserConnection());
        }
    }

    public void connectionAdded(Connection connection) {
    }

    public void connectionRemoved(Connection connection) {
        if (connection == null) {
            return;
        }
        IBrowserConnection selectedConnection = this.browserConnectionWidget.getBrowserConnection();
        if (connection.equals(selectedConnection.getConnection())) {
            this.schemaPage.getSchemaBrowser().setInput(new SchemaBrowserInput(null, null));
        }
    }

    public void connectionOpened(Connection connection) {
    }

    public void connectionClosed(Connection connection) {
    }

    public void connectionFolderModified(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
    }
}

