/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSorter;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;

public class BrowserSearchResultPage {
    private BrowserSorter sorter;
    private int first;
    private int last;
    private ISearch search;
    private BrowserSearchResultPage parentSearchResultPage;
    private BrowserSearchResultPage[] subpages;

    public BrowserSearchResultPage(ISearch search, int first, int last, BrowserSearchResultPage[] subpages, BrowserSorter sorter) {
        this.search = search;
        this.first = first;
        this.last = last;
        this.subpages = subpages;
        this.sorter = sorter;
        if (subpages != null) {
            int i = 0;
            while (i < subpages.length) {
                subpages[i].parentSearchResultPage = this;
                ++i;
            }
        }
    }

    public Object[] getChildren() {
        if (this.subpages != null) {
            return this.subpages;
        }
        Object[] children = this.search.getSearchResults();
        this.sorter.sort(null, children);
        if (children != null) {
            Object[] childrenRange = new ISearchResult[this.last - this.first + 1];
            int i = this.first;
            while (i <= this.last) {
                childrenRange[i - this.first] = children[i];
                ++i;
            }
            return childrenRange;
        }
        return null;
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public ISearch getSearch() {
        return this.search;
    }

    public BrowserSearchResultPage getParentOf(ISearchResult searchResult) {
        if (this.subpages != null) {
            BrowserSearchResultPage ep = null;
            int i = 0;
            while (i < this.subpages.length && ep == null) {
                ep = this.subpages[i].getParentOf(searchResult);
                ++i;
            }
            return ep;
        }
        ISearchResult[] sr = (ISearchResult[])this.getChildren();
        if (sr != null && Arrays.asList(sr).contains(searchResult)) {
            return this;
        }
        return null;
    }

    public Object getParent() {
        return this.parentSearchResultPage != null ? this.parentSearchResultPage : this.search;
    }

    public String toString() {
        return String.valueOf(this.search.toString()) + "[" + this.first + "..." + this.last + "]" + this.hashCode();
    }
}

