/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class LargeSelect<T>
implements Runnable,
Serializable {
    private static final long serialVersionUID = -1166842932571491942L;
    private int pageSize;
    private int memoryLimit;
    private volatile transient int blockBegin = 0;
    private volatile transient int blockEnd;
    private volatile int currentlyFilledTo = -1;
    private transient List<T> results = null;
    private transient Thread thread = null;
    private volatile transient boolean killThread = false;
    private volatile transient boolean threadRunning = false;
    private volatile transient boolean queryCompleted = false;
    private transient boolean totalsFinalized = false;
    private int position;
    private int totalPages = -1;
    private int totalRecords = 0;
    private Criteria criteria = null;
    private transient List<T> lastResults;
    private BasePeerImpl<T> peer = null;
    public static final String DEFAULT_PAGE_PROGRESS_TEXT_PATTERN = "{0} of {1,choice,0#&gt; |1#}{2}";
    private String pageProgressTextPattern = "{0} of {1,choice,0#&gt; |1#}{2}";
    public static final String DEFAULT_RECORD_PROGRESS_TEXT_PATTERN = "{0} - {1} of {2,choice,0#&gt; |1#}{3}";
    private String recordProgressTextPattern = "{0} - {1} of {2,choice,0#&gt; |1#}{3}";
    public static final int DEFAULT_MEMORY_LIMIT_PAGES = 5;
    private int memoryPageLimit = 5;
    private static final int QUERY_NOT_COMPLETED_SLEEP_TIME = 500;
    private static final int QUERY_STOP_SLEEP_TIME = 1000;
    private Map<String, String> params = null;
    private static final Logger log = LogManager.getLogger(LargeSelect.class);

    public LargeSelect(Criteria criteria, int pageSize, BasePeerImpl<T> peerImpl) {
        this(criteria, pageSize, 5, peerImpl);
    }

    public LargeSelect(Criteria criteria, int pageSize, int memoryPageLimit, BasePeerImpl<T> peerImpl) {
        this.peer = peerImpl;
        if (criteria.getOffset() != 0L || criteria.getLimit() != -1) {
            throw new IllegalArgumentException("criteria must not use Offset and/or Limit.");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be greater than zero.");
        }
        if (memoryPageLimit < 1) {
            throw new IllegalArgumentException("memoryPageLimit must be greater than zero.");
        }
        this.pageSize = pageSize;
        this.memoryLimit = pageSize * memoryPageLimit;
        this.criteria = criteria;
        this.blockEnd = this.blockBegin + this.memoryLimit - 1;
        this.startQuery(pageSize);
    }

    public List<T> getPage(int pageNumber) throws TorqueException {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("pageNumber must be greater than zero.");
        }
        return this.getResults((pageNumber - 1) * this.pageSize);
    }

    public List<T> getNextResults() throws TorqueException {
        if (!this.getNextResultsAvailable()) {
            return this.getCurrentPageResults();
        }
        return this.getResults(this.position);
    }

    public synchronized List<T> getCurrentPageResults() throws TorqueException {
        return null == this.lastResults && this.position > 0 ? this.getResults(this.position) : this.lastResults;
    }

    public List<T> getPreviousResults() throws TorqueException {
        if (!this.getPreviousResultsAvailable()) {
            return this.getCurrentPageResults();
        }
        int start = this.position - 2 * this.pageSize < 0 ? 0 : this.position - 2 * this.pageSize;
        return this.getResults(start);
    }

    private List<T> getResults(int start) throws TorqueException {
        return this.getResults(start, this.pageSize);
    }

    private synchronized List<T> getResults(int start, int size) throws TorqueException {
        log.debug("getResults(start: {}, size: {}) invoked.", (Object)start, (Object)size);
        if (size > this.memoryLimit) {
            throw new IllegalArgumentException("size (" + size + ") exceeds memory limit (" + this.memoryLimit + ").");
        }
        if (start >= this.blockBegin && start + size - 1 <= this.blockEnd) {
            log.debug("getResults(): Sleeping until start+size-1 ({}) > currentlyFilledTo ({}) && !queryCompleted (!{})", new Supplier[]{() -> start + size - 1, () -> this.currentlyFilledTo, () -> this.queryCompleted});
            while (start + size - 1 > this.currentlyFilledTo && !this.queryCompleted) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e) {
                    throw new TorqueException("Unexpected interruption", e);
                }
            }
        } else {
            if (start < this.blockBegin && start >= 0) {
                log.debug("getResults(): Paging backwards as start ({}) < blockBegin ({}) && start >= 0", new Supplier[]{() -> start, () -> this.blockBegin});
                this.stopQuery();
                if (this.memoryLimit >= 2 * size) {
                    this.blockBegin = start - size;
                    if (this.blockBegin < 0) {
                        this.blockBegin = 0;
                    }
                } else {
                    this.blockBegin = start;
                }
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
                return this.getResults(start, size);
            }
            if (start + size - 1 > this.blockEnd) {
                log.debug("getResults(): Paging past end of loaded data as start+size-1 ({}) > blockEnd ({})", (Object)(start + size - 1), (Object)this.blockEnd);
                this.stopQuery();
                this.blockBegin = start;
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
                return this.getResults(start, size);
            }
            throw new IllegalArgumentException("Parameter configuration not accounted for.");
        }
        int fromIndex = start - this.blockBegin;
        int toIndex = fromIndex + Math.min(size, this.results.size() - fromIndex);
        log.debug("getResults(): Retrieving records from results elements start-blockBegin ({}) through fromIndex + Math.min(size, results.size() - fromIndex) ({})", new Supplier[]{() -> fromIndex, () -> toIndex});
        ArrayList<T> returnResults = new ArrayList<T>(this.results.subList(fromIndex, toIndex));
        this.position = start + size;
        this.lastResults = returnResults;
        return returnResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (TorqueConnection conn = Transaction.begin(this.criteria.getDbName());){
            this.results = new CopyOnWriteArrayList<T>();
            this.criteria.setOffset(this.blockBegin);
            this.criteria.setLimit(this.memoryLimit + 1);
            this.peer.correctBooleans(this.criteria);
            this.peer.setDbName(this.criteria);
            if (log.isDebugEnabled()) {
                log.debug("run(): query = {}", (Object)SqlBuilder.buildQuery(this.criteria).toString());
                log.debug("run(): memoryLimit = {}", (Object)this.memoryLimit);
                log.debug("run(): blockBegin = {}", (Object)this.blockBegin);
                log.debug("run(): blockEnd = {}", (Object)this.blockEnd);
            }
            boolean allRecordsRetrieved = false;
            while (!this.killThread && !allRecordsRetrieved && this.currentlyFilledTo + this.pageSize <= this.blockEnd) {
                log.debug("run(): Invoking BasePeerImpl.doSelect()");
                List<T> tempResults = this.peer.doSelect(this.criteria, (Connection)conn);
                if (tempResults.size() < this.criteria.getLimit()) {
                    allRecordsRetrieved = true;
                }
                boolean perhapsLastPage = true;
                int resultSetSize = tempResults.size();
                if (tempResults.size() == this.memoryLimit + 1) {
                    this.results.addAll(tempResults.subList(0, this.memoryLimit));
                    --resultSetSize;
                    perhapsLastPage = false;
                } else {
                    this.results.addAll(tempResults);
                }
                LargeSelect largeSelect = this;
                synchronized (largeSelect) {
                    this.currentlyFilledTo += resultSetSize;
                    if (this.results.size() > 0 && this.blockBegin + this.currentlyFilledTo >= this.totalRecords) {
                        this.totalRecords = this.blockBegin + this.currentlyFilledTo + 1;
                    }
                    if (allRecordsRetrieved) {
                        this.queryCompleted = true;
                        if (perhapsLastPage && this.getCurrentPageNumber() <= this.getTotalPages()) {
                            this.totalsFinalized = true;
                        }
                    }
                    this.notifyAll();
                }
            }
            Transaction.commit(conn);
            if (log.isDebugEnabled()) {
                log.debug("run(): While loop terminated because either:");
                log.debug("run(): 1. qds.allRecordsRetrieved(): {}", (Object)allRecordsRetrieved);
                log.debug("run(): 2. killThread: {}", (Object)this.killThread);
                log.debug("run(): 3. !(currentlyFilledTo + size <= blockEnd): !{}", (Object)(this.currentlyFilledTo + this.pageSize <= this.blockEnd ? 1 : 0));
                log.debug("run(): - currentlyFilledTo: {}", (Object)this.currentlyFilledTo);
                log.debug("run(): - size: {}", (Object)this.pageSize);
                log.debug("run(): - blockEnd: {}", (Object)this.blockEnd);
                log.debug("run(): - results.size(): {}", (Object)this.results.size());
            }
        }
        catch (TorqueException e) {
            log.error((Object)e);
        }
        finally {
            this.threadRunning = false;
            this.queryCompleted = true;
            log.debug("Exiting query thread");
        }
    }

    private synchronized void startQuery(int initialSize) {
        log.debug("Starting query thread");
        if (!this.threadRunning) {
            this.pageSize = initialSize;
            this.currentlyFilledTo = -1;
            this.queryCompleted = false;
            this.thread = new Thread(this);
            this.thread.setName("LargeSelect query Thread");
            this.thread.start();
            this.threadRunning = true;
            log.debug("query thread started");
        }
    }

    private synchronized void stopQuery() throws TorqueException {
        log.debug("stopQuery(): Stopping query thread");
        if (this.threadRunning) {
            this.killThread = true;
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException e) {
                throw new TorqueException("Unexpected interruption", e);
            }
            this.killThread = false;
            log.debug("stopQuery(): query thread stopped.");
        }
    }

    public int getCurrentPageNumber() {
        return this.position / this.pageSize;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public boolean getPaginated() {
        if (!this.getTotalsFinalized()) {
            return true;
        }
        return this.blockBegin + this.currentlyFilledTo + 1 > this.pageSize;
    }

    public int getTotalPages() {
        if (this.totalPages > -1) {
            return this.totalPages;
        }
        int tempPageCount = this.getTotalRecords() / this.pageSize + (this.getTotalRecords() % this.pageSize > 0 ? 1 : 0);
        if (this.getTotalsFinalized()) {
            this.totalPages = tempPageCount;
        }
        return tempPageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean getTotalsFinalized() {
        return this.totalsFinalized;
    }

    public String getPageProgressTextPattern() {
        return this.pageProgressTextPattern;
    }

    public void setPageProgressTextPattern(String pageProgressTextPattern) {
        this.pageProgressTextPattern = pageProgressTextPattern;
    }

    public String getRecordProgressTextPattern() {
        return this.recordProgressTextPattern;
    }

    public void setRecordProgressTextPattern(String recordProgressTextPattern) {
        this.recordProgressTextPattern = recordProgressTextPattern;
    }

    public void setMemoryPageLimit(int memoryPageLimit) {
        this.memoryPageLimit = memoryPageLimit;
    }

    public int getMemoryPageLimit() {
        return this.memoryPageLimit;
    }

    public String getPageProgressText() {
        return MessageFormat.format(this.getPageProgressTextPattern(), this.getCurrentPageNumber(), this.totalsFinalized ? 1 : 0, this.getTotalPages());
    }

    public int getCurrentPageSize() throws TorqueException {
        if (null == this.getCurrentPageResults()) {
            return 0;
        }
        return this.getCurrentPageResults().size();
    }

    public int getFirstRecordNoForPage() {
        if (this.getCurrentPageNumber() < 1) {
            return 0;
        }
        return (this.getCurrentPageNumber() - 1) * this.getPageSize() + 1;
    }

    public int getLastRecordNoForPage() throws TorqueException {
        if (0 == this.getCurrentPageNumber()) {
            return 0;
        }
        return (this.getCurrentPageNumber() - 1) * this.getPageSize() + this.getCurrentPageSize();
    }

    public String getRecordProgressText() throws TorqueException {
        return MessageFormat.format(this.getRecordProgressTextPattern(), this.getFirstRecordNoForPage(), this.getLastRecordNoForPage(), this.totalsFinalized ? 1 : 0, this.getTotalRecords());
    }

    public boolean getNextResultsAvailable() {
        return !this.totalsFinalized || this.getCurrentPageNumber() < this.getTotalPages();
    }

    public boolean getPreviousResultsAvailable() {
        return this.getCurrentPageNumber() > 1;
    }

    public boolean hasResultsAvailable() {
        return this.getTotalRecords() > 0;
    }

    public synchronized void invalidateResult() throws TorqueException {
        this.stopQuery();
        this.blockBegin = 0;
        this.blockEnd = 0;
        this.currentlyFilledTo = -1;
        this.results = null;
        this.position = 0;
        this.totalPages = -1;
        this.totalRecords = 0;
        this.queryCompleted = false;
        this.totalsFinalized = false;
        this.lastResults = null;
    }

    public String getSearchParam(String name) {
        return this.getSearchParam(name, null);
    }

    public String getSearchParam(String name, String defaultValue) {
        if (null == this.params) {
            return defaultValue;
        }
        String value = this.params.get(name);
        return null == value ? defaultValue : value;
    }

    public void setSearchParam(String name, String value) {
        if (null == value) {
            this.removeSearchParam(name);
        } else if (null != name) {
            if (null == this.params) {
                this.params = new Hashtable<String, String>();
            }
            this.params.put(name, value);
        }
    }

    public void removeSearchParam(String name) {
        if (null != this.params) {
            this.params.remove(name);
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        if (Torque.isInit()) {
            this.startQuery(this.pageSize);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("LargeSelect - TotalRecords: ");
        result.append(this.getTotalRecords());
        result.append(" TotalsFinalised: ");
        result.append(this.getTotalsFinalized());
        result.append("\nParameters:");
        if (null == this.params || this.params.size() == 0) {
            result.append(" No parameters have been set.");
        } else {
            this.params.forEach((key, val) -> result.append("\n ").append((String)key).append(": ").append((String)val));
        }
        return result.toString();
    }
}

