/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derby.optional.lucene.DerbyLuceneDir;
import org.apache.derby.optional.lucene.LuceneListIndexesVTI;
import org.apache.derby.optional.lucene.LuceneQueryVTI;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.VTITemplate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneSupport
implements OptionalTool {
    private static final String LUCENE_SCHEMA = "LuceneSupport";
    private static final String LIST_INDEXES = "LuceneSupport.listIndexes";
    private static final String CREATE_INDEX = "LuceneSupport.createIndex";
    private static final String DROP_INDEX = "LuceneSupport.dropIndex";
    private static final String UPDATE_INDEX = "LuceneSupport.updateIndex";
    private static final String SEPARATOR = "__";
    private static final String SCORE = "SCORE";
    private static final String DOCUMENT_ID = "DOCUMENTID";
    static final int TABLE_PART = 0;
    static final int COLUMN_PART = 1;
    static final int PART_COUNT = 2;
    private static final String PROPERTIES_FILE_NAME = "derby-lucene.properties";
    public static final String INDEX_DESCRIPTOR_MAKER = "derby.lucene.index.descriptor.maker";
    public static final String ANALYZER = "derby.lucene.analyzer";
    public static final String LUCENE_VERSION = "derby.lucene.version";
    public static final String UPDATE_TIMESTAMP = "derby.lucene.last.updated";

    public void loadTool(String ... configurationParameters) throws SQLException {
        LuceneSupport.forbidReadOnlyConnections();
        try {
            ConnectionUtil.getCurrentLCC().getDataDictionary().checkVersion(230, "luceneSupport");
        }
        catch (StandardException se) {
            throw ToolUtilities.sqlException(se);
        }
        Connection conn = LuceneSupport.getDefaultConnection();
        ToolUtilities.mustBeDBO(conn);
        if (LuceneSupport.getDataFactory(conn).databaseEncrypted()) {
            throw ToolUtilities.newSQLException("42XBL", new Object[0]);
        }
        if (LuceneSupport.luceneSchemaExists(conn)) {
            throw ToolUtilities.newSQLException("42XBG", new Object[0]);
        }
        boolean sqlAuthorizationEnabled = ToolUtilities.sqlAuthorizationEnabled(conn);
        StringBuilder listFunction = new StringBuilder();
        listFunction.append("create function LuceneSupport.listIndexes");
        listFunction.append(" () ");
        listFunction.append("returns table");
        listFunction.append("(");
        listFunction.append("schemaname varchar( 128 ),");
        listFunction.append("tablename varchar( 128 ),");
        listFunction.append("columnname varchar( 128 ),");
        listFunction.append("lastupdated timestamp,");
        listFunction.append("luceneversion varchar( 20 ),");
        listFunction.append("analyzer varchar( 32672 ),");
        listFunction.append("indexdescriptormaker varchar( 32672 )");
        listFunction.append(")");
        listFunction.append("language java ");
        listFunction.append("parameter style DERBY_JDBC_RESULT_SET ");
        listFunction.append("contains sql ");
        listFunction.append("external name '" + this.getClass().getName() + ".listIndexes'");
        this.executeDDL(conn, listFunction.toString());
        StringBuilder createProcedure = new StringBuilder();
        createProcedure.append("create procedure LuceneSupport.createIndex");
        createProcedure.append(" (schemaname varchar( 128 ),");
        createProcedure.append("tablename varchar( 128 ),");
        createProcedure.append("textcolumn varchar( 128 ),");
        createProcedure.append("indexdescriptormaker varchar( 32672 ),");
        createProcedure.append("keyColumns varchar( 32672 )...)");
        createProcedure.append("parameter style derby modifies sql data language java external name ");
        createProcedure.append("'" + this.getClass().getName() + ".createIndex'");
        this.executeDDL(conn, createProcedure.toString());
        StringBuilder dropProcedure = new StringBuilder();
        dropProcedure.append("create procedure LuceneSupport.dropIndex");
        dropProcedure.append(" (schemaname varchar( 128 ),");
        dropProcedure.append("tablename varchar( 128 ),");
        dropProcedure.append("textcolumn varchar( 128 ))");
        dropProcedure.append("parameter style java modifies sql data language java external name ");
        dropProcedure.append("'" + this.getClass().getName() + ".dropIndex'");
        this.executeDDL(conn, dropProcedure.toString());
        StringBuilder updateProcedure = new StringBuilder();
        updateProcedure.append("create procedure LuceneSupport.updateIndex");
        updateProcedure.append(" (schemaname varchar( 128 ),");
        updateProcedure.append("tablename varchar( 128 ),");
        updateProcedure.append("textcolumn varchar( 128 ),");
        updateProcedure.append("indexdescriptormaker varchar( 32672 ))");
        updateProcedure.append("parameter style java reads sql data language java external name ");
        updateProcedure.append("'" + this.getClass().getName() + ".updateIndex'");
        this.executeDDL(conn, updateProcedure.toString());
        if (sqlAuthorizationEnabled) {
            this.grantPermissions();
        }
        LuceneSupport.createLuceneDir(conn);
    }

    private void grantPermissions() throws SQLException {
        Connection conn = LuceneSupport.getDefaultConnection();
        this.executeDDL(conn, "grant execute on function LuceneSupport.listIndexes to public");
        this.executeDDL(conn, "grant execute on procedure LuceneSupport.createIndex to public");
        this.executeDDL(conn, "grant execute on procedure LuceneSupport.dropIndex to public");
        this.executeDDL(conn, "grant execute on procedure LuceneSupport.updateIndex to public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadTool(String ... configurationParameters) throws SQLException {
        LuceneSupport.forbidReadOnlyConnections();
        Connection conn = LuceneSupport.getDefaultConnection();
        ToolUtilities.mustBeDBO(conn);
        if (!LuceneSupport.luceneSchemaExists(conn)) {
            throw ToolUtilities.newSQLException("42XBH", new Object[0]);
        }
        String className = this.getClass().getName();
        int endPackageIdx = className.lastIndexOf(".");
        String packageName = className.substring(0, endPackageIdx);
        PreparedStatement ps = conn.prepareStatement("select s.schemaName, a.alias, a.aliastype\nfrom sys.sysschemas s, sys.sysaliases a\nwhere s.schemaID = a.schemaID\nand substr( cast( a.javaclassname as varchar( 32672 ) ), 1, ? ) = ?\n");
        ps.setInt(1, packageName.length());
        ps.setString(2, packageName);
        try (ResultSet routines = ps.executeQuery();){
            while (routines.next()) {
                String schema = routines.getString(1);
                String routineName = routines.getString(2);
                String routineType = "P".equals(routines.getString(3)) ? "procedure" : "function";
                conn.prepareStatement("drop " + routineType + " " + LuceneSupport.makeTableName(schema, routineName)).execute();
            }
        }
        conn.prepareStatement("drop schema LuceneSupport restrict").execute();
        StorageFactory storageFactory = LuceneSupport.getStorageFactory(conn);
        StorageFile luceneDir = storageFactory.newStorageFile("LUCENE");
        if (LuceneSupport.exists(luceneDir)) {
            LuceneSupport.deleteFile(luceneDir);
        }
    }

    public static LuceneQueryVTI luceneQuery(String queryText, int windowSize, Float scoreCeiling) throws ParseException, IOException, SQLException {
        LuceneQueryVTI lqvti = new LuceneQueryVTI(queryText, windowSize, scoreCeiling);
        return lqvti;
    }

    public static LuceneListIndexesVTI listIndexes() throws IOException, PrivilegedActionException, SQLException {
        LuceneListIndexesVTI llivti = new LuceneListIndexesVTI();
        return llivti;
    }

    public static void updateIndex(String schema, String table, String textcol, String indexDescriptorMaker) throws SQLException, IOException, PrivilegedActionException {
        LuceneSupport.forbidReadOnlyConnections();
        Connection conn = LuceneSupport.getDefaultConnection();
        LuceneSupport.vetIdentifiers(schema, table, textcol);
        ToolUtilities.mustBeOwner(conn, schema);
        if (!LuceneSupport.tableFunctionExists(conn, schema, table, textcol)) {
            throw ToolUtilities.newSQLException("42XBE", new Object[0]);
        }
        LuceneSupport.createOrRecreateIndex(conn, schema, table, textcol, indexDescriptorMaker, false, new String[0]);
    }

    public static void createIndex(String schema, String table, String textcol, String indexDescriptorMaker, String ... keyColumns) throws SQLException, IOException, PrivilegedActionException {
        LuceneSupport.forbidReadOnlyConnections();
        Connection conn = LuceneSupport.getDefaultConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        LuceneSupport.vetIdentifiers(schema, table, textcol);
        LuceneSupport.vetTextColumn(dbmd, schema, table, textcol);
        LuceneSupport.createOrRecreateIndex(conn, schema, table, textcol, indexDescriptorMaker, true, keyColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createOrRecreateIndex(Connection conn, String schema, String table, String textcol, String indexDescriptorMaker, boolean create, String ... keyColumns) throws SQLException, IOException, PrivilegedActionException {
        VTITemplate.ColumnDescriptor[] primaryKeys = new VTITemplate.ColumnDescriptor[]{};
        primaryKeys = !create ? LuceneSupport.getKeys(conn, schema, table, textcol) : (keyColumns != null && keyColumns.length > 0 ? LuceneSupport.getKeys(conn, schema, table, keyColumns) : LuceneSupport.getPrimaryKeys(conn, schema, table));
        if (primaryKeys.length == 0) {
            throw ToolUtilities.newSQLException("42XBB", new Object[0]);
        }
        LuceneSupport.vetColumnName(ToolUtilities.derbyIdentifier(textcol));
        for (VTITemplate.ColumnDescriptor key : primaryKeys) {
            LuceneSupport.vetColumnName(key.columnName);
        }
        int keyCount = 0;
        StorageFile propertiesFile = LuceneSupport.getIndexPropertiesFile(conn, schema, table, textcol);
        if (!create) {
            LuceneSupport.dropIndexDirectories(schema, table, textcol);
        }
        Version luceneVersion = LuceneUtils.currentVersion();
        DerbyLuceneDir derbyLuceneDir = LuceneSupport.getDerbyLuceneDir(conn, schema, table, textcol);
        if (indexDescriptorMaker == null) {
            indexDescriptorMaker = LuceneUtils.class.getName() + ".defaultIndexDescriptor";
        }
        LuceneIndexDescriptor indexDescriptor = LuceneSupport.getIndexDescriptor((String)indexDescriptorMaker);
        String[] fieldNames = indexDescriptor.getFieldNames();
        Analyzer analyzer = indexDescriptor.getAnalyzer();
        LuceneSupport.sortAndVetFieldNames(fieldNames, primaryKeys);
        Properties indexProperties = new Properties();
        indexProperties.setProperty(LUCENE_VERSION, luceneVersion.toString());
        indexProperties.setProperty(UPDATE_TIMESTAMP, Long.toString(System.currentTimeMillis()));
        indexProperties.setProperty(INDEX_DESCRIPTOR_MAKER, (String)indexDescriptorMaker);
        indexProperties.setProperty(ANALYZER, analyzer.getClass().getName());
        StringBuilder tableFunction = new StringBuilder();
        tableFunction.append("create function " + LuceneSupport.makeTableFunctionName(schema, table, textcol) + "\n");
        tableFunction.append("( query varchar( 32672 ), windowSize int, scoreCeiling real )\n");
        tableFunction.append("returns table\n(");
        LuceneSupport.writeIndexProperties(propertiesFile, indexProperties);
        Statement ps = null;
        ResultSet rs = null;
        IndexWriter iw = null;
        try {
            iw = LuceneSupport.getIndexWriter(luceneVersion, analyzer, derbyLuceneDir);
            StringBuilder query = new StringBuilder("select ");
            for (VTITemplate.ColumnDescriptor keyDesc : primaryKeys) {
                String keyName = LuceneSupport.delimitID(keyDesc.columnName);
                if (keyCount > 0) {
                    query.append(", ");
                }
                query.append(keyName);
                String keyType = LuceneSupport.mapType(keyDesc);
                if (keyCount > 0) {
                    tableFunction.append(",");
                }
                tableFunction.append("\n\t" + keyName + " " + keyType);
                ++keyCount;
            }
            tableFunction.append(",\n\tDOCUMENTID int");
            tableFunction.append(",\n\tSCORE real");
            tableFunction.append("\n)\nlanguage java parameter style derby_jdbc_result_set contains sql\n");
            tableFunction.append("external name '" + LuceneSupport.class.getName() + ".luceneQuery'");
            if (create) {
                conn.prepareStatement(tableFunction.toString()).execute();
            }
            query.append(", ");
            query.append(LuceneSupport.delimitID(ToolUtilities.derbyIdentifier(textcol)));
            query.append(" from " + LuceneSupport.makeTableName(schema, table));
            ps = conn.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                Document doc = new Document();
                for (int i = 0; i < keyCount; ++i) {
                    VTITemplate.ColumnDescriptor keyDescriptor = primaryKeys[i];
                    LuceneSupport.addValue(doc, keyDescriptor, rs, i + 1);
                }
                String textcolValue = rs.getString(keyCount + 1);
                if (textcolValue != null) {
                    for (String fieldName : fieldNames) {
                        doc.add((IndexableField)new TextField(fieldName, textcolValue, Field.Store.NO));
                    }
                }
                LuceneSupport.addDocument(iw, doc);
            }
        }
        finally {
            try {
                if (iw != null) {
                    LuceneSupport.close(iw);
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        }
    }

    private static void vetIdentifiers(String schema, String table, String textcol) throws SQLException {
        LuceneSupport.checkNotNull("SCHEMANAME", schema);
        LuceneSupport.checkNotNull("TABLENAME", table);
        LuceneSupport.checkNotNull("TEXTCOLUMN", textcol);
    }

    private static void sortAndVetFieldNames(String[] fieldNames, VTITemplate.ColumnDescriptor[] keys) throws SQLException {
        for (String fieldName : fieldNames) {
            if (fieldName != null) continue;
            throw ToolUtilities.newSQLException("42XBO", fieldName);
        }
        Arrays.sort(fieldNames);
        HashSet<String> keyNames = new HashSet<String>();
        for (VTITemplate.ColumnDescriptor cd : keys) {
            keyNames.add(cd.columnName);
        }
        String previousFieldName = null;
        for (String fieldName : fieldNames) {
            if (fieldName.equals(previousFieldName)) {
                throw ToolUtilities.newSQLException("42XBO", fieldName);
            }
            previousFieldName = fieldName;
            if (!keyNames.contains(fieldName)) continue;
            throw ToolUtilities.newSQLException("42XBN", fieldName);
        }
    }

    public static void dropIndex(String schema, String table, String textcol) throws SQLException {
        LuceneSupport.forbidReadOnlyConnections();
        LuceneSupport.vetIdentifiers(schema, table, textcol);
        LuceneSupport.getDefaultConnection().prepareStatement("drop function " + LuceneSupport.makeTableFunctionName(schema, table, textcol)).execute();
        LuceneSupport.dropIndexDirectories(schema, table, textcol);
    }

    private static void dropIndexDirectories(String schema, String table, String textcol) throws SQLException {
        DerbyLuceneDir derbyLuceneDir = LuceneSupport.getDerbyLuceneDir(LuceneSupport.getDefaultConnection(), schema, table, textcol);
        StorageFile indexDir = derbyLuceneDir.getDirectory();
        StorageFile tableDir = indexDir.getParentDir();
        StorageFile schemaDir = tableDir.getParentDir();
        LuceneSupport.deleteFile(indexDir);
        if (LuceneSupport.isEmpty(tableDir)) {
            LuceneSupport.deleteFile(tableDir);
            if (LuceneSupport.isEmpty(schemaDir)) {
                LuceneSupport.deleteFile(schemaDir);
            }
        }
    }

    private static String mapType(VTITemplate.ColumnDescriptor keyDesc) throws SQLException {
        return LuceneSupport.mapType(keyDesc.jdbcType, keyDesc.precision, keyDesc.scale, keyDesc.typeName);
    }

    private static String mapType(int jdbcType, int precision, int scale, String typeName) throws SQLException {
        switch (jdbcType) {
            case -5: {
                return "bigint";
            }
            case -2: {
                return "char " + LuceneSupport.precisionToLength(precision) + "  for bit data";
            }
            case -7: {
                return "boolean";
            }
            case 2004: {
                return "blob";
            }
            case 16: {
                return "boolean";
            }
            case 1: {
                return "char" + LuceneSupport.precisionToLength(precision);
            }
            case 2005: {
                return "clob";
            }
            case 91: {
                return "date";
            }
            case 3: {
                return "decimal" + LuceneSupport.precisionAndScale(precision, scale);
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 4: {
                return "integer";
            }
            case -4: {
                return "long varchar for bit data";
            }
            case -1: {
                return "long varchar";
            }
            case 2: {
                return "numeric" + LuceneSupport.precisionAndScale(precision, scale);
            }
            case 7: {
                return "real";
            }
            case 5: {
                return "smallint";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "smallint";
            }
            case -3: {
                return "varchar " + LuceneSupport.precisionToLength(precision) + "  for bit data";
            }
            case 12: {
                return "varchar" + LuceneSupport.precisionToLength(precision);
            }
        }
        throw ToolUtilities.newSQLException("42XBC", typeName);
    }

    private static String precisionToLength(int precision) {
        return "( " + precision + " )";
    }

    private static String precisionAndScale(int precision, int scale) {
        return "( " + precision + ", " + scale + " )";
    }

    private static void addValue(Document doc, VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        IndexableField field = null;
        switch (keyDescriptor.jdbcType) {
            case -6: 
            case 4: 
            case 5: {
                field = LuceneSupport.getIntField(keyDescriptor, rs, columnIdx);
                break;
            }
            case 7: {
                field = LuceneSupport.getFloatField(keyDescriptor, rs, columnIdx);
                break;
            }
            case 6: 
            case 8: {
                field = LuceneSupport.getDoubleField(keyDescriptor, rs, columnIdx);
                break;
            }
            case -5: {
                field = LuceneSupport.getLongField(keyDescriptor, rs, columnIdx);
                break;
            }
            case 91: {
                field = LuceneSupport.getDateField(keyDescriptor, rs, columnIdx);
                break;
            }
            case 92: {
                field = LuceneSupport.getTimeField(keyDescriptor, rs, columnIdx);
                break;
            }
            case 93: {
                field = LuceneSupport.getTimestampField(keyDescriptor, rs, columnIdx);
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 2005: {
                field = LuceneSupport.getStringField(keyDescriptor, rs, columnIdx);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                field = LuceneSupport.getBinaryField(keyDescriptor, rs, columnIdx);
                break;
            }
            case -7: 
            case 16: {
                boolean booleanValue = rs.getBoolean(columnIdx);
                if (rs.wasNull()) break;
                field = new StringField(keyDescriptor.columnName, booleanValue ? "true" : "false", Field.Store.YES);
                break;
            }
            default: {
                throw ToolUtilities.newSQLException("42XBC", keyDescriptor.typeName);
            }
        }
        if (rs.wasNull()) {
            field = null;
        }
        if (field != null) {
            doc.add(field);
        }
    }

    private static IndexableField getStringField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        String stringValue = rs.getString(columnIdx);
        if (stringValue != null) {
            return new StringField(keyDescriptor.columnName, stringValue, Field.Store.YES);
        }
        return null;
    }

    private static IndexableField getFloatField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        float value = rs.getFloat(columnIdx);
        if (rs.wasNull()) {
            return null;
        }
        return new StoredField(keyDescriptor.columnName, value);
    }

    private static IndexableField getDoubleField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        double value = rs.getDouble(columnIdx);
        if (rs.wasNull()) {
            return null;
        }
        return new StoredField(keyDescriptor.columnName, value);
    }

    private static IndexableField getLongField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        long value = rs.getLong(columnIdx);
        if (rs.wasNull()) {
            return null;
        }
        return new StoredField(keyDescriptor.columnName, value);
    }

    private static IndexableField getDateField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        Date value = rs.getDate(columnIdx);
        if (rs.wasNull()) {
            return null;
        }
        return new StoredField(keyDescriptor.columnName, value.getTime());
    }

    private static IndexableField getTimeField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        Time value = rs.getTime(columnIdx);
        if (rs.wasNull()) {
            return null;
        }
        return new StoredField(keyDescriptor.columnName, value.getTime());
    }

    private static IndexableField getTimestampField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        Timestamp value = rs.getTimestamp(columnIdx);
        if (rs.wasNull()) {
            return null;
        }
        return new StoredField(keyDescriptor.columnName, value.getTime());
    }

    private static IndexableField getIntField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        int value = rs.getInt(columnIdx);
        if (rs.wasNull()) {
            return null;
        }
        return new StoredField(keyDescriptor.columnName, value);
    }

    private static IndexableField getBinaryField(VTITemplate.ColumnDescriptor keyDescriptor, ResultSet rs, int columnIdx) throws SQLException {
        byte[] value = rs.getBytes(columnIdx);
        if (value != null) {
            BytesRef ref = new BytesRef(value);
            return new StoredField(keyDescriptor.columnName, ref);
        }
        return null;
    }

    private static void vetTextColumn(DatabaseMetaData dbmd, String schema, String table, String textcol) throws SQLException {
        schema = ToolUtilities.derbyIdentifier(schema);
        table = ToolUtilities.derbyIdentifier(table);
        textcol = ToolUtilities.derbyIdentifier(textcol);
        try (ResultSet rs = dbmd.getColumns(null, schema, table, textcol);){
            if (rs.next()) {
                switch (rs.getInt("DATA_TYPE")) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return;
                    }
                }
            }
            throw ToolUtilities.sqlException(StandardException.newException("42XBA", new Object[0]));
        }
    }

    private static void vetColumnName(String columnName) throws SQLException {
        String derbyColumnName = columnName;
        if (DOCUMENT_ID.equals(derbyColumnName) || SCORE.equals(derbyColumnName)) {
            throw ToolUtilities.newSQLException("42XBJ", derbyColumnName);
        }
    }

    static String makeTableName(String schema, String table) throws SQLException {
        schema = ToolUtilities.derbyIdentifier(schema);
        table = ToolUtilities.derbyIdentifier(table);
        return IdUtil.mkQualifiedName((String)schema, (String)table);
    }

    private static String makeTableFunctionName(String schema, String table, String textcol) throws SQLException {
        LuceneSupport.forbidCharacter(schema, table, textcol, ".");
        LuceneSupport.forbidCharacter(schema, table, textcol, "/");
        LuceneSupport.forbidCharacter(schema, table, textcol, "\\");
        schema = ToolUtilities.derbyIdentifier(schema);
        String function = LuceneSupport.makeUnqualifiedTableFunctionName(table, textcol);
        return IdUtil.mkQualifiedName((String)schema, (String)function);
    }

    private static String makeUnqualifiedTableFunctionName(String table, String textcol) throws SQLException {
        return ToolUtilities.derbyIdentifier(table) + SEPARATOR + ToolUtilities.derbyIdentifier(textcol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableFunctionExists(Connection conn, String schema, String table, String textcol) throws SQLException {
        schema = ToolUtilities.derbyIdentifier(schema);
        String function = LuceneSupport.makeUnqualifiedTableFunctionName(table, textcol);
        try (ResultSet rs = conn.getMetaData().getFunctions(null, schema, function);){
            boolean bl = rs.next();
            return bl;
        }
    }

    static String[] decodeFunctionName(String functionName) {
        int separatorIdx = functionName.indexOf(SEPARATOR);
        String[] retval = new String[]{functionName.substring(0, separatorIdx), functionName.substring(separatorIdx + SEPARATOR.length())};
        return retval;
    }

    static StorageFile getIndexPropertiesFile(Connection conn, String schema, String table, String textcol) throws SQLException, IOException, PrivilegedActionException {
        return LuceneSupport.getIndexPropertiesFile(LuceneSupport.getDerbyLuceneDir(conn, schema, table, textcol));
    }

    static StorageFile getIndexPropertiesFile(DerbyLuceneDir dir) throws SQLException, IOException, PrivilegedActionException {
        StorageFile propertiesFile = dir.getFile(PROPERTIES_FILE_NAME);
        return propertiesFile;
    }

    static Properties readIndexPropertiesNoPrivs(StorageFile file) throws IOException {
        if (file == null) {
            return null;
        }
        Properties properties = new Properties();
        InputStream is = file.getInputStream();
        properties.load(is);
        is.close();
        return properties;
    }

    private static void writeIndexProperties(final StorageFile file, Properties properties) throws IOException {
        OutputStream os;
        if (file == null || properties == null) {
            return;
        }
        try {
            os = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return file.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        properties.store(os, null);
        os.flush();
        os.close();
    }

    private static void forbidReadOnlyConnections() throws SQLException {
        if (ConnectionUtil.getCurrentLCC().getAuthorizer().isReadOnlyConnection()) {
            throw ToolUtilities.newSQLException("25502", new Object[0]);
        }
    }

    static Connection getDefaultConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean luceneSchemaExists(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("select count(*) from sys.sysschemas where schemaName = ?");
        ps.setString(1, LUCENE_SCHEMA.toUpperCase());
        ResultSet rs = ps.executeQuery();
        try {
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        finally {
            rs.close();
            ps.close();
        }
    }

    private void executeDDL(Connection c, String text) throws SQLException {
        PreparedStatement ddl = c.prepareStatement(text);
        ddl.execute();
        ddl.close();
    }

    static String delimitID(String id) {
        return IdUtil.normalToDelimited((String)id);
    }

    static void checkNotNull(String argumentName, String argumentValue) throws SQLException {
        if (argumentValue == null) {
            throw ToolUtilities.newSQLException("42XBM", argumentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VTITemplate.ColumnDescriptor[] getPrimaryKeys(Connection conn, String schema, String table) throws SQLException {
        ArrayList<VTITemplate.ColumnDescriptor> keyArray = new ArrayList<VTITemplate.ColumnDescriptor>();
        try (ResultSet keysRS = conn.getMetaData().getPrimaryKeys(null, ToolUtilities.derbyIdentifier(schema), ToolUtilities.derbyIdentifier(table));){
            while (keysRS.next()) {
                String columnName = keysRS.getString("COLUMN_NAME");
                int keyPosition = keysRS.getInt("KEY_SEQ");
                ResultSet colInfoRS = conn.prepareStatement("select " + columnName + " from " + LuceneSupport.makeTableName(schema, table) + " where 1=2").executeQuery();
                ResultSetMetaData rsmd = colInfoRS.getMetaData();
                VTITemplate.ColumnDescriptor keyDescriptor = new VTITemplate.ColumnDescriptor(columnName, rsmd.getColumnType(1), rsmd.getPrecision(1), rsmd.getScale(1), rsmd.getColumnTypeName(1), keyPosition);
                keyArray.add(keyDescriptor);
                colInfoRS.close();
            }
        }
        Object[] result = new VTITemplate.ColumnDescriptor[keyArray.size()];
        keyArray.toArray(result);
        Arrays.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VTITemplate.ColumnDescriptor[] getKeys(Connection conn, String schema, String table, String textcol) throws SQLException {
        schema = ToolUtilities.derbyIdentifier(schema);
        String functionName = LuceneSupport.makeUnqualifiedTableFunctionName(table, textcol);
        ArrayList<VTITemplate.ColumnDescriptor> keyArray = new ArrayList<VTITemplate.ColumnDescriptor>();
        try (ResultSet rs = conn.getMetaData().getFunctionColumns(null, schema, functionName, "%");){
            while (rs.next()) {
                if (rs.getInt("COLUMN_TYPE") != 5) continue;
                VTITemplate.ColumnDescriptor keyDescriptor = new VTITemplate.ColumnDescriptor(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"), rs.getInt("PRECISION"), rs.getInt("SCALE"), rs.getString("TYPE_NAME"), rs.getInt("ORDINAL_POSITION"));
                keyArray.add(keyDescriptor);
            }
        }
        Object[] temp = new VTITemplate.ColumnDescriptor[keyArray.size()];
        keyArray.toArray(temp);
        Arrays.sort(temp);
        int count = temp.length - 2;
        VTITemplate.ColumnDescriptor[] result = new VTITemplate.ColumnDescriptor[count];
        for (int i = 0; i < count; ++i) {
            result[i] = temp[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VTITemplate.ColumnDescriptor[] getKeys(Connection conn, String schema, String table, String ... keyColumns) throws SQLException {
        String qualifiedName = LuceneSupport.makeTableName(schema, table);
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ");
        int counter = 0;
        for (String key : keyColumns) {
            LuceneSupport.checkNotNull("KEYCOLUMNS", key);
            if (counter > 0) {
                buffer.append(", ");
            }
            ++counter;
            buffer.append(LuceneSupport.delimitID(ToolUtilities.derbyIdentifier(key)));
        }
        buffer.append("\nfrom " + qualifiedName);
        buffer.append("\nwhere 1=2");
        ArrayList<VTITemplate.ColumnDescriptor> keyArray = new ArrayList<VTITemplate.ColumnDescriptor>();
        ResultSet rs = conn.prepareStatement(buffer.toString()).executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        try {
            for (int keyPosition = 1; keyPosition <= rsmd.getColumnCount(); ++keyPosition) {
                VTITemplate.ColumnDescriptor keyDescriptor = new VTITemplate.ColumnDescriptor(rsmd.getColumnName(keyPosition), rsmd.getColumnType(keyPosition), rsmd.getPrecision(keyPosition), rsmd.getScale(keyPosition), rsmd.getColumnTypeName(keyPosition), keyPosition);
                keyArray.add(keyDescriptor);
            }
        }
        finally {
            rs.close();
        }
        VTITemplate.ColumnDescriptor[] result = new VTITemplate.ColumnDescriptor[keyArray.size()];
        keyArray.toArray(result);
        return result;
    }

    private static boolean isEmpty(final StorageFile dir) {
        String[] contents = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return dir.list();
            }
        });
        if (contents == null) {
            return true;
        }
        return contents.length == 0;
    }

    private static boolean exists(final StorageFile file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    private static boolean deleteFile(final StorageFile file) throws SQLException {
        boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory() ? file.deleteAll() : file.delete();
            }
        });
        if (!result) {
            throw ToolUtilities.newSQLException("XBM0R.D", file.getPath());
        }
        return result;
    }

    private static void forbidCharacter(String schema, String table, String textcol, String invalidCharacter) throws SQLException {
        if (schema.indexOf(invalidCharacter) > 0 || table.indexOf(invalidCharacter) > 0 || textcol.indexOf(invalidCharacter) > 0) {
            throw ToolUtilities.newSQLException("42XBD", invalidCharacter);
        }
    }

    private static IndexWriter getIndexWriter(final Version luceneVersion, final Analyzer analyzer, final DerbyLuceneDir derbyLuceneDir) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<IndexWriter>(){

                @Override
                public IndexWriter run() throws IOException {
                    IndexWriterConfig iwc = new IndexWriterConfig(luceneVersion, analyzer);
                    IndexWriter iw = new IndexWriter((Directory)derbyLuceneDir, iwc);
                    return iw;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    private static void addDocument(final IndexWriter indexWriter, final Document document) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    indexWriter.addDocument((Iterable)document);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    private static void close(final IndexWriter indexWriter) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    indexWriter.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    private static LuceneIndexDescriptor getIndexDescriptor(final String indexDescriptorMaker) throws PrivilegedActionException, SQLException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<LuceneIndexDescriptor>(){

            @Override
            public LuceneIndexDescriptor run() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException {
                return LuceneSupport.getIndexDescriptorNoPrivs(indexDescriptorMaker);
            }
        });
    }

    static LuceneIndexDescriptor getIndexDescriptorNoPrivs(String indexDescriptorMaker) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException {
        int lastDotIdx = indexDescriptorMaker.lastIndexOf(".");
        String className = indexDescriptorMaker.substring(0, lastDotIdx);
        ClassInspector ci = LuceneSupport.getClassFactory().getClassInspector();
        Class klass = ci.getClass(className);
        String methodName = indexDescriptorMaker.substring(lastDotIdx + 1, indexDescriptorMaker.length());
        Method method = klass.getDeclaredMethod(methodName, new Class[0]);
        return (LuceneIndexDescriptor)method.invoke(null, new Object[0]);
    }

    private static void createLuceneDir(final Connection conn) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SQLException {
                    StorageFactory storageFactory = LuceneSupport.getStorageFactory(conn);
                    StorageFile luceneDir = storageFactory.newStorageFile("LUCENE");
                    luceneDir.mkdir();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SQLException)pae.getCause();
        }
    }

    static DerbyLuceneDir getDerbyLuceneDir(Connection conn, String schema, String table, String textcol) throws SQLException {
        StorageFactory storageFactory = LuceneSupport.getStorageFactory(conn);
        DerbyLuceneDir result = DerbyLuceneDir.getDirectory(storageFactory, schema, table, textcol);
        return result;
    }

    static StorageFactory getStorageFactory(Connection conn) throws SQLException {
        return LuceneSupport.getDataFactory(conn).getStorageFactory();
    }

    static DataFactory getDataFactory(Connection conn) throws SQLException {
        try {
            Object monitor = LuceneSupport.findService("org.apache.derby.database.Database", ((EmbedConnection)conn).getDBName());
            return (DataFactory)LuceneSupport.findServiceModule(monitor, "org.apache.derby.iapi.store.raw.data.DataFactory");
        }
        catch (StandardException se) {
            throw ToolUtilities.wrap(se);
        }
    }

    static ClassFactory getClassFactory() throws SQLException {
        return ConnectionUtil.getCurrentLCC().getLanguageConnectionFactory().getClassFactory();
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule((Object)serviceModule, (String)factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private static Object findService(final String factoryInterface, final String serviceName) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.findService((String)factoryInterface, (String)serviceName);
            }
        });
    }
}

