/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationSchemeBase;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationService;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class LDAPAuthenticationSchemeImpl
extends JNDIAuthenticationSchemeBase {
    private static final String dfltLDAPURL = "ldap://";
    private String searchBaseDN;
    private String leftSearchFilter;
    private String rightSearchFilter;
    private boolean useUserPropertyAsDN;
    private String searchAuthDN;
    private String searchAuthPW;
    private static final String[] attrDN = new String[]{"dn"};
    private static final String LDAP_SEARCH_BASE = "derby.authentication.ldap.searchBase";
    private static final String LDAP_SEARCH_FILTER = "derby.authentication.ldap.searchFilter";
    private static final String LDAP_SEARCH_AUTH_DN = "derby.authentication.ldap.searchAuthDN";
    private static final String LDAP_SEARCH_AUTH_PW = "derby.authentication.ldap.searchAuthPW";
    private static final String LDAP_LOCAL_USER_DN = "derby.user";
    private static final String LDAP_SEARCH_FILTER_USERNAME = "%USERNAME%";

    public LDAPAuthenticationSchemeImpl(JNDIAuthenticationService as, Properties dbProperties) {
        super(as, dbProperties);
    }

    @Override
    public boolean authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
        if (userName == null || userName.length() == 0 || userPassword == null || userPassword.length() == 0) {
            return false;
        }
        try {
            Properties env = (Properties)this.initDirContextEnv.clone();
            String userDN = null;
            if (this.useUserPropertyAsDN) {
                userDN = this.authenticationService.getProperty("derby.user.");
            }
            if (userDN == (String)null) {
                userDN = this.getDNFromUID(userName);
            }
            if (SanityManager.DEBUG_ON(AuthenticationServiceBase.AuthenticationTrace)) {
                SanityManager.DEBUG(AuthenticationServiceBase.AuthenticationTrace, "User DN = [" + userDN + "]\n");
            }
            env.put("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", userPassword);
            DirContext ctx = this.privInitialDirContext(env);
            return true;
        }
        catch (AuthenticationException jndiae) {
            return false;
        }
        catch (NameNotFoundException jndinnfe) {
            return false;
        }
        catch (NamingException jndine) {
            NamingException e = jndine;
            throw LDAPAuthenticationSchemeImpl.getLoginSQLException(e);
        }
    }

    private DirContext privInitialDirContext(final Properties env) throws NamingException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<DirContext>(){

                @Override
                public DirContext run() throws NamingException {
                    return new InitialDirContext(env);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (NamingException)pae.getCause();
        }
    }

    @Override
    protected void setJNDIProviderProperties() {
        String ldapSearchBase;
        if (this.initDirContextEnv.getProperty("java.naming.factory.initial") == (String)null) {
            this.initDirContextEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (this.initDirContextEnv.getProperty("java.naming.provider.url") == (String)null) {
            String ldapServer = this.authenticationService.getProperty("derby.authentication.server");
            if (ldapServer == (String)null) {
                Monitor.logTextMessage("A011", "derby.authentication.server");
                this.providerURL = "ldap:///";
            } else {
                this.providerURL = ldapServer.startsWith(dfltLDAPURL) || ldapServer.startsWith("ldaps://") ? ldapServer : (ldapServer.startsWith("//") ? "ldap:" + ldapServer : dfltLDAPURL + ldapServer);
            }
            this.initDirContextEnv.put("java.naming.provider.url", this.providerURL);
        }
        if (this.initDirContextEnv.getProperty("java.naming.security.authentication") == (String)null) {
            this.initDirContextEnv.put("java.naming.security.authentication", "simple");
        }
        this.searchBaseDN = (ldapSearchBase = this.authenticationService.getProperty(LDAP_SEARCH_BASE)) != (String)null ? ldapSearchBase : "";
        this.searchAuthDN = this.authenticationService.getProperty(LDAP_SEARCH_AUTH_DN);
        this.searchAuthPW = this.authenticationService.getProperty(LDAP_SEARCH_AUTH_PW);
        String searchFilterProp = this.authenticationService.getProperty(LDAP_SEARCH_FILTER);
        if (searchFilterProp == (String)null) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        } else if (StringUtil.SQLEqualsIgnoreCase(searchFilterProp, LDAP_LOCAL_USER_DN)) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
            this.useUserPropertyAsDN = true;
        } else if (searchFilterProp.indexOf(LDAP_SEARCH_FILTER_USERNAME) != -1) {
            this.leftSearchFilter = searchFilterProp.substring(0, searchFilterProp.indexOf(LDAP_SEARCH_FILTER_USERNAME));
            this.rightSearchFilter = searchFilterProp.substring(searchFilterProp.indexOf(LDAP_SEARCH_FILTER_USERNAME) + LDAP_SEARCH_FILTER_USERNAME.length());
        } else {
            this.leftSearchFilter = "(&(" + searchFilterProp + ")(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        }
        if (SanityManager.DEBUG_ON(AuthenticationServiceBase.AuthenticationTrace)) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println("\n\n+ LDAP Authentication Configuration:\n   - provider URL [" + this.providerURL + "]\n   - search base [" + this.searchBaseDN + "]\n   - search filter to be [" + this.leftSearchFilter + "<uid>" + this.rightSearchFilter + "]\n   - use local DN [" + (this.useUserPropertyAsDN ? "true" : "false") + "]\n");
        }
        if (SanityManager.DEBUG_ON(AuthenticationServiceBase.AuthenticationTrace)) {
            FileOutputStream fos = null;
            try {
                fos = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws IOException {
                        return new FileOutputStream("DerbyLDAP.out");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (fos != null) {
                this.initDirContextEnv.put("com.sun.naming.ldap.trace.ber", fos);
            }
        }
    }

    private String getDNFromUID(String uid) throws NamingException {
        Properties env = null;
        if (this.searchAuthDN != (String)null) {
            env = (Properties)this.initDirContextEnv.clone();
            env.put("java.naming.security.principal", this.searchAuthDN);
            env.put("java.naming.security.credentials", this.searchAuthPW);
        } else {
            env = this.initDirContextEnv;
        }
        DirContext ctx = this.privInitialDirContext(env);
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(attrDN);
        String searchFilter = this.leftSearchFilter + uid + this.rightSearchFilter;
        NamingEnumeration<SearchResult> results = ctx.search(this.searchBaseDN, searchFilter, ctls);
        if (results == null || !results.hasMore()) {
            throw new NameNotFoundException();
        }
        SearchResult result = results.next();
        if (results.hasMore()) {
            if (SanityManager.DEBUG_ON(AuthenticationServiceBase.AuthenticationTrace)) {
                PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
                iDbgStream.println(" - LDAP Authentication request failure: search filter [" + searchFilter + "], retrieve more than one occurence in LDAP server [" + this.providerURL + "]");
            }
            throw new NameNotFoundException();
        }
        NameParser parser = ctx.getNameParser(this.searchBaseDN);
        Name userDN = parser.parse(this.searchBaseDN);
        if (userDN == (Name)null) {
            throw new NameNotFoundException();
        }
        userDN.addAll(parser.parse(result.getName()));
        return userDN.toString();
    }
}

