/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.local.WindowsFileName;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class WindowsFileNameTests
extends AbstractProviderTestCase {
    @Test
    public void testWindowsFileNameParserError() {
        try {
            String file = "file://////";
            DefaultFileSystemManager manager = this.getManager();
            Assertions.assertNotNull((Object)manager, (String)("Unexpected null manager for test " + (Object)((Object)this)));
            FileObject fo = manager.resolveFile("file://////");
            WindowsFileNameTests.fail((String)("Windows File Parser should not allow file:////// " + fo));
        }
        catch (FileSystemException ex) {
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider/invalid-absolute-uri.error", (String)ex.getCode());
            ex = (FileSystemException)ex.getCause();
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider.local/not-absolute-file-name.error", (String)ex.getCode());
        }
    }

    @Test
    public void testWindowsFileNameUNCStartError() {
        try {
            String file = "file://///";
            DefaultFileSystemManager manager = this.getManager();
            Assertions.assertNotNull((Object)manager, (String)("Unexpected null manager for test " + (Object)((Object)this)));
            FileObject fo = manager.resolveFile("file://///");
            WindowsFileNameTests.fail((String)("Windows File Parser should not allow file:///// " + fo));
        }
        catch (FileSystemException ex) {
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider/invalid-absolute-uri.error", (String)ex.getCode());
            ex = (FileSystemException)ex.getCause();
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider.local/missing-share-name.error", (String)ex.getCode());
        }
    }

    @Test
    public void testWindowsRoots() throws Exception {
        String[] tests;
        for (String name : tests = new String[]{"file:///C:/", "file://C:/", "file:/C:/", "file:C:/"}) {
            DefaultFileSystemManager manager = this.getManager();
            Assertions.assertNotNull((Object)manager, (String)("Unexpected null manager for test " + (Object)((Object)this)));
            FileName fn = manager.resolveFile(name).getName();
            WindowsFileNameTests.assertSame(WindowsFileName.class, (Object)fn.getClass());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.toString());
            WindowsFileNameTests.assertEquals((String)"/", (String)fn.getPath());
            WindowsFileNameTests.assertEquals((String)"/", (String)fn.getPathDecoded());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.getRootURI());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.getFriendlyURI());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.getRoot().toString());
            WindowsFileNameTests.assertEquals((String)"", (String)fn.getExtension());
            WindowsFileNameTests.assertEquals((String)"", (String)fn.getBaseName());
        }
    }

    @Test
    public void testWindowsWrongRoots() {
        String[] tests;
        for (String name : tests = new String[]{"file:///C:", "file://C:", "file:/C:", "file:C:"}) {
            try {
                DefaultFileSystemManager manager = this.getManager();
                Assertions.assertNotNull((Object)manager, (String)("Unexpected null manager for test " + (Object)((Object)this)));
                FileName fn = manager.resolveFile(name).getName();
                WindowsFileNameTests.fail((String)("should not accept root " + name));
            }
            catch (FileSystemException ex) {
                WindowsFileNameTests.assertEquals((String)"vfs.provider/invalid-absolute-uri.error", (String)ex.getCode());
                WindowsFileNameTests.assertTrue((boolean)ex.toString().contains(name));
            }
        }
    }
}

