/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReflectionToStringBuilderIncludeTest
extends AbstractLangTest {
    private static final String[] FIELDS = new String[]{"field1", "field2", "field3", "field4", "field5"};
    private static final String[] VALUES = new String[]{"value 1", "value 2", "value 3", "value 4", "value 5"};
    private static final String SINGLE_FIELD_TO_SHOW = FIELDS[2];
    private static final String SINGLE_FIELD_VALUE_TO_SHOW = VALUES[2];
    private static final String[] FIELDS_TO_SHOW = new String[]{FIELDS[0], FIELDS[3]};
    private static final String[] FIELDS_VALUES_TO_SHOW = new String[]{VALUES[0], VALUES[3]};

    ReflectionToStringBuilderIncludeTest() {
    }

    @Test
    void test_toStringDefaultBehavior() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)new TestFeature());
        String toString = builder.toString();
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringInclude() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])new String[]{SINGLE_FIELD_TO_SHOW});
        this.validateIncludeFieldsPresent(toString, new String[]{SINGLE_FIELD_TO_SHOW}, new String[]{SINGLE_FIELD_VALUE_TO_SHOW});
    }

    @Test
    void test_toStringIncludeArray() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])FIELDS_TO_SHOW);
        this.validateIncludeFieldsPresent(toString, FIELDS_TO_SHOW, FIELDS_VALUES_TO_SHOW);
    }

    @Test
    void test_toStringIncludeArrayWithNull() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])new String[]{null});
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeArrayWithNulls() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])new String[]{null, null});
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeCollection() {
        ArrayList<String> includeList = new ArrayList<String>();
        includeList.add(SINGLE_FIELD_TO_SHOW);
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), includeList);
        this.validateIncludeFieldsPresent(toString, new String[]{SINGLE_FIELD_TO_SHOW}, new String[]{SINGLE_FIELD_VALUE_TO_SHOW});
    }

    @Test
    void test_toStringIncludeCollectionWithNull() {
        ArrayList<Object> includeList = new ArrayList<Object>();
        includeList.add(null);
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), includeList);
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeCollectionWithNulls() {
        ArrayList<Object> includeList = new ArrayList<Object>();
        includeList.add(null);
        includeList.add(null);
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), includeList);
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeEmptyArray() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])ArrayUtils.EMPTY_STRING_ARRAY);
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeEmptyCollection() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), new ArrayList());
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeNullArray() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])null);
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeNullArrayMultiplesValues() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])new String[]{null, null, null, null});
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeNullCollection() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (Collection)null);
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringIncludeWithoutInformingFields() {
        String toString = ReflectionToStringBuilder.toStringInclude((Object)new TestFeature(), (String[])new String[0]);
        this.validateAllFieldsPresent(toString);
    }

    @Test
    void test_toStringSetIncludeAndExcludeWithIntersection() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)new TestFeature());
        builder.setExcludeFieldNames(new String[]{FIELDS[1], FIELDS[4]});
        builder.setIncludeFieldNames(new String[]{FIELDS[0], FIELDS[1]});
        Assertions.assertThrows(IllegalStateException.class, () -> builder.toString());
    }

    @Test
    void test_toStringSetIncludeAndExcludeWithoutIntersection() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)new TestFeature());
        builder.setExcludeFieldNames(new String[]{FIELDS[1], FIELDS[4]});
        builder.setIncludeFieldNames(FIELDS_TO_SHOW);
        String toString = builder.toString();
        this.validateIncludeFieldsPresent(toString, FIELDS_TO_SHOW, FIELDS_VALUES_TO_SHOW);
    }

    @Test
    void test_toStringSetIncludeAndExcludeWithRandomFieldsWithIntersection() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)new TestFeature());
        builder.setExcludeFieldNames(new String[]{FIELDS[1], "random1"});
        builder.setIncludeFieldNames(new String[]{"random1"});
        Assertions.assertThrows(IllegalStateException.class, () -> builder.toString());
    }

    @Test
    void test_toStringSetIncludeAndExcludeWithRandomFieldsWithoutIntersection() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)new TestFeature());
        builder.setExcludeFieldNames(new String[]{FIELDS[1], "random1"});
        builder.setIncludeFieldNames(new String[]{"random2", FIELDS[2]});
        String toString = builder.toString();
        this.validateIncludeFieldsPresent(toString, new String[]{FIELDS[2]}, new String[]{VALUES[2]});
    }

    @Test
    void test_toStringSetIncludeWithArrayWithMultipleNullFields() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)new TestFeature());
        builder.setExcludeFieldNames(new String[]{FIELDS[1], FIELDS[4]});
        builder.setIncludeFieldNames(new String[]{null, null, null});
        String toString = builder.toString();
        this.validateIncludeFieldsPresent(toString, new String[]{FIELDS[0], FIELDS[2], FIELDS[3]}, new String[]{VALUES[0], VALUES[2], VALUES[3]});
    }

    @Test
    void test_toStringSetIncludeWithMultipleNullFields() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)new TestFeature());
        builder.setExcludeFieldNames(new String[]{FIELDS[1], FIELDS[4]});
        builder.setIncludeFieldNames(new String[]{null, null, null});
        String toString = builder.toString();
        this.validateIncludeFieldsPresent(toString, new String[]{FIELDS[0], FIELDS[2], FIELDS[3]}, new String[]{VALUES[0], VALUES[2], VALUES[3]});
    }

    private void validateAllFieldsPresent(String toString) {
        this.validateIncludeFieldsPresent(toString, FIELDS, VALUES);
    }

    private void validateIncludeFieldsPresent(String toString, String[] fieldsToShow, String[] valuesToShow) {
        for (String includeField : fieldsToShow) {
            Assertions.assertTrue((toString.indexOf(includeField) > 0 ? 1 : 0) != 0);
        }
        for (String includeValue : valuesToShow) {
            Assertions.assertTrue((toString.indexOf(includeValue) > 0 ? 1 : 0) != 0);
        }
        this.validateNonIncludeFieldsAbsent(toString, fieldsToShow, valuesToShow);
    }

    private void validateNonIncludeFieldsAbsent(String toString, String[] IncludeFields, String[] IncludeFieldsValues) {
        String[] nonIncludeFields = (String[])ArrayUtils.removeElements((Object[])((String[])FIELDS.clone()), (Object[])IncludeFields);
        String[] nonIncludeFieldsValues = (String[])ArrayUtils.removeElements((Object[])((String[])VALUES.clone()), (Object[])IncludeFieldsValues);
        for (String nonIncludeField : nonIncludeFields) {
            Assertions.assertEquals((int)-1, (int)toString.indexOf(nonIncludeField));
        }
        for (String nonIncludeValue : nonIncludeFieldsValues) {
            Assertions.assertEquals((int)-1, (int)toString.indexOf(nonIncludeValue));
        }
    }

    static /* synthetic */ String[] access$000() {
        return VALUES;
    }

    final class TestFeature {
        private final String field1 = ReflectionToStringBuilderIncludeTest.access$000()[0];
        private final String field2 = ReflectionToStringBuilderIncludeTest.access$000()[1];
        private final String field3 = ReflectionToStringBuilderIncludeTest.access$000()[2];
        private final String field4 = ReflectionToStringBuilderIncludeTest.access$000()[3];
        private final String field5 = ReflectionToStringBuilderIncludeTest.access$000()[4];

        TestFeature() {
        }
    }
}

