/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.UnmodifiableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public IterableMap<K, V> makeFullMap() {
        HashMap m = new HashMap();
        this.addSampleMappings(m);
        return (IterableMap)UnmodifiableMap.unmodifiableMap(m);
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return (IterableMap)UnmodifiableMap.unmodifiableMap(new HashMap());
    }

    @Test
    public void testDecorateFactory() {
        IterableMap<K, V> map = this.makeFullMap();
        Assertions.assertSame(map, (Object)UnmodifiableMap.unmodifiableMap(map));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableMap.unmodifiableMap(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }
}

