/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.ObjectArrayIteratorTest;
import org.apache.commons.collections4.iterators.ObjectArrayListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectArrayListIteratorTest<E>
extends ObjectArrayIteratorTest<E> {
    public ObjectArrayListIterator<E> makeArrayListIterator(E[] array) {
        return new ObjectArrayListIterator((Object[])array);
    }

    @Override
    public ObjectArrayListIterator<E> makeEmptyIterator() {
        return new ObjectArrayListIterator(new Object[0]);
    }

    @Override
    public ObjectArrayListIterator<E> makeObject() {
        return new ObjectArrayListIterator((Object[])this.testArray);
    }

    @Test
    public void testListIterator() {
        ObjectArrayListIterator<E> iter = this.makeObject();
        while (iter.hasNext()) {
            iter.next();
        }
        for (int x = this.testArray.length - 1; x >= 0; --x) {
            String testValue = this.testArray[x];
            Object iterValue = iter.previous();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasPrevious(), (String)"Iterator should now be empty");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.previous());
    }

    @Test
    public void testListIteratorSet() {
        Object[] testData = new String[]{"a", "b", "c"};
        Object[] result = new String[]{"0", "1", "2"};
        ObjectArrayListIterator<Object> iter = this.makeArrayListIterator((Object[])testData);
        int x = 0;
        while (iter.hasNext()) {
            iter.next();
            iter.set(Integer.toString(x));
            ++x;
        }
        Assertions.assertArrayEquals((Object[])testData, (Object[])result, (String)"The two arrays should have the same value, i.e. {0,1,2}");
        ObjectArrayListIterator<Object> finalIter = iter = this.makeArrayListIterator((Object[])this.testArray);
        Assertions.assertThrows(IllegalStateException.class, () -> finalIter.set("should fail"), (String)"ListIterator#set should fail if next() or previous() have not yet been called.");
    }
}

