/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.beans.PropertyDescriptor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.PropertyUtils;

public class Jira357TestCase
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)Jira357TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira357TestCase.class);
    }

    public Jira357TestCase(String name) {
        super(name);
    }

    private void checkReadMethod(String propertyName, Class<?> expectedDeclaringClass) throws Exception {
        PropertyDescriptor[] descriptors = null;
        try {
            descriptors = PropertyUtils.getPropertyDescriptors(ConcreteTestBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            Jira357TestCase.fail((String)("Threw: " + e));
        }
        PropertyDescriptor descriptor = this.findDescriptor(propertyName, descriptors);
        Jira357TestCase.assertNotNull((String)(propertyName + "descriptor"), (Object)descriptor);
        Jira357TestCase.assertEquals((String)(propertyName + " read method declaring class"), expectedDeclaringClass, descriptor.getReadMethod().getDeclaringClass());
    }

    private PropertyDescriptor findDescriptor(String propertyName, PropertyDescriptor[] descriptors) {
        if (descriptors != null) {
            for (PropertyDescriptor descriptor : descriptors) {
                if (!propertyName.equals(descriptor.getName())) continue;
                return descriptor;
            }
        }
        return null;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPropertyUtils_getPropertyDescriptors_Bar() throws Exception {
    }

    public void testPropertyUtils_getPropertyDescriptors_Foo() throws Exception {
        this.checkReadMethod("foo", ConcreteTestBean.class);
    }

    public void testPropertyUtils_getPropertyDescriptors_InnerClassProperty() throws Exception {
        this.checkReadMethod("innerClassProperty", ConcreteTestBean.class);
    }

    public static class ConcreteTestBean
    extends AbstractTestBean {
        private String foo;
        private boolean bar;
        private AbstractTestBean.InnerClass innerClassProperty;

        @Override
        public String getFoo() {
            return this.foo;
        }

        @Override
        public AbstractTestBean.InnerClass getInnerClassProperty() {
            return this.innerClassProperty;
        }

        @Override
        public boolean isBar() {
            return this.bar;
        }

        @Override
        public void setBar(boolean bar) {
            this.bar = bar;
        }

        @Override
        public void setFoo(String foo) {
            this.foo = foo;
        }

        public void setInnerClassProperty(AbstractTestBean.InnerClass innerClassProperty) {
            this.innerClassProperty = innerClassProperty;
        }
    }

    public static abstract class AbstractTestBean {
        public abstract String getFoo();

        public abstract InnerClass getInnerClassProperty();

        public abstract boolean isBar();

        public abstract void setBar(boolean var1);

        public abstract void setFoo(String var1);

        public static abstract class InnerClass {
            private String firstName;

            public String getInnerName() {
                return this.firstName;
            }

            public void setInnerName(String firstName) {
                this.firstName = firstName;
            }
        }
    }
}

