/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.spring.rabbitmq.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;

class SpringRabbitmqProcessor {

    private static final String FEATURE = "camel-spring-rabbitmq";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void initProxies(BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) {
        proxies.produce(new NativeImageProxyDefinitionBuildItem(ChannelProxy.class.getCanonicalName()));
        proxies.produce(new NativeImageProxyDefinitionBuildItem(
                "org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer$ContainerDelegate",
                SpringProxy.class.getCanonicalName(), Advised.class.getCanonicalName(),
                /* Quarkus build time container cannot load DecoratingProxy via DecoratingProxy.class
                 * although it is present in camel-quarkus-support-spring-core that we depend on here.
                 * It works well with string though */
                "org.springframework.core.DecoratingProxy"));
    }
}
