/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Objects;
import org.apache.camel.v1.integrationspec.template.spec.volumes.EmptyDir;

public class EmptyDirFluent<A extends EmptyDirFluent<A>>
extends BaseFluent<A> {
    private String medium;
    private IntOrString sizeLimit;

    public EmptyDirFluent() {
    }

    public EmptyDirFluent(EmptyDir instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EmptyDir instance) {
        EmptyDir emptyDir = instance = instance != null ? instance : new EmptyDir();
        if (instance != null) {
            this.withMedium(instance.getMedium());
            this.withSizeLimit(instance.getSizeLimit());
        }
    }

    public String getMedium() {
        return this.medium;
    }

    public A withMedium(String medium) {
        this.medium = medium;
        return (A)((Object)this);
    }

    public boolean hasMedium() {
        return this.medium != null;
    }

    public IntOrString getSizeLimit() {
        return this.sizeLimit;
    }

    public A withSizeLimit(IntOrString sizeLimit) {
        this.sizeLimit = sizeLimit;
        return (A)((Object)this);
    }

    public boolean hasSizeLimit() {
        return this.sizeLimit != null;
    }

    public A withNewSizeLimit(Object value) {
        return this.withSizeLimit(new IntOrString(value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmptyDirFluent that = (EmptyDirFluent)((Object)o);
        if (!Objects.equals(this.medium, that.medium)) {
            return false;
        }
        return Objects.equals(this.sizeLimit, that.sizeLimit);
    }

    public int hashCode() {
        return Objects.hash(this.medium, this.sizeLimit, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.medium != null) {
            sb.append("medium:");
            sb.append(this.medium + ",");
        }
        if (this.sizeLimit != null) {
            sb.append("sizeLimit:");
            sb.append(this.sizeLimit);
        }
        sb.append("}");
        return sb.toString();
    }
}

