/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.camelcatalogspec.artifacts.schemes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.Producer;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer.Dependencies;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer.DependenciesBuilder;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer.DependenciesFluent;

public class ProducerFluent<A extends ProducerFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DependenciesBuilder> dependencies;

    public ProducerFluent() {
    }

    public ProducerFluent(Producer instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Producer instance) {
        Producer producer = instance = instance != null ? instance : new Producer();
        if (instance != null) {
            this.withDependencies(instance.getDependencies());
        }
    }

    public A addToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").add(index, builder);
            this.dependencies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
            this.dependencies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToProducerDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProducerDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromProducerDependencies(Predicate<DependenciesBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        Iterator<DependenciesBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            DependenciesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Dependencies> buildDependencies() {
        return this.dependencies != null ? ProducerFluent.build(this.dependencies) : null;
    }

    public Dependencies buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public Dependencies buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public Dependencies buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    public Dependencies buildMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<Dependencies> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").clear();
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList();
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(Dependencies ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public DependenciesNested<A> addNewDependency() {
        return new DependenciesNested(-1, null);
    }

    public DependenciesNested<A> addNewDependencyLike(Dependencies item) {
        return new DependenciesNested(-1, item);
    }

    public DependenciesNested<A> setNewDependencyLike(int index, Dependencies item) {
        return new DependenciesNested(index, item);
    }

    public DependenciesNested<A> editDependency(int index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    public DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProducerFluent that = (ProducerFluent)((Object)o);
        return Objects.equals(this.dependencies, that.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.dependencies, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DependenciesNested<N>
    extends DependenciesFluent<DependenciesNested<N>>
    implements Nested<N> {
        DependenciesBuilder builder;
        int index;

        DependenciesNested(int index, Dependencies item) {
            this.index = index;
            this.builder = new DependenciesBuilder(this, item);
        }

        public N and() {
            return (N)ProducerFluent.this.setToDependencies(this.index, this.builder.build());
        }

        public N endProducerDependency() {
            return this.and();
        }
    }
}

