/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks.builder;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.buildspec.tasks.builder.Runtime;
import org.apache.camel.v1.buildspec.tasks.builder.runtime.Capabilities;
import org.apache.camel.v1.buildspec.tasks.builder.runtime.Dependencies;
import org.apache.camel.v1.buildspec.tasks.builder.runtime.DependenciesBuilder;
import org.apache.camel.v1.buildspec.tasks.builder.runtime.DependenciesFluent;

public class RuntimeFluent<A extends RuntimeFluent<A>>
extends BaseFluent<A> {
    private String applicationClass;
    private Map<String, Capabilities> capabilities;
    private ArrayList<DependenciesBuilder> dependencies;
    private Map<String, String> metadata;
    private String provider;
    private String version;

    public RuntimeFluent() {
    }

    public RuntimeFluent(Runtime instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Runtime instance) {
        Runtime runtime = instance = instance != null ? instance : new Runtime();
        if (instance != null) {
            this.withApplicationClass(instance.getApplicationClass());
            this.withCapabilities(instance.getCapabilities());
            this.withDependencies(instance.getDependencies());
            this.withMetadata(instance.getMetadata());
            this.withProvider(instance.getProvider());
            this.withVersion(instance.getVersion());
        }
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public A withApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
        return (A)((Object)this);
    }

    public boolean hasApplicationClass() {
        return this.applicationClass != null;
    }

    public A addToCapabilities(String key, Capabilities value) {
        if (this.capabilities == null && key != null && value != null) {
            this.capabilities = new LinkedHashMap<String, Capabilities>();
        }
        if (key != null && value != null) {
            this.capabilities.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCapabilities(Map<String, Capabilities> map) {
        if (this.capabilities == null && map != null) {
            this.capabilities = new LinkedHashMap<String, Capabilities>();
        }
        if (map != null) {
            this.capabilities.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromCapabilities(String key) {
        if (this.capabilities == null) {
            return (A)((Object)this);
        }
        if (key != null && this.capabilities != null) {
            this.capabilities.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromCapabilities(Map<String, Capabilities> map) {
        if (this.capabilities == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capabilities == null) continue;
                this.capabilities.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Capabilities> getCapabilities() {
        return this.capabilities;
    }

    public <K, V> A withCapabilities(Map<String, Capabilities> capabilities) {
        this.capabilities = capabilities == null ? null : new LinkedHashMap<String, Capabilities>(capabilities);
        return (A)((Object)this);
    }

    public boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public A addToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").add(index, builder);
            this.dependencies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
            this.dependencies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDependencies(Predicate<DependenciesBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        Iterator<DependenciesBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            DependenciesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Dependencies> buildDependencies() {
        return this.dependencies != null ? RuntimeFluent.build(this.dependencies) : null;
    }

    public Dependencies buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public Dependencies buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public Dependencies buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    public Dependencies buildMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<Dependencies> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").clear();
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList();
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(Dependencies ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public DependenciesNested<A> addNewDependency() {
        return new DependenciesNested(-1, null);
    }

    public DependenciesNested<A> addNewDependencyLike(Dependencies item) {
        return new DependenciesNested(-1, item);
    }

    public DependenciesNested<A> setNewDependencyLike(int index, Dependencies item) {
        return new DependenciesNested(index, item);
    }

    public DependenciesNested<A> editDependency(int index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    public DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public A addToMetadata(String key, String value) {
        if (this.metadata == null && key != null && value != null) {
            this.metadata = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.metadata.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMetadata(Map<String, String> map) {
        if (this.metadata == null && map != null) {
            this.metadata = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.metadata.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromMetadata(String key) {
        if (this.metadata == null) {
            return (A)((Object)this);
        }
        if (key != null && this.metadata != null) {
            this.metadata.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMetadata(Map<String, String> map) {
        if (this.metadata == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metadata == null) continue;
                this.metadata.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public <K, V> A withMetadata(Map<String, String> metadata) {
        this.metadata = metadata == null ? null : new LinkedHashMap<String, String>(metadata);
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public String getProvider() {
        return this.provider;
    }

    public A withProvider(String provider) {
        this.provider = provider;
        return (A)((Object)this);
    }

    public boolean hasProvider() {
        return this.provider != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeFluent that = (RuntimeFluent)((Object)o);
        if (!Objects.equals(this.applicationClass, that.applicationClass)) {
            return false;
        }
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.applicationClass, this.capabilities, this.dependencies, this.metadata, this.provider, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationClass != null) {
            sb.append("applicationClass:");
            sb.append(this.applicationClass + ",");
        }
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.provider != null) {
            sb.append("provider:");
            sb.append(this.provider + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DependenciesNested<N>
    extends DependenciesFluent<DependenciesNested<N>>
    implements Nested<N> {
        DependenciesBuilder builder;
        int index;

        DependenciesNested(int index, Dependencies item) {
            this.index = index;
            this.builder = new DependenciesBuilder(this, item);
        }

        public N and() {
            return (N)RuntimeFluent.this.setToDependencies(this.index, this.builder.build());
        }

        public N endDependency() {
            return this.and();
        }
    }
}

