/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.IntegrationProfileStatus;
import org.apache.camel.v1.integrationprofilestatus.Build;
import org.apache.camel.v1.integrationprofilestatus.BuildBuilder;
import org.apache.camel.v1.integrationprofilestatus.BuildFluent;
import org.apache.camel.v1.integrationprofilestatus.Conditions;
import org.apache.camel.v1.integrationprofilestatus.ConditionsBuilder;
import org.apache.camel.v1.integrationprofilestatus.ConditionsFluent;
import org.apache.camel.v1.integrationprofilestatus.Kamelet;
import org.apache.camel.v1.integrationprofilestatus.KameletBuilder;
import org.apache.camel.v1.integrationprofilestatus.KameletFluent;
import org.apache.camel.v1.integrationprofilestatus.Traits;
import org.apache.camel.v1.integrationprofilestatus.TraitsBuilder;
import org.apache.camel.v1.integrationprofilestatus.TraitsFluent;

public class IntegrationProfileStatusFluent<A extends IntegrationProfileStatusFluent<A>>
extends BaseFluent<A> {
    private BuildBuilder build;
    private ArrayList<ConditionsBuilder> conditions;
    private KameletBuilder kamelet;
    private Long observedGeneration;
    private String phase;
    private TraitsBuilder traits;

    public IntegrationProfileStatusFluent() {
    }

    public IntegrationProfileStatusFluent(IntegrationProfileStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IntegrationProfileStatus instance) {
        IntegrationProfileStatus integrationProfileStatus = instance = instance != null ? instance : new IntegrationProfileStatus();
        if (instance != null) {
            this.withBuild(instance.getBuild());
            this.withConditions(instance.getConditions());
            this.withKamelet(instance.getKamelet());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withTraits(instance.getTraits());
        }
    }

    public Build buildBuild() {
        return this.build != null ? this.build.build() : null;
    }

    public A withBuild(Build build) {
        this._visitables.remove((Object)"build");
        if (build != null) {
            this.build = new BuildBuilder(build);
            this._visitables.get((Object)"build").add(this.build);
        } else {
            this.build = null;
            this._visitables.get((Object)"build").remove((Object)this.build);
        }
        return (A)((Object)this);
    }

    public boolean hasBuild() {
        return this.build != null;
    }

    public BuildNested<A> withNewBuild() {
        return new BuildNested(null);
    }

    public BuildNested<A> withNewBuildLike(Build item) {
        return new BuildNested(item);
    }

    public BuildNested<A> editIntegrationprofilestatusBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(null));
    }

    public BuildNested<A> editOrNewBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(new BuildBuilder().build()));
    }

    public BuildNested<A> editOrNewBuildLike(Build item) {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(item));
    }

    public A addToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Conditions ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationprofilestatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Conditions ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationprofilestatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationprofilestatusConditions(Predicate<ConditionsBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionsBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Conditions> buildConditions() {
        return this.conditions != null ? IntegrationProfileStatusFluent.build(this.conditions) : null;
    }

    public Conditions buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Conditions buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Conditions buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Conditions> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Conditions ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Conditions item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Conditions item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Kamelet buildKamelet() {
        return this.kamelet != null ? this.kamelet.build() : null;
    }

    public A withKamelet(Kamelet kamelet) {
        this._visitables.remove((Object)"kamelet");
        if (kamelet != null) {
            this.kamelet = new KameletBuilder(kamelet);
            this._visitables.get((Object)"kamelet").add(this.kamelet);
        } else {
            this.kamelet = null;
            this._visitables.get((Object)"kamelet").remove((Object)this.kamelet);
        }
        return (A)((Object)this);
    }

    public boolean hasKamelet() {
        return this.kamelet != null;
    }

    public KameletNested<A> withNewKamelet() {
        return new KameletNested(null);
    }

    public KameletNested<A> withNewKameletLike(Kamelet item) {
        return new KameletNested(item);
    }

    public KameletNested<A> editIntegrationprofilestatusKamelet() {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(null));
    }

    public KameletNested<A> editOrNewKamelet() {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(new KameletBuilder().build()));
    }

    public KameletNested<A> editOrNewKameletLike(Kamelet item) {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(item));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public Traits buildTraits() {
        return this.traits != null ? this.traits.build() : null;
    }

    public A withTraits(Traits traits) {
        this._visitables.remove((Object)"traits");
        if (traits != null) {
            this.traits = new TraitsBuilder(traits);
            this._visitables.get((Object)"traits").add(this.traits);
        } else {
            this.traits = null;
            this._visitables.get((Object)"traits").remove((Object)this.traits);
        }
        return (A)((Object)this);
    }

    public boolean hasTraits() {
        return this.traits != null;
    }

    public TraitsNested<A> withNewTraits() {
        return new TraitsNested(null);
    }

    public TraitsNested<A> withNewTraitsLike(Traits item) {
        return new TraitsNested(item);
    }

    public TraitsNested<A> editIntegrationprofilestatusTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(null));
    }

    public TraitsNested<A> editOrNewTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(new TraitsBuilder().build()));
    }

    public TraitsNested<A> editOrNewTraitsLike(Traits item) {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationProfileStatusFluent that = (IntegrationProfileStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.build, (Object)that.build)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.kamelet, (Object)that.kamelet)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        return Objects.equals((Object)this.traits, (Object)that.traits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.build, this.conditions, this.kamelet, this.observedGeneration, this.phase, this.traits, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.build != null) {
            sb.append("build:");
            sb.append(this.build + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.kamelet != null) {
            sb.append("kamelet:");
            sb.append(this.kamelet + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.traits != null) {
            sb.append("traits:");
            sb.append((Object)this.traits);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BuildNested<N>
    extends BuildFluent<BuildNested<N>>
    implements Nested<N> {
        BuildBuilder builder;

        BuildNested(Build item) {
            this.builder = new BuildBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationProfileStatusFluent.this.withBuild(this.builder.build());
        }

        public N endIntegrationprofilestatusBuild() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionsFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionsBuilder builder;
        int index;

        ConditionsNested(int index, Conditions item) {
            this.index = index;
            this.builder = new ConditionsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationProfileStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endIntegrationprofilestatusCondition() {
            return this.and();
        }
    }

    public class KameletNested<N>
    extends KameletFluent<KameletNested<N>>
    implements Nested<N> {
        KameletBuilder builder;

        KameletNested(Kamelet item) {
            this.builder = new KameletBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationProfileStatusFluent.this.withKamelet(this.builder.build());
        }

        public N endIntegrationprofilestatusKamelet() {
            return this.and();
        }
    }

    public class TraitsNested<N>
    extends TraitsFluent<TraitsNested<N>>
    implements Nested<N> {
        TraitsBuilder builder;

        TraitsNested(Traits item) {
            this.builder = new TraitsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationProfileStatusFluent.this.withTraits(this.builder.build());
        }

        public N endIntegrationprofilestatusTraits() {
            return this.and();
        }
    }
}

