/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.CsiBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.csi.NodePublishSecretRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"driver", "fsType", "nodePublishSecretRef", "readOnly", "volumeAttributes"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Csi
implements Editable<CsiBuilder>,
KubernetesResource {
    @JsonProperty(value="driver")
    @Required
    @JsonPropertyDescription(value="driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String driver;
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType to mount. Ex. \"ext4\", \"xfs\", \"ntfs\". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="nodePublishSecretRef")
    @JsonPropertyDescription(value="nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.")
    @JsonSetter(nulls=Nulls.SKIP)
    private NodePublishSecretRef nodePublishSecretRef;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly specifies a read-only configuration for the volume. Defaults to false (read/write).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="volumeAttributes")
    @JsonPropertyDescription(value="volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> volumeAttributes;

    public CsiBuilder edit() {
        return new CsiBuilder(this);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public NodePublishSecretRef getNodePublishSecretRef() {
        return this.nodePublishSecretRef;
    }

    public void setNodePublishSecretRef(NodePublishSecretRef nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public void setVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
    }

    public String toString() {
        return "Csi(driver=" + this.getDriver() + ", fsType=" + this.getFsType() + ", nodePublishSecretRef=" + this.getNodePublishSecretRef() + ", readOnly=" + this.getReadOnly() + ", volumeAttributes=" + this.getVolumeAttributes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Csi)) {
            return false;
        }
        Csi other = (Csi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$fsType = this.getFsType();
        String other$fsType = other.getFsType();
        if (this$fsType == null ? other$fsType != null : !this$fsType.equals(other$fsType)) {
            return false;
        }
        NodePublishSecretRef this$nodePublishSecretRef = this.getNodePublishSecretRef();
        NodePublishSecretRef other$nodePublishSecretRef = other.getNodePublishSecretRef();
        if (this$nodePublishSecretRef == null ? other$nodePublishSecretRef != null : !((Object)this$nodePublishSecretRef).equals(other$nodePublishSecretRef)) {
            return false;
        }
        Map<String, String> this$volumeAttributes = this.getVolumeAttributes();
        Map<String, String> other$volumeAttributes = other.getVolumeAttributes();
        return !(this$volumeAttributes == null ? other$volumeAttributes != null : !((Object)this$volumeAttributes).equals(other$volumeAttributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Csi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        String $fsType = this.getFsType();
        result = result * 59 + ($fsType == null ? 43 : $fsType.hashCode());
        NodePublishSecretRef $nodePublishSecretRef = this.getNodePublishSecretRef();
        result = result * 59 + ($nodePublishSecretRef == null ? 43 : ((Object)$nodePublishSecretRef).hashCode());
        Map<String, String> $volumeAttributes = this.getVolumeAttributes();
        result = result * 59 + ($volumeAttributes == null ? 43 : ((Object)$volumeAttributes).hashCode());
        return result;
    }
}

